/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.editor;

import com.rameses.rcp.constant.TextCase;
import java.awt.Color;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class FormulaDocument
extends DefaultStyledDocument {
    private List<String> keywords;
    private TextCase textCase = TextCase.NONE;
    private boolean dirty;
    private Style style = this.addStyle("Default-Style", null);
    private Style varStyle = this.addStyle("Variable-Style", this.style);
    private Style amtStyle;

    public FormulaDocument() {
        StyleConstants.setForeground(this.varStyle, new Color(0, 0, 102));
        StyleConstants.setBold(this.varStyle, true);
        this.amtStyle = this.addStyle("Amount-Style", this.style);
        StyleConstants.setForeground(this.amtStyle, new Color(204, 0, 0));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public TextCase getTextCase() {
        return this.textCase;
    }

    public void setTextCase(TextCase textCase) {
        this.textCase = textCase == null ? TextCase.NONE : textCase;
        try {
            String string = this.getText(0, this.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final String getTextCaseAsString() {
        TextCase tc = this.getTextCase();
        return tc == null ? null : tc.toString();
    }

    public final void setTextCaseAsString(String sTextCase) {
        try {
            this.setTextCase(TextCase.valueOf(sTextCase.toUpperCase()));
        }
        catch (Exception ex) {
            this.setTextCase(null);
        }
    }

    public void setValue(Object value, AttributeSet attr) throws Exception {
        super.remove(0, this.getLength());
        this.insertString(0, value == null ? "" : value.toString(), attr);
        this.dirty = false;
        this.updateCharacterAttributes();
    }

    public List<String> getKeywords() {
        if (this.keywords != null) {
            return this.keywords;
        }
        this.keywords = new ArrayList<String>(){

            @Override
            public boolean add(String str) {
                return super.add(str == null ? null : FormulaDocument.this.getTextCase().convert(str));
            }

            @Override
            public boolean addAll(Collection<? extends String> col) {
                ArrayList<String> list = new ArrayList<String>();
                for (String string : col) {
                    list.add(FormulaDocument.this.getTextCase().convert(string));
                }
                return super.addAll(list);
            }
        };
        return this.keywords;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (Beans.isDesignTime()) {
            super.insertString(offs, str, a);
            return;
        }
        super.insertString(offs, this.getTextCase().convert(str), this.style);
        this.dirty = true;
        this.updateCharacterAttributes();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (Beans.isDesignTime()) {
            super.remove(offs, len);
            return;
        }
        super.remove(offs, len);
        this.updateCharacterAttributes();
    }

    private void updateCharacterAttributes() throws BadLocationException {
        StringBuffer sb = new StringBuffer(this.getText(0, this.getLength()));
        StringBuffer buffer = new StringBuffer();
        int offset = -1;
        for (int i = 0; i < sb.length(); ++i) {
            if (offset == -1) {
                offset = i;
            }
            char ch = sb.charAt(i);
            buffer.append(ch);
            if ((ch + "").matches("[^\\w_]")) {
                buffer.delete(0, buffer.length());
                offset = -1;
                continue;
            }
            this.applyStyle(buffer, offset);
        }
    }

    private void applyStyle(StringBuffer buffer, int offset) {
        String str = buffer.toString();
        if (this.getKeywords().contains(str)) {
            this.setCharacterAttributes(offset, buffer.length(), this.varStyle, true);
        } else if (str.matches("(\\d+)(\\.?\\d+)?")) {
            this.setCharacterAttributes(offset, buffer.length(), this.amtStyle, true);
        } else {
            this.setCharacterAttributes(offset, buffer.length(), this.style, true);
        }
    }
}

