/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.date;

import com.rameses.rcp.control.XDateField;
import com.rameses.rcp.control.date.AbstractCalendarModel;
import com.rameses.rcp.control.date.MonthCalendarRenderer;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class DatePickerModel
extends AbstractCalendarModel {
    private MonthCalendarRenderer dpUI = new MonthCalendarRenderer(this);
    private JPopupMenu popup = new JPopupMenu();
    private SimpleDateFormat outputFormatter;
    private SimpleDateFormat inputFormatter;
    private XDateField parent;

    public DatePickerModel(XDateField parent) {
        this();
        this.parent = parent;
        this.outputFormatter = new SimpleDateFormat(parent.getOutputFormat());
        this.inputFormatter = new SimpleDateFormat(parent.getInputFormat());
    }

    public DatePickerModel() {
        this.dpUI.setSelectedBackgroundColor(Color.DARK_GRAY);
        this.dpUI.setSelectedFontColor(Color.WHITE);
        this.dpUI.setListener(new MonthCalendarRenderer.Listener(){

            @Override
            public void onSelect(Object value) {
                DatePickerModel.this.hideCalendar();
            }
        });
        this.popup.add(this.dpUI);
    }

    @Override
    public String getSelectedValue() {
        return this.dpUI.getSelectedValue();
    }

    public void setSelectedValue(String value) {
        try {
            Date d = this.inputFormatter.parse(value);
            this.parent.setText(this.inputFormatter.format(d));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void hideCalendar() {
        this.popup.setVisible(false);
    }

    @Override
    public void showCalendar() {
        this.popup.show(this.parent, 0, this.parent.getHeight() - 1);
        this.popup.setVisible(true);
    }

    @Override
    public JComponent getCalendar() {
        return this.dpUI;
    }
}

