/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class XUnderlineBorder
extends AbstractBorder {
    private Color lineColor = Color.LIGHT_GRAY;
    private int thickness = 1;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(this.thickness));
        g2.setColor(this.lineColor);
        g2.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = new Insets(0, 0, 0, 0);
        this.getBorderInsets(c, insets);
        return insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = 0;
        insets.left = 0;
        insets.top = 0;
        insets.bottom = this.thickness;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }
}

