/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class XTitledBorder
extends AbstractBorder {
    private String title = "Title";
    private Color background;
    private Color titleBackground;
    private Color titleForeground;
    private Insets titlePadding = new Insets(2, 4, 2, 4);
    private Insets padding;
    private Font font = Font.decode("Arial-Bold-11");
    private Color outline;
    private Color outlineShadow;
    private Component comp;

    public XTitledBorder() {
        this.background = new Color(232, 232, 226);
        this.titleBackground = new Color(167, 156, 146);
        this.titleForeground = Color.WHITE;
        this.outline = new Color(204, 204, 204);
        this.outlineShadow = new Color(204, 204, 204);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.comp = c;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x2 = 0;
        int y2 = 0;
        if (this.background != null) {
            g2.setColor(this.background);
            g2.fillRect(x, y, width - 3, height - 3);
        }
        g2.setColor(this.outline);
        g2.drawRect(x, y, width - 3, height - 3);
        Color shadow = this.outlineShadow;
        for (int i = 1; i < 3; ++i) {
            g2.setColor(new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 40 * i));
            x2 = width - i;
            y2 = height - i;
            g2.drawLine(x + 2, y2, x2, y2);
            g2.drawLine(x2, y + 2, x2, y2);
        }
        if (this.title == null || this.title.equals("")) {
            return;
        }
        g2.setFont(this.font);
        Insets padding = this.titlePadding;
        FontMetrics fm = g2.getFontMetrics();
        String stitle = "  " + this.title + "  ";
        int strWidth = fm.stringWidth(stitle);
        y2 = y + fm.getHeight() + padding.top + padding.bottom;
        x2 = x + strWidth + padding.left + padding.right;
        Polygon poly = new Polygon();
        poly.addPoint(x, y);
        poly.addPoint(x, y2);
        poly.addPoint(x2, y2);
        poly.addPoint(x2 + 10, y);
        g2.setColor(new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 60));
        g2.drawLine(x + 1, y2 + 1, x2 - 2, y2 + 1);
        g2.setColor(new Color(shadow.getRed(), shadow.getGreen(), shadow.getBlue(), 40));
        g2.drawLine(x + 1, y2 + 2, x2 - 2, y2 + 2);
        g2.setColor(this.titleBackground);
        g2.fillPolygon(poly);
        g2.setColor(this.outline);
        g2.drawPolygon(poly);
        g2.setColor(this.titleForeground);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.drawString(stitle, x + padding.left, y + padding.top + (fm.getHeight() - fm.getDescent()));
        g2.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        FontMetrics fm = c.getFontMetrics(this.font);
        Insets p = this.titlePadding;
        if (this.padding == null) {
            return new Insets(fm.getHeight() + p.top + p.bottom + 3, 1, 3, 3);
        }
        return this.padding;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleBackground(Color titleBackground) {
        this.titleBackground = titleBackground;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getOutline() {
        return this.outline;
    }

    public void setOutline(Color outline) {
        this.outline = outline;
    }

    public Color getOutlineShadow() {
        return this.outlineShadow;
    }

    public void setOutlineShadow(Color outlineShadow) {
        this.outlineShadow = outlineShadow;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setTitleForeground(Color titleForeground) {
        this.titleForeground = titleForeground;
    }

    public Insets getTitlePadding() {
        return this.titlePadding;
    }

    public void setTitlePadding(Insets titlePadding) {
        this.titlePadding = titlePadding;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Insets getPadding() {
        if (this.padding == null && this.comp != null) {
            FontMetrics fm = this.comp.getFontMetrics(this.font);
            Insets p = this.titlePadding;
            if (this.padding == null) {
                return new Insets(fm.getHeight() + p.top + p.bottom + 3, 1, 3, 3);
            }
        }
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }
}

