/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class XSeparatorBorder
extends AbstractBorder {
    private String title;
    private Color color = Color.BLACK;
    private Insets padding;
    private int descent = 0;
    private int ascent = 16;
    private int height = 16;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding == null ? new Insets(0, 0, 0, 0) : padding;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        if (ins == null) {
            ins = new Insets(0, 0, 0, 0);
        }
        ins.right = 0;
        ins.bottom = 0;
        ins.left = 0;
        ins.top = 0;
        String title = this.getTitle();
        if (title != null) {
            FontMetrics fm;
            Font font = c.getFont();
            try {
                if (font == null) {
                    font = UIManager.getLookAndFeelDefaults().getFont("Label.font");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (font == null) {
                font = Font.decode("-plain-");
            }
            if ((fm = c.getFontMetrics(font)) != null) {
                this.descent = fm.getDescent();
                this.ascent = fm.getAscent();
                this.height = fm.getHeight();
                ins.top += this.ascent + this.descent;
            }
        }
        if (this.padding == null) {
            this.padding = new Insets(0, 0, 0, 0);
        }
        ins.top += this.padding.top;
        ins.left += this.padding.left;
        ins.bottom += this.padding.bottom;
        ins.right += this.padding.right;
        return ins;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        Color newColor = this.getColor();
        if (newColor == null) {
            newColor = Color.BLACK;
        }
        Color shadColor = this.getShadowColor(c);
        Color highColor = this.getHighlightColor(c);
        int ny = y;
        String title = this.getTitle();
        if (title != null) {
            ny = Math.max((this.ascent + this.descent) / 2, 0);
        }
        g2.setColor(shadColor);
        g2.drawLine(x, y, width, y);
        g2.setColor(highColor);
        g2.drawLine(x, y + 1, width, y + 1);
        g2.setColor(newColor);
        if (title != null) {
            g.drawString(title, 0, 0);
        }
        g2.setColor(oldColor);
        g2.dispose();
    }

    protected Color getHighlightColor(Component c) {
        return c.getBackground().brighter();
    }

    protected Color getShadowColor(Component c) {
        return c.getBackground().darker();
    }
}

