/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import com.rameses.rcp.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.border.AbstractBorder;

public class CSSBorder
extends AbstractBorder {
    private List<Painter> painters = new ArrayList<Painter>();
    private Insets margin = new Insets(0, 0, 0, 0);
    private Insets painterMargin = new Insets(0, 0, 0, 0);

    public static synchronized CSSBorder parse(String text) {
        CSSBorder border = new CSSBorder();
        border.parseImpl(text);
        return border;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets pm = new Insets(0, 0, 0, 0);
        for (Painter p : this.painters) {
            Insets ins = p.getBorderInsets();
            if (ins.top >= 0) {
                pm.top = ins.top;
            }
            if (ins.left >= 0) {
                pm.left = ins.left;
            }
            if (ins.bottom >= 0) {
                pm.bottom = ins.bottom;
            }
            if (ins.right < 0) continue;
            pm.right = ins.right;
        }
        insets.top = pm.top;
        insets.left = pm.left;
        insets.bottom = pm.bottom;
        insets.right = pm.right;
        this.painterMargin = pm;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        for (Painter painter : this.painters) {
            painter.paintBorder(c, g, x, y, w, h, this.painterMargin);
        }
    }

    private Insets copy(Insets padding) {
        if (padding == null) {
            return new Insets(0, 0, 0, 0);
        }
        return new Insets(padding.top, padding.left, padding.bottom, padding.right);
    }

    private void parseImpl(String text) {
        if (text == null) {
            return;
        }
        Scanner scanner = new Scanner(text);
        scanner.useDelimiter(";");
        while (scanner.hasNext()) {
            int idx;
            String s = scanner.next().toLowerCase().trim();
            if (!s.startsWith("border") || (idx = s.indexOf(58)) <= 0) continue;
            this.painters.add(new Painter(s));
        }
    }

    private class Painter {
        private String name;
        private int thickness;
        private String style;
        private Color color;

        public Painter(String text) {
            int idx = text.indexOf(58);
            this.name = text.substring(0, idx);
            String[] params = text.substring(idx + 1).split(" ");
            if ("none".equals(params[0])) {
                this.name = "border-none";
            }
            if (params.length > 0) {
                this.thickness = this.toInt(params[0]);
            }
            if (params.length > 1) {
                this.style = params[1].trim();
            }
            if (params.length > 2) {
                this.color = this.toColor(params[2].trim());
            }
            if (this.color == null) {
                this.color = Color.BLACK;
            }
        }

        private Insets getBorderInsets() {
            Insets ins = new Insets(-1, -1, -1, -1);
            if (this.name.equals("border")) {
                ins.bottom = ins.right = this.thickness;
                ins.left = ins.right;
                ins.top = ins.right;
            } else if (this.name.equals("border-top")) {
                ins.top = this.thickness;
            } else if (this.name.equals("border-left")) {
                ins.left = this.thickness;
            } else if (this.name.equals("border-bottom")) {
                ins.bottom = this.thickness;
            } else if (this.name.equals("border-right")) {
                ins.right = this.thickness;
            } else if (this.name.equals("border-none")) {
                ins = new Insets(0, 0, 0, 0);
            }
            return ins;
        }

        private void paintBorder(Component c, Graphics g, int x, int y, int w, int h, Insets pm) {
            Color oldColor = g.getColor();
            if (this.name.equals("border-none") || this.color == null) {
                g.setColor(oldColor);
                g.drawRect(0, 0, w, h);
            } else if (this.name.equals("border")) {
                g.setColor(oldColor);
                g.drawRect(0, 0, w, h);
                g.setColor(this.color);
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(i + 1, i + 1, w - i, i + 1);
                    g.drawLine(i + 1, i + 1, i + 1, h - i - 1);
                    g.drawLine(w - i, i + 1, w - i, h - i - 1);
                    g.drawLine(i + 1, h - i - 1, w - i, h - i - 1);
                }
            } else if (this.name.equals("border-top")) {
                int i;
                g.setColor(oldColor);
                for (i = 0; i < pm.top; ++i) {
                    g.drawLine(0, i, w, i);
                }
                g.setColor(this.color);
                for (i = 0; i < this.thickness; ++i) {
                    g.drawLine(0, i, w, i);
                }
            } else if (this.name.equals("border-left")) {
                int i;
                g.setColor(oldColor);
                for (i = 0; i < pm.left; ++i) {
                    g.drawLine(i, 0, i, h);
                }
                g.setColor(this.color);
                for (i = 0; i < this.thickness; ++i) {
                    g.drawLine(i, 0, i, h);
                }
            } else if (this.name.equals("border-bottom")) {
                int i;
                g.setColor(oldColor);
                for (i = 0; i < pm.bottom; ++i) {
                    g.drawLine(0, h - i - 1, w, h - i - 1);
                }
                g.setColor(this.color);
                for (i = 0; i < this.thickness; ++i) {
                    g.drawLine(0, h - i - 1, w, h - i - 1);
                }
            } else if (this.name.equals("border-right")) {
                int i;
                g.setColor(oldColor);
                for (i = 0; i < pm.right; ++i) {
                    g.drawLine(w - i, 0, w - i, h);
                }
                g.setColor(this.color);
                for (i = 0; i < this.thickness; ++i) {
                    g.drawLine(w - i, 0, w - i, h);
                }
            }
            g.setColor(oldColor);
        }

        private int toInt(String value) {
            try {
                return Integer.parseInt(value.replaceAll("px", "").replaceAll("pt", "").trim());
            }
            catch (Exception ex) {
                return 0;
            }
        }

        private Color toColor(String value) {
            return ColorUtil.decode(value);
        }
    }
}

