/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.AbstractTreeNodeModel;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.NodeFilter;
import com.rameses.rcp.common.NodeListener;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NavigatablePanel;
import com.rameses.rcp.framework.NavigationHandler;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UICommandUtil;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class XTree
extends JTree
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private DefaultProvider provider = new DefaultProvider();
    private TreeEventSupport eventSupport = new TreeEventSupport();
    private Binding binding;
    private String[] depends;
    private String handler;
    private Object handlerObject;
    private boolean dynamic;
    private int index;
    private NodeTreeRenderer renderer;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;
    private TreeNodeModel nodeModel;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;
    private JPopupMenu popup;

    public XTree() {
        this.initComponents();
    }

    private void initComponents() {
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new TreeCellRendererImpl());
        super.addTreeSelectionListener(this.eventSupport);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "openNode");
        this.getActionMap().put("openNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XTree.this.fireOpenSelectedNode(true);
            }
        });
        new MouseEventSupport(this).install();
        this.setBorder(BorderFactory.createEmptyBorder(3, 2, 0, 0));
        this.addAncestorListener(new AncestorListener(){
            private boolean inited;

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (this.inited) {
                    return;
                }
                this.inited = true;
                XTree owner = XTree.this;
                Container parent = owner.getParent();
                if (parent instanceof JViewport) {
                    JViewport jv = (JViewport)parent;
                    jv.setBackground(owner.getBackground());
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }

    @Override
    protected void fireValueChanged(TreeSelectionEvent e) {
        DefaultNode newnode;
        TreePath newpath = e.getNewLeadSelectionPath();
        if (newpath != null && (newnode = (DefaultNode)newpath.getLastPathComponent()).request_to_open && this.nodeModel != null && this.nodeModel.isAllowOpenOnSingleClick()) {
            this.fireOpenSelectedNode(true, newnode);
        }
        super.fireValueChanged(e);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public void refresh() {
        DefaultNode dn;
        if (this.getModel().getRoot() instanceof DefaultNode && (dn = (DefaultNode)this.getModel().getRoot()).getNode() != null) {
            dn.getNode().refresh();
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        block10: {
            try {
                String shandler;
                Object obj = this.getHandlerObject();
                if (obj instanceof String) {
                    obj = UIControlUtil.getBeanValue(this, obj.toString());
                }
                if ((shandler = this.getHandler()) != null) {
                    obj = UIControlUtil.getBeanValue(this, shandler);
                }
                if (obj == null) {
                    throw new Exception("A handler must be provided");
                }
                this.nodeModel = (TreeNodeModel)obj;
            }
            catch (Exception ex) {
                this.nodeModel = new DummyTreeNodeModel();
                if (!ClientContext.getCurrentContext().isDebugMode()) break block10;
                ex.printStackTrace();
            }
        }
        this.nodeModel.setProvider(this.provider);
        Node rootNode = this.nodeModel.getRootNode();
        if (rootNode == null) {
            rootNode = new Node("root", "");
            this.setRootVisible(false);
        } else {
            this.setRootVisible(this.nodeModel.isRootVisible());
        }
        this.root = new DefaultNode(rootNode);
        this.model = new DefaultTreeModel(this.root, true);
        this.model.setAsksAllowsChildren(true);
        this.setModel(this.model);
        if (this.nodeModel.isAutoSelect()) {
            try {
                this.setSelectionRow(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fireOpenSelectedNode(true);
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("handler", this.getHandler());
        map.put("handlerObject", this.getHandlerObject());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener handler) {
        this.eventSupport.remove(handler);
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener handler) {
        this.eventSupport.add(handler);
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        DefaultNode newnode;
        TreePath newpath;
        if (me.getID() == 501) {
            if (SwingUtilities.isLeftMouseButton(me) && me.getClickCount() == 1 && (newpath = this.getPathForLocation(me.getX(), me.getY())) != null) {
                newnode = (DefaultNode)newpath.getLastPathComponent();
                DefaultNode oldnode = this.getSelectedNode();
                if (newnode != null && !newnode.equals(oldnode)) {
                    newnode.request_to_open = true;
                }
            }
        } else if (me.getID() == 500 && SwingUtilities.isLeftMouseButton(me) && me.getClickCount() == 2 && (newpath = this.getPathForLocation(me.getX(), me.getY())) != null && (newnode = (DefaultNode)newpath.getLastPathComponent()).request_to_open) {
            this.fireOpenSelectedNode(true, newnode);
        }
        super.processMouseEvent(me);
        if (me.getID() == 500 && SwingUtilities.isRightMouseButton(me) && me.getClickCount() == 1 && (newpath = this.getPathForLocation(me.getX(), me.getY())) != null) {
            PopupMenuOpener menu;
            TreePath selPath = this.getSelectionPath();
            if (selPath == null || !selPath.equals(newpath)) {
                this.setSelectionPath(newpath);
            }
            DefaultNode selNode = (DefaultNode)newpath.getLastPathComponent();
            PopupMenuOpener popupMenuOpener = menu = this.nodeModel == null ? null : this.nodeModel.getContextMenu(selNode.getNode());
            if (menu != null && menu instanceof PopupMenuOpener) {
                final int xpos = me.getX();
                final int ypos = me.getY();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XTree.this.show((PopupMenuOpener)menu, xpos, ypos);
                    }
                });
            }
        }
    }

    private void fireOpenSelectedNode(boolean forcely) {
        DefaultNode selNode = this.getSelectedNode();
        this.fireOpenSelectedNode(forcely, selNode);
    }

    private void fireOpenSelectedNode(boolean forcely, final DefaultNode selNode) {
        if (selNode == null) {
            return;
        }
        if (!selNode.hasChanged && !forcely) {
            return;
        }
        selNode.hasChanged = false;
        selNode.request_to_open = false;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XTree.this.openNode(selNode.getNode());
                }
                catch (Exception ex) {
                    MsgBox.err(ex);
                }
            }
        });
    }

    private DefaultNode getSelectedNode() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (DefaultNode)treePath.getLastPathComponent();
    }

    private void openNode(Node node) {
        Object retVal = null;
        if (node != null) {
            retVal = node.isLeaf() ? this.nodeModel.openLeaf(node) : this.nodeModel.openFolder(node);
        }
        if (retVal == null) {
            return;
        }
        NavigationHandler handler = ClientContext.getCurrentContext().getNavigationHandler();
        NavigatablePanel panel = UIControlUtil.getParentPanel(this, null);
        handler.navigate(panel, this, retVal);
    }

    private Node doFindNode(DefaultNode parent, NodeFilter filter) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node nn;
            DefaultNode child = (DefaultNode)parent.getChildAt(i);
            Node n = child.getNode();
            if (filter.accept(n)) {
                return n;
            }
            if (!n.isLoaded() || child.getChildCount() <= 0 || (nn = this.doFindNode(child, filter)) == null) continue;
            return nn;
        }
        return null;
    }

    private void doCollectNodeList(DefaultNode parent, NodeFilter filter, List nodes) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            DefaultNode oChild = (DefaultNode)parent.getChildAt(i);
            Node oNode = oChild.getNode();
            if (filter.accept(oNode)) {
                nodes.add(oNode);
            }
            if (!oNode.isLoaded() || oChild.getChildCount() <= 0) continue;
            this.doCollectNodeList(oChild, filter, nodes);
        }
    }

    private void show(PopupMenuOpener menu, int x, int y) {
        List items;
        List list = items = menu == null ? null : menu.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        } else {
            this.popup.setVisible(false);
        }
        this.popup.removeAll();
        for (Object o : items) {
            ActionMenuItem ami = null;
            ami = o instanceof Opener ? new ActionMenuItem((Opener)o) : new ActionMenuItem((Action)o);
            Dimension dim = ami.getPreferredSize();
            ami.setPreferredSize(new Dimension(Math.max(dim.width, 100), dim.height));
            this.popup.add(ami);
        }
        this.popup.pack();
        Rectangle rect = this.getBounds();
        this.popup.show(this, x, y);
        this.popup.requestFocus();
    }

    private class ActionMenuItem
    extends JMenuItem {
        XTree root;
        private Object source;

        ActionMenuItem(Opener anOpener) {
            this.root = XTree.this;
            this.source = anOpener;
            this.setText(anOpener.getCaption());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeOpener(e);
                }
            });
            Object ov = anOpener.getProperties().get("mnemonic");
            if (ov != null && ov.toString().trim().length() > 0) {
                this.setMnemonic(ov.toString().trim().charAt(0));
            }
            if ((ov = anOpener.getProperties().get("icon")) != null && ov.toString().length() > 0) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(ov.toString()));
            }
        }

        ActionMenuItem(Action anAction) {
            this.root = XTree.this;
            this.source = anAction;
            this.setText(anAction.getCaption());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeAction(e);
                }
            });
            this.setMnemonic(anAction.getMnemonic());
            String sicon = anAction.getIcon();
            if (sicon != null && sicon.length() > 0) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(sicon));
            }
        }

        void invokeOpener(ActionEvent e) {
            try {
                UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), (Opener)this.source);
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        void invokeAction(ActionEvent e) {
            try {
                Object outcome = ((Action)this.source).execute();
                if (outcome instanceof Opener) {
                    UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), (Opener)outcome);
                }
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }
    }

    private class TreeEventSupport
    implements TreeSelectionListener {
        XTree root;
        private Node oldNode;
        private List<TreeSelectionListener> selectionHandlers;

        private TreeEventSupport() {
            this.root = XTree.this;
            this.selectionHandlers = new ArrayList<TreeSelectionListener>();
        }

        void add(TreeSelectionListener handler) {
            if (handler != null && !this.selectionHandlers.contains(handler)) {
                this.selectionHandlers.add(handler);
            }
        }

        void remove(TreeSelectionListener handler) {
            if (handler != null) {
                this.selectionHandlers.remove(handler);
            }
        }

        @Override
        public void valueChanged(final TreeSelectionEvent evt) {
            try {
                if (this.root.getName() != null) {
                    boolean nodeHasChanged = false;
                    DefaultNode selNode = XTree.this.getSelectedNode();
                    Node node = selNode == null ? null : selNode.getNode();
                    nodeHasChanged = this.oldNode == null || node == null || !this.oldNode.equals(node);
                    if (selNode != null && !selNode.hasChanged) {
                        selNode.hasChanged = nodeHasChanged;
                    }
                    UIControlUtil.setBeanValue(this.root.getBinding(), this.root.getName(), (Object)node);
                    this.oldNode = node;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreeEventSupport.this.fireChangeNode(evt);
                        }
                    });
                }
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        private void fireChangeNode(TreeSelectionEvent evt) {
            this.root.getBinding().notifyDepends(this.root, this.root.getName(), false);
            for (TreeSelectionListener handler : this.selectionHandlers) {
                handler.valueChanged(evt);
            }
        }
    }

    private class DefaultProvider
    implements AbstractTreeNodeModel.Provider {
        XTree root;

        private DefaultProvider() {
            this.root = XTree.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Node getSelectedNode() {
            DefaultNode defNode = this.root.getSelectedNode();
            return defNode == null ? null : defNode.getNode();
        }

        @Override
        public Node getRoot() {
            DefaultNode rdn = (DefaultNode)this.root.root;
            return rdn == null ? null : rdn.getNode();
        }

        @Override
        public Node findNode(NodeFilter filter) {
            DefaultNode parent = (DefaultNode)this.root.model.getRoot();
            Node n = parent.getNode();
            if (filter.accept(n)) {
                return n;
            }
            return this.root.doFindNode(parent, filter);
        }

        @Override
        public List<Node> findNodes(NodeFilter filter) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            DefaultNode parent = (DefaultNode)this.root.model.getRoot();
            Node n = parent.getNode();
            if (filter.accept(n)) {
                nodes.add(n);
            }
            this.root.doCollectNodeList(parent, filter, nodes);
            return nodes;
        }

        @Override
        public List<Node> children() {
            DefaultNode defNode = this.root.getSelectedNode();
            if (defNode == null) {
                return null;
            }
            ArrayList<Node> list = new ArrayList<Node>();
            Enumeration<TreeNode> en = defNode.children();
            while (en.hasMoreElements()) {
                DefaultNode dn = (DefaultNode)en.nextElement();
                list.add(dn.getNode());
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refresh() {
            DefaultNode selNode = this.root.getSelectedNode();
            if (selNode == null) {
                DefaultNode rootNode;
                DefaultNode defaultNode = rootNode = (DefaultNode)this.root.root;
                synchronized (defaultNode) {
                    rootNode.loadChildren(2);
                }
            }
            DefaultNode defaultNode = selNode;
            synchronized (defaultNode) {
                selNode.loadChildren(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reloadTree() {
            DefaultNode rootNode;
            DefaultNode defaultNode = rootNode = (DefaultNode)this.root.root;
            synchronized (defaultNode) {
                rootNode.loadChildren(true);
            }
            this.root.model.nodeStructureChanged(rootNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reloadSelectedNode() {
            DefaultMutableTreeNode mtn = this.root.getSelectedNode();
            if (mtn == null) {
                mtn = this.root.root;
            }
            if (mtn instanceof DefaultNode) {
                DefaultMutableTreeNode defNode;
                DefaultMutableTreeNode defaultMutableTreeNode = defNode = mtn;
                synchronized (defaultMutableTreeNode) {
                    ((DefaultNode)defNode).loadChildren(true);
                }
                this.root.model.nodeStructureChanged(defNode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reloadParentNode() {
            DefaultMutableTreeNode mtn = this.root.getSelectedNode();
            if (mtn == null) {
                mtn = this.root.root;
            }
            if (mtn instanceof DefaultNode) {
                DefaultMutableTreeNode selNode = mtn;
                DefaultNode parentNode = (DefaultNode)selNode.getParent();
                if (parentNode == null) {
                    return;
                }
                DefaultNode defaultNode = parentNode;
                synchronized (defaultNode) {
                    parentNode.loadChildren(true);
                }
                this.root.model.nodeStructureChanged(parentNode);
                TreePath path = new TreePath(parentNode.getPath());
                this.root.setSelectionPath(path);
            }
        }

        @Override
        public void update() {
            Object rootNode = this.root.getModel().getRoot();
            if (rootNode instanceof DefaultNode) {
                ((DefaultNode)rootNode).update();
            }
        }
    }

    private class DummyTreeNodeModel
    extends TreeNodeModel {
        private DummyTreeNodeModel() {
        }

        @Override
        public Node[] fetchNodes(Node node) {
            return null;
        }

        @Override
        public Node getRootNode() {
            return new Node("root", "Default");
        }
    }

    private class TreeCellRendererImpl
    implements TreeCellRenderer {
        XTree root;
        private Icon defaultIcon;
        private Border defaultBorder;
        private Border selectionBorder;
        private JPanel panel;
        private JLabel lblIcon;
        private JLabel lblContent;
        private Icon leafIcon;
        private Icon closedIcon;
        private Icon openIcon;
        private Color selectionForeground;
        private Color textForeground;
        private Color selectionBackground;
        private Color textBackground;
        private Color selectionBorderColor;
        private boolean _inited;

        TreeCellRendererImpl() {
            this.root = XTree.this;
            this.defaultBorder = BorderFactory.createEmptyBorder(2, 2, 2, 5);
            this.lblContent = new JLabel("Content");
            this.lblIcon = new JLabel();
            this.lblIcon.setPreferredSize(new Dimension(16, 16));
            this.lblIcon.setMinimumSize(new Dimension(16, 16));
            this.lblIcon.setMaximumSize(new Dimension(16, 16));
            JLabel separator = new JLabel();
            separator.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            JPanel box = new JPanel(new BorderLayout());
            box.add((Component)this.lblIcon, "West");
            box.add((Component)separator, "East");
            box.setOpaque(false);
            this.panel = new JPanel(new BorderLayout());
            this.panel.add((Component)box, "West");
            this.panel.add((Component)this.lblContent, "East");
            this.panel.setOpaque(false);
            this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.leafIcon = UIManager.getIcon("Tree.leafIcon");
            this.closedIcon = UIManager.getIcon("Tree.closedIcon");
            this.openIcon = UIManager.getIcon("Tree.openIcon");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
            this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Node n;
            if (!this._inited) {
                this._inited = true;
                this.lblContent.setFont(tree.getFont());
                this.panel.setFont(this.lblContent.getFont());
                tree.setRowHeight(this.panel.getPreferredSize().height);
                Border bin = BorderFactory.createEmptyBorder(1, 1, 1, 4);
                Border bout = BorderFactory.createLineBorder(this.selectionBorderColor, 1);
                this.selectionBorder = BorderFactory.createCompoundBorder(bout, bin);
                if (this.root.nodeModel != null) {
                    this.defaultIcon = this.lookupIcon(this.root.nodeModel.getIcon());
                }
            }
            this.lblContent.setText(value == null ? "" : value.toString());
            if (this.root.nodeModel == null) {
                return this.panel;
            }
            if (selected) {
                this.lblContent.setForeground(this.selectionForeground);
                this.lblContent.setBackground(this.selectionBackground);
                this.lblContent.setOpaque(true);
            } else {
                this.lblContent.setForeground(this.textForeground);
                this.lblContent.setBackground(this.textBackground);
                this.lblContent.setOpaque(false);
            }
            if (hasFocus) {
                this.lblContent.setBorder(this.selectionBorder);
            } else {
                this.lblContent.setBorder(this.defaultBorder);
            }
            this.lblContent.setEnabled(tree.isEnabled());
            this.lblIcon.setEnabled(tree.isEnabled());
            if (leaf) {
                this.lblIcon.setIcon(this.leafIcon);
            } else if (expanded) {
                this.lblIcon.setIcon(this.openIcon);
            } else {
                this.lblIcon.setIcon(this.closedIcon);
            }
            if (this.defaultIcon != null) {
                this.lblIcon.setIcon(this.defaultIcon);
            }
            if (value != null && value instanceof DefaultNode && (n = ((DefaultNode)value).getNode()) != null) {
                if (n.getIcon() != null) {
                    Icon oIcon = (Icon)n.getProperties().get(Icon.class);
                    if (oIcon == null) {
                        oIcon = this.lookupIcon(n.getIcon());
                        n.getProperties().put(Icon.class, oIcon);
                    }
                    if (oIcon != null) {
                        this.lblIcon.setIcon(oIcon);
                    }
                }
                if (n.getTooltip() != null) {
                    this.lblContent.setToolTipText(n.getTooltip());
                }
            }
            return this.panel;
        }

        private Icon lookupIcon(String name) {
            try {
                Icon icon = ControlSupport.getImageIcon(name);
                if (icon == null) {
                    icon = UIManager.getIcon(name);
                }
                return icon;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private class NodeTreeRenderer
    extends DefaultTreeCellRenderer {
        XTree root;
        private Icon defaultIcon;

        private NodeTreeRenderer() {
            this.root = XTree.this;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Node n;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            super.setText(value + "");
            super.setToolTipText(value + "");
            super.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 5));
            if (this.root.nodeModel == null) {
                return this;
            }
            if (this.defaultIcon == null) {
                this.defaultIcon = this.lookupIcon(this.root.nodeModel.getIcon());
            }
            if (this.defaultIcon != null) {
                this.setIcon(this.defaultIcon);
            }
            if (value != null && value instanceof DefaultNode && (n = ((DefaultNode)value).getNode()) != null) {
                Icon oIcon;
                if (n.getIcon() != null && (oIcon = this.lookupIcon(n.getIcon())) != null) {
                    super.setIcon(oIcon);
                }
                if (n.getTooltip() != null) {
                    super.setToolTipText(n.getTooltip());
                }
            }
            return this;
        }

        private Icon lookupIcon(String name) {
            try {
                Icon icon = ControlSupport.getImageIcon(name);
                if (icon == null) {
                    icon = UIManager.getIcon(name);
                }
                return icon;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private class DefaultNodeProvider
    implements Node.Provider {
        XTree root;
        private DefaultNode treeNode;
        private Node userNode;

        DefaultNodeProvider(DefaultNode treeNode) {
            this.root = XTree.this;
            this.treeNode = treeNode;
            this.userNode = treeNode.getNode();
            if (this.userNode != null) {
                this.userNode.setProvider(this);
            }
        }

        @Override
        public int getIndex() {
            TreeNode parent = this.treeNode.getParent();
            return parent == null ? -1 : parent.getIndex(this.treeNode);
        }

        @Override
        public boolean hasItems() {
            Enumeration<TreeNode> en = this.treeNode.children();
            return en == null ? false : en.hasMoreElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadItems() {
            DefaultNode defaultNode = this.treeNode;
            synchronized (defaultNode) {
                this.treeNode.loadChildren();
            }
            this.root.model.nodeStructureChanged(this.treeNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reloadItems() {
            DefaultNode defaultNode = this.treeNode;
            synchronized (defaultNode) {
                this.treeNode.loadChildren(true);
            }
            this.root.model.nodeStructureChanged(this.treeNode);
        }

        @Override
        public List<Node> getItems() {
            return this.treeNode.getItems();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void select() {
            Object[] treeNodes = this.treeNode.getPath();
            if (treeNodes == null || treeNodes.length == 0) {
                return;
            }
            DefaultNode defaultNode = this.treeNode;
            synchronized (defaultNode) {
                this.treeNode.loadChildren();
            }
            this.root.setSelectionPath(new TreePath(treeNodes));
        }

        @Override
        public Object open() {
            this.select();
            if (this.userNode == null) {
                return null;
            }
            if (this.userNode.isLeaf()) {
                return XTree.this.nodeModel.openLeaf(this.userNode);
            }
            return XTree.this.nodeModel.openFolder(this.userNode);
        }

        void updateTreeNodePath() {
            TreeNode[] arr = this.treeNode.getPath();
            for (int i = 0; i < arr.length; ++i) {
                DefaultNode dn = (DefaultNode)arr[i];
                HashMap<String, Object> item = this.root.nodeModel.fetchNodeItem(dn.getNode());
                if (!(item instanceof Map) && item != null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("caption", ((Object)item).toString());
                    map.put("userObject", item);
                    item = map;
                }
                if (!(item instanceof Map)) continue;
                dn.getNode().update(item);
                this.root.model.nodeChanged(dn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refresh() {
            this.updateTreeNodePath();
            TreeNode[] arr = this.treeNode.getPath();
            for (int i = 0; i < arr.length; ++i) {
                DefaultNode dn;
                DefaultNode defaultNode = dn = (DefaultNode)arr[i];
                synchronized (defaultNode) {
                    this.treeNode.loadChildren(2);
                    continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reload() {
            this.updateTreeNodePath();
            DefaultNode defaultNode = this.treeNode;
            synchronized (defaultNode) {
                this.treeNode.loadChildren(true);
            }
            this.root.model.nodeStructureChanged(this.treeNode);
        }

        @Override
        public void remove() {
            TreeNode parent = this.treeNode.getParent();
            if (parent == null) {
                return;
            }
            DefaultNode parentTreeNode = (DefaultNode)parent;
            TreeNode tn = parentTreeNode.getChildAfter(this.treeNode);
            if (tn == null) {
                tn = parentTreeNode.getChildBefore(this.treeNode);
            }
            parentTreeNode.remove(this.treeNode);
            this.root.model.nodeStructureChanged(parentTreeNode);
            if (tn instanceof DefaultNode) {
                ((DefaultNode)tn).getNode().select();
            } else {
                parentTreeNode.getNode().select();
            }
        }
    }

    public class DefaultNode
    extends DefaultMutableTreeNode
    implements NodeListener {
        XTree root;
        private final int REFRESH_CHILDREN = 0;
        private final int RELOAD_CHILDREN = 1;
        private final int UPDATE_CHILDREN = 2;
        private Node node;
        private boolean hasChanged;
        private Node[] nodes;
        private boolean request_to_open;
        private int index;

        public DefaultNode(String n) {
            super(n);
            this.root = XTree.this;
            this.REFRESH_CHILDREN = 0;
            this.RELOAD_CHILDREN = 1;
            this.UPDATE_CHILDREN = 2;
        }

        public DefaultNode(Node node) {
            this(node, null);
        }

        public DefaultNode(Node node, Node parent) {
            super(node.getCaption(), !node.isLeaf());
            this.root = XTree.this;
            this.REFRESH_CHILDREN = 0;
            this.RELOAD_CHILDREN = 1;
            this.UPDATE_CHILDREN = 2;
            this.node = node;
            this.node.setParent(parent);
            this.node.addListener(this);
            this.node.setProvider(new DefaultNodeProvider(this));
        }

        @Override
        public String toString() {
            if (this.node == null) {
                return super.toString();
            }
            return this.node.getCaption();
        }

        public Node getNode() {
            return this.node;
        }

        public int size() {
            return super.getChildCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getChildCount() {
            DefaultNode defaultNode = this;
            synchronized (defaultNode) {
                if (!this.node.isLoaded()) {
                    this.node.setLoaded(true);
                    this.hasChanged = true;
                    this.loadChildren();
                }
            }
            return super.getChildCount();
        }

        public void loadChildren() {
            this.loadChildren(false);
        }

        void loadChildren(boolean reload) {
            this.loadChildren(reload ? 1 : 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadChildren(int load_event_type) {
            DefaultNode dn;
            Node[] oldNodes;
            Node pnode = this.getNode();
            if (pnode != null && pnode.isLeaf()) {
                return;
            }
            Node[] nodeArray = oldNodes = this.nodes == null ? new Node[]{} : this.nodes;
            if (oldNodes.length == 0) {
                load_event_type = 1;
            }
            try {
                if (this.nodes == null || load_event_type == 1 || load_event_type == 2) {
                    this.nodes = XTree.this.nodeModel.fetchNodes(pnode);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.nodes == null || load_event_type == 1) {
                super.removeAllChildren();
            }
            if (this.nodes == null || this.nodes.length == 0) {
                super.removeAllChildren();
                this.nodes = null;
                return;
            }
            XTree.this.nodeModel.initChildNodes(this.nodes);
            ArrayList<Node> aNodes = new ArrayList<Node>();
            for (Node n : this.nodes) {
                if (n == null) continue;
                boolean passed = true;
                Object item = n.getItem();
                if (item instanceof Map) {
                    Map map = (Map)item;
                    String security_checks = "" + this.getString(map, "security_checks");
                    if (!security_checks.matches("false|0")) {
                        String domain = this.getString(map, "domain");
                        String role = this.getString(map, "role");
                        String permission = this.getString(map, "permission");
                        passed = ControlSupport.isPermitted(domain, role, permission);
                    }
                }
                if (!passed) continue;
                aNodes.add(n);
            }
            ArrayList<DefaultNode> auto_expand_nodes = new ArrayList<DefaultNode>();
            if (load_event_type == 0) {
                this.root.model.nodeStructureChanged(this);
            } else if (load_event_type == 1) {
                for (int i = 0; i < aNodes.size(); ++i) {
                    Node an = (Node)aNodes.get(i);
                    dn = new DefaultNode(an, pnode);
                    dn.index = i;
                    this.add(dn);
                    String str_expand = an.removeProperty("_expand") + "";
                    if (!str_expand.toString().matches("1|true")) continue;
                    auto_expand_nodes.add(dn);
                }
            } else if (load_event_type == 2) {
                int i;
                ArrayList<DefaultNode> remTreeNodes = new ArrayList<DefaultNode>();
                int ccount = super.getChildCount();
                for (int i2 = 0; i2 < ccount; ++i2) {
                    DefaultNode dn2 = (DefaultNode)this.getChildAt(i2);
                    if (aNodes.contains(dn2.getNode())) continue;
                    remTreeNodes.add((DefaultNode)this.getChildAt(i2));
                }
                int[] rrows = new int[remTreeNodes.size()];
                Object[] rvals = new Object[rrows.length];
                for (int i3 = 0; i3 < remTreeNodes.size(); ++i3) {
                    rvals[i3] = remTreeNodes.get(i3);
                    rrows[i3] = ((DefaultNode)remTreeNodes.get((int)i3)).index;
                    this.remove((MutableTreeNode)remTreeNodes.get(i3));
                }
                remTreeNodes.clear();
                this.root.model.nodesWereRemoved(this, rrows, rvals);
                if (rrows.length > 0) {
                    this.updateChildrenIndex();
                }
                ArrayList<DefaultNode> xTreeNodes = new ArrayList<DefaultNode>();
                ArrayList<DefaultNode> uTreeNodes = new ArrayList<DefaultNode>();
                int rows = super.getChildCount();
                for (i = 0; i < rows; ++i) {
                    DefaultNode dn3 = (DefaultNode)this.getChildAt(i);
                    int pos = aNodes.indexOf(dn3.getNode());
                    if (pos < 0) continue;
                    Object item = ((Node)aNodes.get(pos)).getItem();
                    dn3.getNode().update(item);
                    uTreeNodes.add(dn3);
                    TreePath path = new TreePath(dn3.getPath());
                    if (this.root.isExpanded(path)) {
                        xTreeNodes.add(dn3);
                        continue;
                    }
                    dn3.nodes = null;
                }
                rrows = new int[uTreeNodes.size()];
                for (i = 0; i < uTreeNodes.size(); ++i) {
                    rrows[i] = ((DefaultNode)uTreeNodes.get((int)i)).index;
                }
                uTreeNodes.clear();
                if (rrows.length > 0) {
                    this.root.model.nodesChanged(this, rrows);
                }
                for (i = 0; i < aNodes.size(); ++i) {
                    Node an = (Node)aNodes.get(i);
                    int pos = this.indexOf(an);
                    if (pos >= 0) continue;
                    DefaultNode dn4 = new DefaultNode(an, pnode);
                    dn4.index = i;
                    this.insert(dn4, i);
                    uTreeNodes.add(dn4);
                    String str_expand = an.removeProperty("_expand") + "";
                    if (!str_expand.toString().matches("1|true")) continue;
                    auto_expand_nodes.add(dn4);
                }
                rrows = new int[uTreeNodes.size()];
                for (i = 0; i < uTreeNodes.size(); ++i) {
                    rrows[i] = ((DefaultNode)uTreeNodes.get((int)i)).index;
                }
                uTreeNodes.clear();
                aNodes.clear();
                if (rrows.length > 0) {
                    this.root.model.nodesWereInserted(this, rrows);
                }
                int len = xTreeNodes.size();
                for (i = 0; i < len; ++i) {
                    DefaultNode dn5;
                    DefaultNode defaultNode = dn5 = (DefaultNode)xTreeNodes.get(i);
                    synchronized (defaultNode) {
                        dn5.loadChildren(2);
                        continue;
                    }
                }
                xTreeNodes.clear();
            }
            int len = auto_expand_nodes.size();
            for (int i = 0; i < len; ++i) {
                DefaultNode defaultNode = dn = (DefaultNode)auto_expand_nodes.get(i);
                synchronized (defaultNode) {
                    Object[] treeNodes = dn.getPath();
                    this.root.expandPath(new TreePath(treeNodes));
                    continue;
                }
            }
        }

        void updateChildrenIndex() {
            int rows = super.getChildCount();
            int i = 0;
            while (i < rows) {
                DefaultNode dn = (DefaultNode)this.getChildAt(i);
                dn.index = i++;
            }
        }

        int indexOf(Node node) {
            if (node == null) {
                return -1;
            }
            int rows = this.getChildCount();
            for (int i = 0; i < rows; ++i) {
                DefaultNode dn = (DefaultNode)this.getChildAt(i);
                if (!dn.getNode().equals(node)) continue;
                return i;
            }
            return -1;
        }

        private String getString(Map data, String name) {
            Object ov = data == null ? null : (Object)data.get(name);
            return ov == null ? null : ov.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reload() {
            if (!this.node.isLoaded()) {
                return;
            }
            DefaultNode defaultNode = this;
            synchronized (defaultNode) {
                this.loadChildren();
                this.root.model.reload(this);
            }
        }

        List<Node> getItems() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            Enumeration<TreeNode> en = super.children();
            while (en.hasMoreElements()) {
                TreeNode item = en.nextElement();
                DefaultNode dNode = (DefaultNode)item;
                nodes.add(dNode.getNode());
            }
            return nodes;
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
        }

        @Override
        public void remove(int childIndex) {
            super.remove(childIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            Node node = this.getNode();
            if (node != null) {
                DefaultNode defaultNode = this;
                synchronized (defaultNode) {
                    this.root.nodeModel.onUpdate(node);
                    node.update(node.getItem());
                    this.root.model.nodeChanged(this);
                }
            }
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultNode dn = (DefaultNode)this.getChildAt(i);
                if (dn == null) continue;
                dn.update();
            }
        }
    }
}

