/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TileViewModel;
import com.rameses.rcp.control.panel.TilePanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.ComponentSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.BreakException;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;

public class XTileView
extends TilePanel
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private TileViewModel model;
    private List<TileViewItem> tiles;
    private Binding binding;
    private String[] depends;
    private boolean dynamic;
    private int index;
    private ComponentSupport componentSupport;
    private String target;
    private String formName;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;
    private Vector LOCKS = new Vector();

    public XTileView() {
        new MouseEventSupport(this).install();
    }

    public ComponentSupport getComponentSupport() {
        if (this.componentSupport == null) {
            this.componentSupport = new ComponentSupport();
        }
        return this.componentSupport;
    }

    @Override
    public void refresh() {
        this.refreshItems(false);
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        if (!this.isDynamic()) {
            this.buildItems();
        }
    }

    public void reload() {
        this.refreshItems(true);
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("dynamic", this.isDynamic());
        map.put("showCaptions", this.isShowCaptions());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private void refreshItems(boolean reload) {
        if (this.isDynamic() || reload) {
            this.buildItems();
        }
        this.buildControls();
    }

    private void buildItems() {
        this.removeAll();
        Object value = null;
        try {
            value = UIControlUtil.getBeanValue(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TileViewModel newmodel = null;
        if (value == null) {
            newmodel = new TileViewModelImpl();
        } else if (value instanceof TileViewModel) {
            newmodel = (TileViewModel)value;
        } else {
            ArrayList<Object> items = new ArrayList<Object>();
            if (value.getClass().isArray()) {
                for (Object item : (Object[])value) {
                    items.add(item);
                }
            } else if (value instanceof Collection) {
                items.addAll((Collection)value);
            }
            newmodel = new TileViewModelImpl(items);
        }
        TileViewModel old = this.model;
        if (old != null) {
            old.setProvider(null);
        }
        newmodel.setProvider(new TileViewModelProvider());
        this.model = newmodel;
        this.tiles = this.buildTileViews(this.model);
    }

    private void buildControls() {
        this.removeAll();
        if (this.tiles != null) {
            for (TileViewItem item : this.tiles) {
                String role;
                String permission = item.getPermission();
                String domain = item.getDomain();
                boolean allowed = ControlSupport.isPermitted(domain, role = item.getRole(), permission);
                if (!allowed) continue;
                boolean visible = true;
                String expression = item.getVisibleWhen();
                if (expression != null && expression.trim().length() > 0) {
                    try {
                        visible = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), expression);
                    }
                    catch (Throwable t) {
                        visible = false;
                        t.printStackTrace();
                    }
                }
                if (!visible) continue;
                ImageIcon icon = null;
                Object obj = item.getProperty("icon");
                icon = obj instanceof byte[] ? new ImageIcon((byte[])obj) : ImageIconSupport.getInstance().getIcon(item.getIcon());
                this.addItem(item.getCaption(), item, icon);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public int getHorizontalAlignment() {
        return 0;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
    }

    public boolean focusFirstInput() {
        return false;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    private List<TileViewItem> buildTileViews(TileViewModel model) {
        List list;
        HashMap params = new HashMap();
        ArrayList<TileViewItem> tiles = new ArrayList<TileViewItem>();
        List list2 = list = model == null ? null : model.fetchList(params);
        if (list == null) {
            return tiles;
        }
        for (Object item : list) {
            if (item instanceof Map) {
                tiles.add(new TileViewMap((Map)item));
                continue;
            }
            if (!(item instanceof Action)) continue;
            tiles.add(new TileViewAction((Action)item));
        }
        Collections.sort(tiles, new Comparator<TileViewItem>(){

            @Override
            public int compare(TileViewItem o1, TileViewItem o2) {
                int i2;
                int i1 = o1.getIndex();
                if (i1 < (i2 = o2.getIndex())) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
        return tiles;
    }

    @Override
    protected void onselect(Object obj) {
        if (obj instanceof TileViewItem) {
            if (this.model == null) {
                return;
            }
            TileViewItem item = (TileViewItem)obj;
            if (this.LOCKS.contains(item)) {
                return;
            }
            this.LOCKS.addElement(item);
            new Thread(new ActionProcess(item)).start();
        }
    }

    private class TileViewModelProvider
    implements TileViewModel.Provider {
        XTileView root;

        private TileViewModelProvider() {
            this.root = XTileView.this;
        }

        @Override
        public void refresh() {
            this.root.refresh();
        }

        @Override
        public void reload() {
            this.root.reload();
        }
    }

    private class ActionProcess
    implements Runnable {
        private TileViewItem item;

        ActionProcess(TileViewItem item) {
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Binding binding;
                if (this.item == null) {
                    return;
                }
                Object result = XTileView.this.model.onOpenItem(this.item.getUserObject());
                if (!(result instanceof Opener)) {
                    return;
                }
                Opener opener = (Opener)result;
                String target = opener.getTarget() + "";
                if (!target.matches("process|_process|window|_window|popup|_popup|self|_self")) {
                    opener.setTarget("window");
                }
                if ((binding = XTileView.this.getBinding()) != null) {
                    binding.fireNavigation(opener);
                }
            }
            catch (BreakException be) {
                be.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
                MsgBox.err(t);
            }
            finally {
                XTileView.this.LOCKS.removeElement(this.item);
            }
        }
    }

    public class TileViewAction
    implements TileViewItem {
        Action item;

        TileViewAction(Action item) {
            this.item = item;
        }

        @Override
        public int getIndex() {
            try {
                return Integer.parseInt(this.getProperty("index").toString());
            }
            catch (Throwable t) {
                return 0;
            }
        }

        @Override
        public String getName() {
            return this.item == null ? null : this.item.getName();
        }

        @Override
        public String getCaption() {
            return this.item == null ? null : this.item.getCaption();
        }

        @Override
        public String getIcon() {
            return this.item == null ? null : this.item.getIcon();
        }

        @Override
        public Object getUserObject() {
            return this.item;
        }

        @Override
        public Object getProperty(String key) {
            return this.item == null ? null : this.item.getProperties().get(key);
        }

        @Override
        public String getDomain() {
            return this.item == null ? null : this.item.getDomain();
        }

        @Override
        public String getRole() {
            return this.item == null ? null : this.item.getRole();
        }

        @Override
        public String getPermission() {
            return this.item == null ? null : this.item.getPermission();
        }

        @Override
        public boolean isUpdate() {
            return this.item == null ? null : Boolean.valueOf(this.item.isUpdate());
        }

        @Override
        public boolean isImmediate() {
            return this.item == null ? null : Boolean.valueOf(this.item.isImmediate());
        }

        @Override
        public String getVisibleWhen() {
            return this.item == null ? null : this.item.getVisibleWhen();
        }

        @Override
        public Map getProperties() {
            return this.item == null ? new HashMap() : this.item.getProperties();
        }

        @Override
        public String getTooltip() {
            return this.item == null ? null : this.item.getTooltip();
        }

        @Override
        public char getMnemonic() {
            return (this.item == null ? null : Character.valueOf(this.item.getMnemonic())).charValue();
        }
    }

    public class TileViewMap
    implements TileViewItem {
        Map item;

        TileViewMap(Map item) {
            this.item = item == null ? new HashMap() : item;
        }

        @Override
        public int getIndex() {
            try {
                return Integer.parseInt(this.getProperty("index").toString());
            }
            catch (Throwable t) {
                return 0;
            }
        }

        @Override
        public String getName() {
            return this.getString("name");
        }

        @Override
        public String getCaption() {
            return this.getString("caption");
        }

        @Override
        public String getIcon() {
            return this.getString("icon");
        }

        @Override
        public Object getUserObject() {
            return this.item;
        }

        @Override
        public Object getProperty(String key) {
            return this.item.get(key);
        }

        @Override
        public String getDomain() {
            return this.getString("domain");
        }

        @Override
        public String getRole() {
            return this.getString("role");
        }

        @Override
        public String getPermission() {
            return this.getString("permission");
        }

        @Override
        public boolean isUpdate() {
            return this.getBoolean("update");
        }

        @Override
        public boolean isImmediate() {
            return this.getBoolean("immediate");
        }

        @Override
        public String getVisibleWhen() {
            return this.getString("visibleWhen");
        }

        @Override
        public Map getProperties() {
            Object value = this.item == null ? null : this.item.get("properties");
            return value;
        }

        @Override
        public String getTooltip() {
            return this.getString("tooltip");
        }

        @Override
        public char getMnemonic() {
            try {
                return this.getString("mnemonic").charAt(0);
            }
            catch (Throwable t) {
                return '\u0000';
            }
        }

        private String getString(Object key) {
            Object value = this.item == null ? null : (Object)this.item.get(key);
            return value == null ? null : value.toString();
        }

        private boolean getBoolean(Object key) {
            Object value = this.item == null ? null : this.item.get(key);
            return "true".equals(value + "");
        }
    }

    static interface TileViewItem {
        public int getIndex();

        public String getName();

        public String getCaption();

        public String getIcon();

        public Object getUserObject();

        public Object getProperty(String var1);

        public String getDomain();

        public String getRole();

        public String getPermission();

        public boolean isUpdate();

        public boolean isImmediate();

        public String getVisibleWhen();

        public Map getProperties();

        public String getTooltip();

        public char getMnemonic();
    }

    private class TileViewModelImpl
    extends TileViewModel {
        private List items;
        private List<TileViewItem> tiles;

        TileViewModelImpl() {
            this(null);
        }

        TileViewModelImpl(List items) {
            this.items = items == null ? new ArrayList() : items;
        }

        public List getList() {
            return this.items;
        }
    }
}

