/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.ExpressionResolver;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TabbedPaneModel;
import com.rameses.rcp.control.tabbedpane.TabbedItemPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.OpenerProvider;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.Warning;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class XTabbedPane
extends JTabbedPane
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean dynamic;
    private String disableWhen;
    private String handler;
    private String items;
    private int oldIndex;
    private List<StaticItem> staticItems = new ArrayList<StaticItem>();
    private List<Opener> openers = new ArrayList<Opener>();
    private boolean nameAutoLookupAsOpener = false;
    private TabbedPaneModelProxy model;
    private boolean noSelectionAllowed;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private ProviderImpl providerImpl;
    private KeyboardActionManager keyActionMgr;

    public XTabbedPane() {
        this.initComponents();
    }

    private void initComponents() {
        new MouseEventSupport(this).install();
        this.setPreferredSize(new Dimension(100, 50));
    }

    public boolean isNameAutoLookupAsOpener() {
        return this.nameAutoLookupAsOpener;
    }

    public void setNameAutoLookupAsOpener(boolean nameAutoLookupAsOpener) {
        this.nameAutoLookupAsOpener = nameAutoLookupAsOpener;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
        this.buildStaticItems();
        if (!this.staticItems.isEmpty()) {
            this.bindStaticItems(binding);
        }
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
        try {
            if (!this.isDynamic()) {
                this.loadTabs();
            }
        }
        catch (Throwable t) {
            System.out.println("[WARN] error loading tabs caused by " + t.getMessage());
        }
    }

    @Override
    public void refresh() {
        boolean dynamic = this.isDynamic();
        try {
            if (dynamic) {
                this.loadTabs();
            }
        }
        catch (Throwable t) {
            System.out.println("[WARN] error loading tabs caused by " + t.getMessage());
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        ExpressionResolver er = ExpressionResolver.getInstance();
        String expr = this.getDisableWhen();
        if (expr != null && expr.length() > 0 && bean != null) {
            try {
                boolean b = er.evalBoolean(expr, bean);
                this.setEnabled(!b);
            }
            catch (Throwable b) {
                // empty catch block
            }
        }
        if (!dynamic) {
            int compCount = this.staticItems.size();
            for (int i = 0; i < compCount; ++i) {
                int tabIdx;
                StaticItem si = this.staticItems.get(i);
                if (!si.hasVisibleWhen()) continue;
                boolean item_visible = si.isVisible();
                if (item_visible) {
                    tabIdx = super.indexOfComponent(si.component);
                    if (tabIdx >= 0) continue;
                    int tabCount = this.getTabCount();
                    tabIdx = i < tabCount ? i : tabCount;
                    super.insertTab(si.title, si.icon, si.component, si.tooltip, tabIdx);
                    continue;
                }
                tabIdx = super.indexOfComponent(si.component);
                if (tabIdx < 0) continue;
                super.removeTabAt(tabIdx);
            }
            Component comp = this.getSelectedComponent();
            if (comp instanceof TabbedItemPanel) {
                TabbedItemPanel itemPanel = (TabbedItemPanel)comp;
                itemPanel.refreshContent();
            }
        }
        int tabCount = this.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            String disableWhen;
            Component c = this.getComponentAt(i);
            if (!(c instanceof TabbedItemPanel)) continue;
            Opener op = ((TabbedItemPanel)c).getOpener();
            Object ov = op.getProperties().get("disableWhen");
            String string = disableWhen = ov == null ? null : ov.toString();
            if (disableWhen == null || disableWhen.length() == 0) continue;
            try {
                boolean b = er.evalBoolean(disableWhen, bean);
                this.setEnabledAt(i, !b);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynammic", this.isDynamic());
        map.put("disableWhen", this.getDisableWhen());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.noSelectionAllowed) {
            return;
        }
        try {
            Component c = this.getComponentAt(index);
            if (c instanceof TabbedItemPanel) {
                boolean b;
                TabbedPaneModel tpm;
                TabbedItemPanel itemPanel = (TabbedItemPanel)c;
                Opener opener = itemPanel.getOpener();
                TabbedPaneModel tabbedPaneModel = tpm = this.model == null ? null : this.model.getSource();
                if (tpm != null && !(b = tpm.beforeSelect(opener, index))) {
                    return;
                }
                if (itemPanel.hasContent()) {
                    itemPanel.refreshContent();
                } else {
                    itemPanel.loadContent();
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof Warning) {
                MsgBox.alert(t.getMessage());
            } else {
                MsgBox.err(t);
            }
            return;
        }
        this.oldIndex = this.getSelectedIndex();
        super.setSelectedIndex(index);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XTabbedPane.this.fireSelectionChanged();
            }
        });
    }

    private void fireSelectionChanged() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return;
        }
        Opener value = null;
        Component comp = this.getSelectedComponent();
        if (comp instanceof TabbedItemPanel) {
            TabbedItemPanel p = (TabbedItemPanel)comp;
            value = p.getOpener();
        }
        try {
            UIControlUtil.setBeanValue(this.getBinding(), name, (Object)value);
            this.getBinding().notifyDepends(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void buildStaticItems() {
        if (!this.staticItems.isEmpty()) {
            return;
        }
        int compCount = this.getTabCount();
        for (int i = 0; i < compCount; ++i) {
            Component comp = null;
            try {
                comp = this.getComponentAt(i);
            }
            catch (Throwable t) {
                continue;
            }
            if (comp == null || comp instanceof TabbedItemPanel) continue;
            StaticItem si = new StaticItem();
            si.tooltip = super.getToolTipTextAt(i);
            si.mnemonic = super.getMnemonicAt(i);
            si.title = super.getTitleAt(i);
            si.icon = super.getIconAt(i);
            si.component = comp;
            this.staticItems.add(si);
        }
    }

    private void bindStaticItems(Binding b) {
        for (int i = 0; i < this.staticItems.size(); ++i) {
            StaticItem si = this.staticItems.get(i);
            Component comp = si.component;
            if (!(comp instanceof Container)) continue;
            b.Utils.bindControls((Container)comp, b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTabs() {
        int selindex = this.getSelectedIndex();
        this.removeAll();
        int compCount = this.staticItems.size();
        for (int i = 0; i < compCount; ++i) {
            StaticItem si = this.staticItems.get(i);
            if (!si.isVisible()) continue;
            super.addTab(si.title, si.component);
            if (si.tooltip != null) {
                super.setToolTipTextAt(i, si.tooltip);
            }
            if (si.icon == null) continue;
            super.setIconAt(i, si.icon);
        }
        this.loadOpeners();
        ExpressionResolver expRes = ExpressionResolver.getInstance();
        for (Opener op : this.openers) {
            Object ov = op.getProperties().get("visibleWhen");
            String sv = ov == null ? null : ov.toString();
            boolean allowed = true;
            if (sv != null && sv.length() > 0) {
                try {
                    allowed = expRes.evalBoolean(sv, this.getBinding().getBean());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!allowed) continue;
            TabbedItemPanel itemPanel = new TabbedItemPanel(op);
            itemPanel.setProvider(new TabbedItemProvider());
            try {
                String sval;
                this.noSelectionAllowed = true;
                char mnemonic = '\u0000';
                Object propval = op.getProperties().get("mnemonic");
                String string = sval = propval == null ? null : propval.toString();
                if (sval != null && sval.length() > 0) {
                    mnemonic = propval.toString().charAt(0);
                }
                itemPanel.setMnemonic(mnemonic);
                String scaption = op.getCaption();
                if (mnemonic != '\u0000') {
                    int idx;
                    String findstr = mnemonic + "";
                    StringBuilder sb = new StringBuilder();
                    if (scaption != null) {
                        sb.append(scaption);
                    }
                    if ((idx = sb.toString().toLowerCase().indexOf(findstr.toLowerCase())) >= 0) {
                        char c = sb.charAt(idx);
                        sb.replace(idx, idx + 1, "<u>" + c + "</u>");
                    }
                    scaption = "<html>" + sb.toString() + "</html>";
                }
                super.addTab(scaption, this.getOpenerIcon(op), itemPanel);
            }
            catch (Throwable throwable) {
            }
            finally {
                this.noSelectionAllowed = false;
            }
            this.getKeyboardActionManager().register(itemPanel);
        }
        if (this.getTabCount() > 0) {
            if (selindex < 0) {
                selindex = 0;
            }
            if (selindex >= this.getTabCount()) {
                selindex = 0;
            }
            this.setSelectedIndex(selindex);
        }
    }

    private Icon getOpenerIcon(Opener o) {
        Object ov = o.getProperties().get("icon");
        if (ov != null) {
            return ImageIconSupport.getInstance().getIcon(ov.toString());
        }
        return null;
    }

    private void loadOpeners() {
        TabbedPaneModelProxy oldModel;
        String handler;
        this.openers.clear();
        OpenerProvider openerProvider = ClientContext.getCurrentContext().getOpenerProvider();
        if (openerProvider == null) {
            System.out.println("[WARN] opener provider is not set in ClientContext");
            return;
        }
        Object itemsObj = null;
        List<Opener> handlerObj = null;
        String sitems = this.getItems();
        if (sitems != null && sitems.length() > 0) {
            itemsObj = UIControlUtil.getBeanValue(this.getBinding(), sitems);
        }
        if ((handler = this.getHandler()) != null && handler.length() > 0) {
            handlerObj = handler.matches(".+:.+") ? openerProvider.lookupOpeners(handler, new HashMap()) : UIControlUtil.getBeanValue(this.getBinding(), handler);
        }
        TabbedPaneModelProxy newModel = null;
        if (handlerObj instanceof TabbedPaneModel) {
            TabbedPaneModel tpm = (TabbedPaneModel)((Object)handlerObj);
            newModel = new TabbedPaneModelProxy(tpm, itemsObj);
            newModel.activate();
        } else {
            newModel = handlerObj instanceof List ? new TabbedPaneModelProxy(null, handlerObj) : new TabbedPaneModelProxy(null, itemsObj);
        }
        List list = newModel.fetchList(new HashMap());
        if (list != null) {
            this.openers.addAll(list);
        }
        if ((oldModel = this.model) != null) {
            oldModel.deactivate();
        }
        this.model = newModel;
    }

    private ProviderImpl getProviderImpl() {
        if (this.providerImpl == null) {
            this.providerImpl = new ProviderImpl();
        }
        return this.providerImpl;
    }

    private KeyboardActionManager getKeyboardActionManager() {
        if (this.keyActionMgr == null) {
            this.keyActionMgr = new KeyboardActionManager();
        }
        return this.keyActionMgr;
    }

    private class StaticItem {
        Component component;
        String tooltip;
        String title;
        Icon icon;
        int mnemonic;

        private StaticItem() {
        }

        String getVisibleWhen() {
            String sv;
            Object ov = UIControlUtil.getBeanValue(this.component, "visibleWhen");
            String string = sv = ov == null ? null : ov.toString();
            if (sv != null && sv.trim().length() > 0) {
                return sv;
            }
            return null;
        }

        boolean hasVisibleWhen() {
            String s = this.getVisibleWhen();
            return s != null;
        }

        boolean isVisible() {
            String sv = this.getVisibleWhen();
            if (sv == null) {
                return true;
            }
            try {
                ExpressionResolver expRes = ExpressionResolver.getInstance();
                return expRes.evalBoolean(sv, XTabbedPane.this.getBinding().getBean());
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    private class TabbedItemSelector
    extends AbstractAction {
        XTabbedPane root;
        TabbedItemPanel panel;
        KeyStroke ks;
        Object key;
        char mchar;

        TabbedItemSelector(TabbedItemPanel panel, char mchar) {
            this.root = XTabbedPane.this;
            this.panel = panel;
            this.ks = KeyStroke.getKeyStroke("alt " + Character.toUpperCase(mchar));
            this.key = "TabbedItemSelector_open_" + mchar;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int idx = this.root.indexOfComponent(this.panel);
            if (idx >= 0) {
                this.root.setSelectedIndex(idx);
            } else {
                this.root.getActionMap().remove(this.key);
            }
        }
    }

    private class KeyboardActionManager {
        XTabbedPane root;

        private KeyboardActionManager() {
            this.root = XTabbedPane.this;
        }

        private void register(TabbedItemPanel itemPanel) {
            if (itemPanel == null) {
                return;
            }
            char mchar = itemPanel.getMnemonic();
            if (mchar == '\u0000') {
                return;
            }
            TabbedItemSelector selector = new TabbedItemSelector(itemPanel, mchar);
            this.root.getActionMap().put(selector.key, selector);
            this.root.getInputMap(2).put(selector.ks, selector.key);
        }
    }

    private class TabbedItemProvider
    implements TabbedItemPanel.Provider {
        XTabbedPane root;

        private TabbedItemProvider() {
            this.root = XTabbedPane.this;
        }

        @Override
        public Binding getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Map getOpenerParams(Object o) {
            TabbedPaneModel tpm;
            TabbedPaneModel tabbedPaneModel = tpm = this.root.model == null ? null : this.root.model.getSource();
            if (tpm == null) {
                return null;
            }
            return tpm.getOpenerParams(o);
        }
    }

    private class ProviderImpl
    implements TabbedPaneModel.Provider {
        XTabbedPane root;

        private ProviderImpl() {
            this.root = XTabbedPane.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Object lookupOpener(String invokerType, Map params) {
            OpenerProvider openerProvider = ClientContext.getCurrentContext().getOpenerProvider();
            if (openerProvider == null) {
                System.out.println("[WARN] opener provider is not set in ClientContext");
                return new ArrayList();
            }
            return openerProvider.lookupOpener(invokerType, params);
        }

        @Override
        public List lookupOpeners(String invokerType, Map params) {
            OpenerProvider openerProvider = ClientContext.getCurrentContext().getOpenerProvider();
            if (openerProvider == null) {
                System.out.println("[WARN] opener provider is not set in ClientContext");
                return new ArrayList();
            }
            return openerProvider.lookupOpeners(invokerType, params);
        }

        @Override
        public void reload() {
            Component comp = this.root.getSelectedComponent();
            if (!(comp instanceof TabbedItemPanel)) {
                return;
            }
            TabbedItemPanel itemPanel = (TabbedItemPanel)comp;
            itemPanel.reloadContent();
        }

        @Override
        public void refresh() {
            Component comp = this.root.getSelectedComponent();
            if (!(comp instanceof TabbedItemPanel)) {
                return;
            }
            TabbedItemPanel itemPanel = (TabbedItemPanel)comp;
            itemPanel.refreshContent();
        }

        @Override
        public Object getSelectedItem() {
            Component comp = this.root.getSelectedComponent();
            if (comp instanceof TabbedItemPanel) {
                return ((TabbedItemPanel)comp).getOpener();
            }
            return null;
        }

        @Override
        public int getSelectedIndex() {
            return this.root.getSelectedIndex();
        }
    }

    private class TabbedPaneModelProxy
    extends TabbedPaneModel {
        private TabbedPaneModel model;
        private List<Opener> items;

        TabbedPaneModelProxy(TabbedPaneModel model, Object value) {
            this.model = model;
            this.items = new ArrayList<Opener>();
            if (value != null) {
                Object[] arrays = new Object[]{};
                if (value.getClass().isArray()) {
                    arrays = (Object[])value;
                } else if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    arrays = coll.toArray();
                }
                for (int i = 0; i < arrays.length; ++i) {
                    if (!(arrays[i] instanceof Opener)) continue;
                    this.items.add((Opener)arrays[i]);
                }
            }
        }

        TabbedPaneModel getSource() {
            return this.model;
        }

        void activate() {
            if (this.model != null) {
                this.model.setProvider(XTabbedPane.this.getProviderImpl());
            }
        }

        void deactivate() {
            if (this.model != null) {
                this.model.setProvider(null);
            }
        }

        @Override
        public List fetchList(Object params) {
            if (this.model == null) {
                return this.items;
            }
            return this.model.fetchList(params);
        }
    }
}

