/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.ExpressionResolver;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TabbedListModel;
import com.rameses.rcp.control.tabbedpane.TabbedItemPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.Warning;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class XTabbedList
extends JTabbedPane
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean dynamic;
    private String disableWhen;
    private int oldIndex;
    private List<Map> items = new ArrayList<Map>();
    private TabbedListModel model;
    private boolean noSelectionAllowed;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private ProviderImpl providerImpl;

    public XTabbedList() {
        this.initComponents();
    }

    private void initComponents() {
        this.model = new TabbedListModel();
        if (Beans.isDesignTime()) {
            this.addTab("Tab 1", new JLabel());
            this.addTab("Tab 2", new JLabel());
            this.setPreferredSize(new Dimension(100, 30));
        }
        new MouseEventSupport(this).install();
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
        try {
            if (!this.dynamic) {
                this.loadTabs();
            }
        }
        catch (Throwable t) {
            System.out.println("[WARN] error loading tabs caused by " + t.getMessage());
        }
    }

    @Override
    public void refresh() {
        Component comp;
        boolean dynamic = this.isDynamic();
        try {
            if (dynamic) {
                this.loadTabs();
            }
        }
        catch (Throwable t) {
            System.out.println("[WARN] error loading tabs caused by " + t.getMessage());
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        ExpressionResolver er = ExpressionResolver.getInstance();
        String expr = this.getDisableWhen();
        if (expr != null && expr.length() > 0 && bean != null) {
            try {
                boolean b = er.evalBoolean(expr, bean);
                this.setEnabled(!b);
            }
            catch (Throwable b) {
                // empty catch block
            }
        }
        if (!dynamic && (comp = this.getSelectedComponent()) instanceof TabbedItemPanel) {
            TabbedItemPanel itemPanel = (TabbedItemPanel)comp;
            itemPanel.refreshContent();
        }
        int tabCount = this.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            String disableWhen;
            Component c = this.getComponentAt(i);
            if (!(c instanceof TabbedItemPanel)) continue;
            Opener op = ((TabbedItemPanel)c).getOpener();
            Object ov = op.getProperties().get("disableWhen");
            String string = disableWhen = ov == null ? null : ov.toString();
            if (disableWhen == null || disableWhen.length() == 0) continue;
            try {
                boolean b = er.evalBoolean(disableWhen, bean);
                this.setEnabledAt(i, !b);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("disableWhen", this.getDisableWhen());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (Beans.isDesignTime()) {
            super.setSelectedIndex(index);
            return;
        }
        if (this.noSelectionAllowed) {
            return;
        }
        try {
            Component c = this.getComponentAt(index);
            Map item = this.items.get(index);
            if (!this.model.beforeSelect(item, index)) {
                return;
            }
            this.model.onselect(item);
        }
        catch (Throwable t) {
            if (t instanceof Warning) {
                MsgBox.alert(t.getMessage());
            } else {
                MsgBox.err(t);
            }
            return;
        }
        this.oldIndex = this.getSelectedIndex();
        super.setSelectedIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTabs() {
        this.loadItems();
        this.removeAll();
        ExpressionResolver expRes = ExpressionResolver.getInstance();
        for (Map op : this.items) {
            Object ov = op.get("visibleWhen");
            String sv = ov == null ? null : ov.toString();
            boolean allowed = true;
            if (sv != null && sv.length() > 0) {
                try {
                    allowed = expRes.evalBoolean(sv, this.getBinding().getBean());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!allowed) continue;
            String caption = op.get("caption") + "";
            try {
                this.noSelectionAllowed = true;
                JLabel lbl = new JLabel("");
                lbl.setPreferredSize(new Dimension(10, 10));
                lbl.setMaximumSize(new Dimension(10, 10));
                super.addTab(caption, this.getItemIcon(op), lbl);
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                this.noSelectionAllowed = false;
            }
        }
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    private Icon getItemIcon(Map o) {
        Object ov = o.get("icon");
        if (ov != null) {
            return ImageIconSupport.getInstance().getIcon(ov.toString());
        }
        return null;
    }

    private void loadItems() {
        this.items.clear();
        List<Map> value = null;
        String name = this.getName();
        if (name != null && name.length() > 0) {
            try {
                value = UIControlUtil.getBeanValue(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        TabbedListModel newModel = null;
        if (value instanceof TabbedListModel) {
            newModel = (TabbedListModel)((Object)value);
            newModel.setProvider(this.getProviderImpl());
        } else {
            newModel = new TabbedListModel();
        }
        value = newModel.getList();
        if (value != null) {
            if (value.getClass().isArray()) {
                Map[] arrays;
                for (Map o : arrays = (Map[])value) {
                    this.items.add(o);
                }
            } else if (value instanceof Collection) {
                this.items.addAll((Collection<Map>)value);
            }
        }
        this.model = newModel;
    }

    private ProviderImpl getProviderImpl() {
        if (this.providerImpl == null) {
            this.providerImpl = new ProviderImpl();
        }
        return this.providerImpl;
    }

    private class ProviderImpl
    implements TabbedListModel.Provider {
        XTabbedList root;

        private ProviderImpl() {
            this.root = XTabbedList.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void reload() {
            Component comp = this.root.getSelectedComponent();
        }

        @Override
        public void refresh() {
            Component comp = this.root.getSelectedComponent();
        }
    }
}

