/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.ObjectProxy;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.SuggestModel;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.suggest.SuggestItem;
import com.rameses.rcp.control.suggest.SuggestPopup;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.IconedTextField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.support.TextDocument;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.ErrorDialog;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class XSuggest
extends IconedTextField
implements MouseEventSupport.ComponentInfo,
UIInput,
ActiveControl,
Validatable {
    private static final ScheduledExecutorService TASK_POOL = Executors.newScheduledThreadPool(100);
    public final String ACTION_MAPPING_VK_DOWN = "ACTION_MAPPING_VK_DOWN";
    public final String ACTION_MAPPING_VK_UP = "ACTION_MAPPING_VK_UP";
    private TrimSpaceOption trimSpaceOption;
    private TextDocument document;
    private InputVerifierImpl inputVerifier;
    private String varName;
    private String handler;
    private Object handlerObject;
    private String expression;
    private String itemExpression;
    private String type;
    private String visibleWhen;
    private String origtext;
    private Object value;
    private boolean readonly;
    private Binding binding;
    private String[] depends;
    private int index;
    private ControlProperty property;
    private CallbackHandler onselectHandler;
    private CallbackHandler onemptyHandler;
    private SuggestModel model;
    private boolean enable_search;
    private String currentTextValue;
    private int stretchWidth;
    private int stretchHeight;
    private ActionMessage actionMessage;
    private SuggestPopup jpopup;

    public XSuggest() {
        super("com/rameses/rcp/icons/dropdown.png");
        this.initComponent();
    }

    private void initComponent() {
        this.setOrientation("RIGHT");
        this.setVarName("item");
        this.type = "BASIC";
        this.trimSpaceOption = TrimSpaceOption.ALL;
        this.document = new TextDocument();
        this.document.setTextCase(TextCase.NONE);
        this.document.add(new TextDocument.DocumentListener(){

            @Override
            public void onupdate() {
                XSuggest.this.onupdate_document();
            }
        });
        this.setDocument(this.document);
        if (Beans.isDesignTime()) {
            this.document.setTextCase(TextCase.NONE);
            return;
        }
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XSuggest.this.onescape();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
        this.addMouseListener(new MouseListenerImpl());
        this.putClientProperty(UIInputUtil.EventHandler.class, new EventHandlerImpl());
    }

    @Override
    protected void initActionKeys(InputMap inputMap, ActionMap actionMap) {
        KeyStroke vkdown = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(vkdown, "ACTION_MAPPING_VK_DOWN");
        actionMap.put("ACTION_MAPPING_VK_DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XSuggest.this.onmoveDown();
            }
        });
        KeyStroke vkup = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(vkup, "ACTION_MAPPING_VK_UP");
        actionMap.put("ACTION_MAPPING_VK_UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XSuggest.this.onmoveUp();
            }
        });
    }

    @Override
    protected InputVerifier getChildInputVerifier() {
        if (this.inputVerifier == null) {
            this.inputVerifier = new InputVerifierImpl();
        }
        return this.inputVerifier;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }

    public String getItemExpression() {
        return this.itemExpression;
    }

    public void setItemExpression(String itemExpression) {
        this.itemExpression = itemExpression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.buildText();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.buildText();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.origtext == null) {
            this.origtext = text;
        }
    }

    private void buildText() {
        if (!Beans.isDesignTime()) {
            return;
        }
        try {
            String str = this.getExpression();
            if (str == null || str.length() == 0) {
                str = this.getName();
            }
            if (str == null || str.length() == 0) {
                str = this.origtext;
            }
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, str == null ? "" : str, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TextCase getTextCase() {
        return this.document == null ? null : this.document.getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        if (this.document != null) {
            this.document.setTextCase(textCase);
        }
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption option) {
        this.trimSpaceOption = option;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = "LOOKUP".equals(type) ? type : "BASIC";
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expression", this.getExpression());
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("handler", this.getHandler());
        map.put("handlerObject", this.getHandlerObject());
        map.put("itemExpression", this.getItemExpression());
        map.put("readonly", this.isReadonly());
        map.put("varName", this.getVarName());
        return map;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public Object getValue() {
        if (this.value instanceof String) {
            return this.value.toString().length() == 0 ? null : this.value;
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean isNullWhenEmpty() {
        return true;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (this.isFocusable() && this.isEnabled()) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        block11: {
            try {
                String handler;
                this.onselectHandler = null;
                this.onemptyHandler = null;
                Object bean = this.getBinding().getBean();
                Object handlerObj = this.getHandlerObject();
                if (handlerObj == null && (handler = this.getHandler()) != null) {
                    handlerObj = UIControlUtil.getBeanValue(bean, handler);
                }
                if (handlerObj instanceof SuggestModel) {
                    this.model = (SuggestModel)handlerObj;
                    ObjectProxy.MetaInfo meta = ObjectProxy.getMetaInfo(handlerObj);
                    if (meta.containsMethod("onselect")) {
                        this.onselectHandler = new CallbackHandler(meta, "onselect");
                    }
                    if (meta.containsMethod("onempty")) {
                        this.onemptyHandler = new CallbackHandler(meta, "onempty");
                    }
                } else {
                    this.model = new DefaultSuggestModel();
                }
                this.model.setProvider(new SuggestModelProvider());
                this.refreshTextValue();
            }
            catch (Throwable t) {
                ErrorDialog.show(t, this);
            }
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.length() <= 0) break block11;
                Object exprBean = this.createExpressionBean(this.getValue());
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean(exprBean, visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    private Object createExpressionBean(Object itemBean) {
        ExprBeanSupport beanSupport = new ExprBeanSupport(this.binding.getBean());
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font font) {
        this.getControlProperty().setCaptionFont(font);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public ActionMessage getActionMessage() {
        if (this.actionMessage == null) {
            this.actionMessage = new ActionMessage();
        }
        return this.actionMessage;
    }

    @Override
    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    @Override
    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    @Override
    public void validateInput() {
        this.validateInput(this.getActionMessage());
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        this.getControlProperty().setErrorMessage(null);
        Object value = this.getBeanValue();
        if (ValueUtil.isEmpty((Object)value) && this.isRequired()) {
            am.addMessage("1001", "{0} is required.", new Object[]{this.getCaption()});
        }
        if (am.hasMessages()) {
            this.getControlProperty().setErrorMessage(am.toString());
        }
    }

    @Override
    protected void onfocusGained(FocusEvent e) {
        this.enable_search = true;
    }

    @Override
    protected void onfocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        this.enable_search = false;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XSuggest.this.getPopup().setVisible(false);
            }
        });
    }

    protected void onescape() {
        if (this.getPopup().isVisible()) {
            this.getPopup().setVisible(false);
        }
    }

    protected void onmoveDown() {
        if (!this.enable_search) {
            return;
        }
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveDown();
        }
    }

    protected void onmoveUp() {
        if (!this.enable_search) {
            return;
        }
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveUp();
        }
    }

    @Override
    protected void onactionPerformed(ActionEvent e) {
        if (!this.enable_search) {
            return;
        }
        if (this.model == null) {
            return;
        }
        if (this.getPopup().isVisible()) {
            SuggestItem si = this.getPopup().getSuggestedItem();
            this.onselectImpl(si);
        }
    }

    private void onselectImpl(SuggestItem si) {
        try {
            if (si == null) {
                return;
            }
            Object outcome = null;
            Object userobj = si.getUserObject();
            if (this.onselectHandler != null) {
                outcome = this.onselectHandler.invoke(userobj);
            }
            this.refreshTextValue(userobj, true);
            this.getPopup().setVisible(false);
            if ("LOOKUP".equals(this.getType())) {
                this.transferFocus();
            }
            EventQueue.invokeLater(new ProcessOutcome(outcome));
        }
        catch (Throwable t) {
            ErrorDialog.show(t, this);
        }
    }

    private Object getBeanValue() {
        Binding binding = this.getBinding();
        Object bean = binding == null ? null : binding.getBean();
        String name = this.getName();
        if (name != null && name.length() > 0) {
            return UIControlUtil.getBeanValue(bean, name);
        }
        return null;
    }

    private void refreshTextValue() {
        this.refreshTextValue(this.getBeanValue());
    }

    private void refreshTextValue(Object value) {
        this.refreshTextValue(value, false);
    }

    private void refreshTextValue(Object value, boolean makeDirty) {
        String expression;
        this.setValue(value);
        if (!(value != null && value.getClass().getName().startsWith("java.lang.") || (expression = this.getExpression()) == null || expression.length() <= 0)) {
            Object exprBean = this.createExpressionBean(value);
            value = UIControlUtil.evaluateExpr(exprBean, expression);
        }
        this.document.loadValue(value, makeDirty);
        this.currentTextValue = value == null ? null : value.toString();
    }

    private void onupdate_document() {
        if (Beans.isDesignTime()) {
            return;
        }
        if (!this.enable_search) {
            return;
        }
        if (!this.document.isDirty()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("searchtext", this.getText());
        params.put("_start", 0);
        params.put("_limit", this.model == null ? 10 : this.model.getRows());
        TASK_POOL.schedule(new SearchTask(), 10L, TimeUnit.MILLISECONDS);
        TASK_POOL.schedule(new LookupTask(params), 300L, TimeUnit.MILLISECONDS);
    }

    private SuggestPopup getPopup() {
        if (this.jpopup == null) {
            this.jpopup = new SuggestPopup(this);
            this.jpopup.add(new SuggestPopup.SelectionListener(){

                @Override
                public void onselect(SuggestItem item) {
                    XSuggest.this.onselectImpl(item);
                }
            });
        }
        return this.jpopup;
    }

    private void showPopup() {
        if (!this.enable_search) {
            return;
        }
        Rectangle rect = this.getBounds();
        Point point = this.getLocationOnScreen();
        SuggestPopup popup = this.getPopup();
        popup.pack();
        popup.show(this, 0, rect.height);
    }

    private void showSearchStatus() {
        if (!this.enable_search) {
            return;
        }
        String str = this.getText();
        if (str == null || str.length() == 0) {
            this.getPopup().setVisible(false);
        } else {
            this.getPopup().loadSearchComponent();
            this.showPopup();
        }
    }

    private class ProcessOutcome
    implements Runnable {
        XSuggest root;
        private Object result;

        ProcessOutcome(Object result) {
            this.root = XSuggest.this;
            this.result = result;
        }

        @Override
        public void run() {
            Binding binding;
            if (this.result instanceof Opener && (binding = this.root.getBinding()) != null) {
                Opener opener = (Opener)this.result;
                String target = opener.getTarget();
                if (!(target + "").matches("window|_window|popup|_popup")) {
                    opener.setTarget("popup");
                }
                binding.fireNavigation(opener);
            }
        }
    }

    private class EventHandlerImpl
    implements UIInputUtil.EventHandler {
        XSuggest root;

        private EventHandlerImpl() {
            this.root = XSuggest.this;
        }

        @Override
        public boolean allowCustomUpdate() {
            if (this.root.document.isDirty()) {
                if (this.root.onemptyHandler == null) {
                    return false;
                }
                String text = this.root.getText();
                return text == null || text.length() == 0;
            }
            return false;
        }

        @Override
        public void customUpdate() {
            if (this.root.onemptyHandler == null) {
                return;
            }
            if (!this.root.document.isDirty()) {
                return;
            }
            String text = this.root.getText();
            if (text == null || text.length() == 0) {
                XSuggest.this.onemptyHandler.invoke(null);
            }
        }

        @Override
        public void afterUpdate(Object value) {
        }
    }

    private class InputVerifierImpl
    extends InputVerifier {
        XSuggest root;

        private InputVerifierImpl() {
            this.root = XSuggest.this;
        }

        @Override
        public boolean verify(JComponent input) {
            if (Beans.isDesignTime()) {
                return true;
            }
            if (this.root.document.isDirty()) {
                try {
                    boolean typeBasic = "BASIC".equals(this.root.getType());
                    if (typeBasic) {
                        this.root.setValue(this.root.getText());
                    }
                    UIInputUtil.updateBeanValue(this.root, true, false);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            try {
                this.root.refreshTextValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
    }

    private class MouseListenerImpl
    implements MouseListener {
        XSuggest root;

        private MouseListenerImpl() {
            this.root = XSuggest.this;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.root.enable_search) {
                return;
            }
            if (!this.root.document.isDirty()) {
                return;
            }
            String text = this.root.getText();
            if (text == null || text.length() == 0) {
                return;
            }
            Component[] comps = this.root.getPopup().getComponents();
            if (comps == null || comps.length == 0) {
                return;
            }
            this.root.showPopup();
        }
    }

    private class ResultDataLoader
    implements Runnable {
        XSuggest root;
        private List result;
        private String searchtext;

        ResultDataLoader(List result, String searchtext) {
            this.root = XSuggest.this;
            this.result = result;
            this.searchtext = searchtext;
        }

        @Override
        public void run() {
            SuggestPopup popup = this.root.getPopup();
            String str = this.root.getText();
            if (str == null || str.length() == 0) {
                popup.setVisible(false);
                return;
            }
            if (!str.equals(this.searchtext)) {
                return;
            }
            if (this.result == null || this.result.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            String expression = XSuggest.this.getItemExpression();
            ArrayList<SuggestItem> items = new ArrayList<SuggestItem>();
            for (int i = 0; i < popup.getRowSize(); ++i) {
                try {
                    Object o = this.result.get(i);
                    if (expression == null || expression.length() == 0) {
                        items.add(new SuggestItem(o, o.toString()));
                        continue;
                    }
                    Object exprBean = XSuggest.this.createExpressionBean(o);
                    Object caption = UIControlUtil.evaluateExpr(exprBean, expression);
                    items.add(new SuggestItem(o, caption == null ? "" : caption.toString()));
                    continue;
                }
                catch (Throwable t) {
                    break;
                }
            }
            if (items.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            popup.setData(items);
            XSuggest.this.showPopup();
        }
    }

    private class SuggestModelProvider
    implements SuggestModel.Provider {
        XSuggest root;

        private SuggestModelProvider() {
            this.root = XSuggest.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }
    }

    private class CallbackHandler {
        private ObjectProxy.MetaInfo meta;
        private String name;

        CallbackHandler(ObjectProxy.MetaInfo meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        Object invoke(Object value) {
            Method method = this.meta.getMethod(this.name, new Class[]{Object[].class});
            if (method != null) {
                Object[] objectArray;
                if (value == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = value;
                }
                Object[] args = objectArray;
                return this.meta.invoke(method, new Object[]{args});
            }
            method = this.meta.getMethod(this.name, new Class[]{Object.class});
            if (method != null) {
                return this.meta.invoke(method, new Object[]{value});
            }
            method = this.meta.getMethod(this.name, new Class[0]);
            if (method != null) {
                return this.meta.invoke(method, new Object[0]);
            }
            return null;
        }
    }

    private class DefaultSuggestModel
    extends SuggestModel {
        XSuggest root;

        private DefaultSuggestModel() {
            this.root = XSuggest.this;
        }
    }

    private class LookupTask
    implements Runnable {
        XSuggest root;
        private String searchtext;
        private Map params;

        LookupTask(Map params) {
            this.root = XSuggest.this;
            this.params = params;
            this.searchtext = params == null ? null : (String)params.get("searchtext");
        }

        @Override
        public void run() {
            String str = this.root.getText();
            if (str == null || str.length() == 0) {
                XSuggest.this.getPopup().setVisible(false);
                return;
            }
            if (!str.equals(this.searchtext)) {
                return;
            }
            List list = this.root.model == null ? null : this.root.model.fetchList(this.params);
            EventQueue.invokeLater(new ResultDataLoader(list, this.searchtext));
        }
    }

    private class SearchTask
    implements Runnable {
        XSuggest root;

        private SearchTask() {
            this.root = XSuggest.this;
        }

        @Override
        public void run() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XSuggest.this.showSearchStatus();
                }
            });
        }
    }
}

