/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.control.layout.SplitViewLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class XSplitView
extends JPanel
implements SplitViewLayout.Provider {
    private static final long serialVersionUID = 1L;
    private SplitViewLayout layout = new SplitViewLayout(this);
    private Rectangle viewRect;
    private Rectangle dividerRect;
    private Point targetPoint;
    private boolean showDividerBorder;

    public XSplitView() {
        super.setLayout(this.layout);
    }

    @Override
    public LayoutManager getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public String getOrientation() {
        return this.layout.getOrientation();
    }

    public void setOrientation(String orientation) {
        this.layout.setOrientation(orientation);
    }

    public int getDividerSize() {
        return this.layout.getDividerSize();
    }

    public void setDividerSize(int dividerSize) {
        this.layout.setDividerSize(dividerSize);
    }

    public int getDividerLocation() {
        return this.layout.getDividerLocation();
    }

    public void setDividerLocation(int dividerLocation) {
        this.layout.setDividerLocation(dividerLocation);
    }

    public int getDividerLocationPercentage() {
        return this.layout.getDividerLocationPercentage();
    }

    public void setDividerLocationPercentage(int dividerLocationPercentage) {
        this.layout.setDividerLocationPercentage(dividerLocationPercentage);
    }

    public boolean isShowDividerBorder() {
        return this.layout.isShowDividerBorder();
    }

    public void setShowDividerBorder(boolean showDividerBorder) {
        this.layout.setShowDividerBorder(showDividerBorder);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.dividerRect != null && this.targetPoint != null) {
            Rectangle newRect = new Rectangle();
            newRect.x = this.dividerRect.x;
            newRect.y = this.dividerRect.y;
            newRect.width = this.dividerRect.width;
            newRect.height = this.dividerRect.height;
            if ("vertical".equalsIgnoreCase(this.getOrientation() + "")) {
                newRect.y = this.dividerRect.y + this.targetPoint.y;
            } else {
                newRect.x = this.dividerRect.x + this.targetPoint.x;
            }
            Color oldColor = g.getColor();
            Color newColor = this.getBackground();
            newColor = newColor == null ? Color.DARK_GRAY : newColor.darker();
            Graphics gg = g.create();
            gg.setColor(newColor);
            gg.fillRect(newRect.x, newRect.y, newRect.width, newRect.height);
            gg.setColor(oldColor);
            this.dividerRect = null;
            this.targetPoint = null;
        }
    }

    @Override
    public void paintDividerHandle(Rectangle viewRect, Rectangle dividerRect, Point targetPoint) {
        this.viewRect = viewRect;
        this.dividerRect = dividerRect;
        this.targetPoint = targetPoint;
        this.repaint();
    }
}

