/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class XScrollPane
extends JScrollPane {
    private FocusChangeListener focusChangeListener = new FocusChangeListener();

    @Override
    public void setViewportView(Component view) {
        super.setViewportView(view);
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.removePropertyChangeListener("focusOwner", this.focusChangeListener);
        if (view != null) {
            kfm.addPropertyChangeListener("focusOwner", this.focusChangeListener);
        }
    }

    private class FocusChangeListener
    implements PropertyChangeListener {
        XScrollPane root;

        private FocusChangeListener() {
            this.root = XScrollPane.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            if (!(newValue instanceof JComponent)) {
                return;
            }
            JComponent view = (JComponent)this.root.getViewport().getView();
            if (view == null) {
                return;
            }
            JComponent focused = (JComponent)newValue;
            if (view.isAncestorOf(focused)) {
                JComponent jparent = (JComponent)focused.getParent();
                if (jparent instanceof JViewport) {
                    jparent = (JComponent)((JViewport)jparent).getParent().getParent();
                }
                if (jparent != null) {
                    jparent.scrollRectToVisible(focused.getBounds());
                }
            }
        }
    }
}

