/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class XRadio
extends JRadioButton
implements UIInput,
ItemListener,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private boolean readonly;
    private int index;
    private Object optionValue;
    private ButtonGroup buttonGroup;
    private ControlProperty property = new ControlProperty();
    private int stretchWidth;
    private int stretchHeight;
    private String disableWhen;
    private String visibleWhen;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;

    public XRadio() {
        this.initComponent();
    }

    private void initComponent() {
        this.setModel(new ToggleButtonModelImpl());
        this.addItemListener(this);
        new MouseEventSupport(this).install();
        KeyStroke ks = KeyStroke.getKeyStroke(40, 0, true);
        this.registerKeyboardAction(new MoveAction(40), ks, 0);
        ks = KeyStroke.getKeyStroke(38, 0, true);
        this.registerKeyboardAction(new MoveAction(38), ks, 0);
    }

    @Override
    public void refresh() {
        block9: {
            try {
                if (this.isEnabled()) {
                    this.setReadonly(this.isReadonly());
                }
                Object value = UIControlUtil.getBeanValue(this);
                this.setValue(value);
            }
            catch (Throwable e) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block9;
                e.printStackTrace();
            }
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getDisableWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean disabled = false;
            try {
                disabled = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setEnabled(!disabled);
        }
        if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        String name = this.getName();
        if (!ValueUtil.isEmpty((Object)name)) {
            HashMap<String, ButtonGroup> m = (HashMap<String, ButtonGroup>)this.binding.getProperties().get(ButtonGroup.class);
            if (m == null) {
                m = new HashMap<String, ButtonGroup>();
                this.binding.getProperties().put(ButtonGroup.class, m);
            }
            if (!m.containsKey(name)) {
                m.put(name, new ButtonGroup());
            }
            this.buttonGroup = (ButtonGroup)m.get(name);
            this.buttonGroup.add(this);
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnemonic", Character.valueOf((char)this.getMnemonic()));
        map.put("optionValue", this.getOptionValue());
        return map;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            UIInputUtil.updateBeanValue(this);
        }
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    @Override
    public void setValue(Object value) {
        if (value != null && value.equals(this.optionValue)) {
            this.setSelected(true);
        }
    }

    @Override
    public Object getValue() {
        ButtonModel bm = this.getModel();
        if (bm instanceof DefaultButtonModel) {
            ButtonModel sel;
            DefaultButtonModel dbm = (DefaultButtonModel)bm;
            ButtonModel buttonModel = sel = dbm.getGroup() == null ? null : dbm.getGroup().getSelection();
            if (sel instanceof ToggleButtonModelImpl) {
                return ((ToggleButtonModelImpl)sel).getOptionValue();
            }
        }
        if (this.isSelected()) {
            return this.optionValue;
        }
        return null;
    }

    @Override
    public boolean isNullWhenEmpty() {
        return true;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        super.setEnabled(!readonly);
        super.firePropertyChange("enabled", readonly, !readonly);
        this.repaint();
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    public Object getOptionValue() {
        return this.optionValue;
    }

    public void setOptionValue(Object optionValue) {
        this.optionValue = optionValue;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public void setMnemonic(char mnemonic) {
        super.setMnemonic(mnemonic);
        this.resolveDisplayMnemonic();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resolveDisplayMnemonic();
    }

    private void resolveDisplayMnemonic() {
        char mnemonic = (char)this.getMnemonic();
        if (mnemonic == '\u0000') {
            return;
        }
        String text = this.getText();
        if (text == null) {
            return;
        }
        String stext = text.toLowerCase();
        if (!stext.trim().matches("<html>.*</html>")) {
            return;
        }
        char cval = Character.toLowerCase(mnemonic);
        Pattern p = Pattern.compile("<.*?>");
        Matcher m = p.matcher(text);
        int startindex = 0;
        int locIndex = -1;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (start > startindex) {
                char[] chars = stext.substring(startindex, start).toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] != cval) continue;
                    locIndex = startindex + i;
                    break;
                }
            }
            if (locIndex >= 0) break;
            startindex = end;
        }
        if (locIndex < 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(text.substring(0, locIndex));
        sb.append("<u>" + text.charAt(locIndex) + "</u>");
        sb.append(text.substring(locIndex + 1));
        super.setText(sb.toString());
    }

    private class ToggleButtonModelImpl
    extends JToggleButton.ToggleButtonModel {
        XRadio root;

        private ToggleButtonModelImpl() {
            this.root = XRadio.this;
        }

        public Object getOptionValue() {
            return this.root.getOptionValue();
        }
    }

    private class MoveAction
    implements ActionListener {
        private int keycode;

        MoveAction(int keycode) {
            this.keycode = keycode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XRadio.this.buttonGroup == null) {
                return;
            }
            if (e.getSource() instanceof XRadio) {
                XRadio btn = (XRadio)e.getSource();
                ArrayList<XRadio> list = new ArrayList<XRadio>();
                Enumeration<AbstractButton> en = XRadio.this.buttonGroup.getElements();
                while (en.hasMoreElements()) {
                    AbstractButton o = en.nextElement();
                    if (!(o instanceof XRadio)) continue;
                    list.add((XRadio)o);
                }
                if (list.isEmpty()) {
                    return;
                }
                int idx = list.indexOf(btn);
                if (idx < 0) {
                    return;
                }
                if (this.keycode == 40) {
                    if (idx + 1 < list.size()) {
                        btn = (XRadio)list.get(idx + 1);
                    } else if (idx + 1 == list.size()) {
                        btn = (XRadio)list.get(0);
                    }
                } else if (this.keycode == 38) {
                    if (idx - 1 >= 0 && idx - 1 < list.size()) {
                        btn = (XRadio)list.get(idx - 1);
                    } else if (idx - 1 < 0) {
                        btn = (XRadio)list.get(list.size() - 1);
                    }
                } else {
                    return;
                }
                if (!btn.isFocusOwner()) {
                    btn.requestFocusInWindow();
                    btn.setSelected(true);
                }
            }
        }
    }
}

