/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.ProgressModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;

public class XProgressBar
extends JProgressBar
implements UIControl,
MouseEventSupport.ComponentInfo,
ActiveControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private String disableWhen;
    private String handler;
    private ProgressModel progmodel;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private ControlProperty property;

    public XProgressBar() {
        this.initComponent();
    }

    private void initComponent() {
        this.setPreferredSize(new Dimension(100, 20));
        this.setStringPainted(true);
        new MouseEventSupport(this).install();
        if (Beans.isDesignTime()) {
            this.setMinimum(0);
            this.setMaximum(100);
            this.setValue(75);
        }
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
        Object handlerObj = null;
        String handler = this.getHandler();
        if (handler != null && handler.trim().length() > 0) {
            handlerObj = UIControlUtil.getBeanValue(this.getBinding(), handler);
        }
        if (this.progmodel != null) {
            this.progmodel.setProvider(null);
        }
        this.progmodel = handlerObj instanceof ProgressModel ? (ProgressModel)handlerObj : new ProgressModel();
        this.progmodel.setProvider(new ProviderImpl());
    }

    @Override
    public void refresh() {
        boolean result;
        int min = Math.max(this.progmodel.getMinValue(), 0);
        int max = this.progmodel.getMaxValue();
        max = max > 0 ? max : min + 1;
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValue(this.progmodel.getValue());
        String expr = this.getDisableWhen();
        if (expr != null && expr.length() > 0) {
            result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), expr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setEnabled(result);
        }
        if ((expr = this.getVisibleWhen()) != null && expr.length() > 0) {
            result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), expr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("handler", this.getHandler());
        map.put("disableWhen", this.getDisableWhen());
        map.put("visibleWhen", this.getVisibleWhen());
        return map;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private class ProviderImpl
    implements ProgressModel.Provider {
        XProgressBar root;

        private ProviderImpl() {
            this.root = XProgressBar.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void adjustValues(int min, int max, int value) {
            min = Math.max(min, 0);
            max = max > 0 ? max : min + 1;
            value = Math.max(value, 0);
            this.root.setMinimum(min);
            this.root.setMaximum(max);
            this.root.setValue(value);
            this.root.repaint();
        }

        @Override
        public void adjustText(String text) {
            if (text != null) {
                this.root.setString(text);
                this.root.repaint();
            }
        }
    }
}

