/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.Base64Cipher;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.Beans;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class XPhoto
extends JLabel
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    static final String DEFAULT_NO_IMAGE_ICON = "com/rameses/rcp/icons/photo.png";
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean dynamic;
    private ImageIcon iicon;
    private BufferedImage iiconImage;
    private NoImageCanvas noImageCanvas;
    private ImageCanvas imageCanvas;
    private String noImageIcon;
    private Color noImageBackground;
    private Color noImageForeground;
    private boolean showNoImageText;
    private boolean showNoImageIcon;
    private boolean scaled = true;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;
    private Base64Cipher base64;

    public XPhoto() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(120, 100));
        this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.setNoImageIcon(DEFAULT_NO_IMAGE_ICON);
        this.setShowNoImageIcon(true);
        this.setShowNoImageText(false);
        this.noImageCanvas = new NoImageCanvas();
        this.imageCanvas = new ImageCanvas();
        Font oldFont = this.getFont();
        if (oldFont != null) {
            this.setFont(oldFont.deriveFont(1, 14.0f));
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.noImageCanvas != null) {
            this.noImageCanvas.setFont(font);
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getNoImageIcon() {
        return this.noImageIcon;
    }

    public void setNoImageIcon(String noImageIcon) {
        this.noImageIcon = noImageIcon;
    }

    public Color getNoImageBackground() {
        return this.noImageBackground;
    }

    public void setNoImageBackground(Color noImageBackground) {
        this.noImageBackground = noImageBackground;
    }

    public Color getNoImageForeground() {
        return this.noImageForeground;
    }

    public void setNoImageForeground(Color noImageForeground) {
        this.noImageForeground = noImageForeground;
    }

    public boolean isShowNoImageText() {
        return this.showNoImageText;
    }

    public void setShowNoImageText(boolean showNoImageText) {
        this.showNoImageText = showNoImageText;
    }

    public boolean isShowNoImageIcon() {
        return this.showNoImageIcon;
    }

    public void setShowNoImageIcon(boolean showNoImageIcon) {
        this.showNoImageIcon = showNoImageIcon;
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public void setScaled(boolean scaled) {
        this.scaled = scaled;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        try {
            Object beanValue = null;
            String name = this.getName();
            if (name != null && name.length() > 0) {
                beanValue = UIControlUtil.getBeanValue(this.getBinding(), name);
            }
            this.iicon = this.resolveImage(beanValue);
        }
        catch (Throwable e) {
            this.iicon = null;
            if (ClientContext.getCurrentContext().isDebugMode()) {
                e.printStackTrace();
            }
        }
        finally {
            this.iiconImage = null;
        }
        this.removeAll();
        this.revalidate();
        this.repaint();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("dynamic", this.isDynamic());
        return map;
    }

    public void paint1(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.iicon == null) {
            this.paintNoImage(g2, w, h);
        } else {
            this.paintImage(g2, w, h, this.iicon);
        }
        g2.dispose();
    }

    protected void paintNoImage(Graphics2D g2, int width, int height) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setBackground(Color.BLACK);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.DARK_GRAY);
        g2.setStroke(new BasicStroke(3.0f));
        g2.drawLine(0, 0, width - 1, height - 1);
        g2.drawLine(0, height - 1, width - 1, 0);
        String str = "No Available";
        FontMetrics metrics = g2.getFontMetrics(this.getFont());
        int fw = metrics.stringWidth(str);
        int fh = metrics.getHeight();
        int x = Math.max((width - fw) / 2, 0);
        int y = Math.max(height / 2 - fh / 2, 0) + 4;
        g2.setFont(this.getFont());
        g2.setColor(Color.WHITE);
        g2.drawString(str, x, y);
        str = "Photo";
        fw = metrics.stringWidth(str);
        fh = metrics.getHeight();
        x = Math.max((width - fw) / 2, 0);
        y = Math.max(height / 2 + fh / 2, 0) + 4;
        g2.drawString(str, x, y);
    }

    protected void paintImage(Graphics2D g2, int width, int height, ImageIcon anIcon) {
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, width, height);
        g2.setBackground(Color.YELLOW);
        g2.fillRect(0, 0, width, height);
        g2.drawImage(anIcon.getImage(), 0, 0, null);
    }

    private Rectangle getScaleRect(ImageIcon iicon, int width, int height) {
        double scaleX;
        int iw = iicon.getIconWidth();
        int ih = iicon.getIconHeight();
        double scaleY = (double)height / (double)ih;
        double scale = scaleY > (scaleX = (double)width / (double)iw) ? scaleX : scaleY;
        int nw = (int)((double)iw * scale);
        int nh = (int)((double)ih * scale);
        int nx = (width - nw) / 2;
        int ny = (height - nh) / 2;
        return new Rectangle(nx, ny, nw, nh);
    }

    private BufferedImage getIconImage() {
        try {
            if (this.iiconImage == null) {
                ImageIcon icon = this.iicon;
                int iw = icon.getIconWidth();
                int ih = icon.getIconHeight();
                BufferedImage bi = new BufferedImage(iw, ih, 2);
                Graphics2D gbi = bi.createGraphics();
                gbi.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gbi.drawImage(icon.getImage(), 0, 0, null);
                gbi.dispose();
                this.iiconImage = bi;
            }
            return this.iiconImage;
        }
        catch (Throwable t) {
            if (ClientContext.getCurrentContext().isDebugMode()) {
                t.printStackTrace();
            }
            return null;
        }
    }

    private Base64Cipher getBase64Cipher() {
        if (this.base64 == null) {
            this.base64 = new Base64Cipher();
        }
        return this.base64;
    }

    private ImageIcon resolveImage(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new ImageIcon((byte[])value);
        }
        if (value instanceof URL) {
            return new ImageIcon((URL)value);
        }
        if (value instanceof ImageIcon) {
            return (ImageIcon)value;
        }
        if (value instanceof Image) {
            return new ImageIcon((Image)value);
        }
        if (value instanceof String) {
            String str = value.toString().toLowerCase();
            if (str.matches("[a-zA-Z]{1,}://.*")) {
                return new ImageIcon(new URL(value.toString()));
            }
            if (this.getBase64Cipher().isEncoded(value.toString())) {
                Object o = this.getBase64Cipher().decode(value.toString(), false);
                return this.resolveImage(o);
            }
            URL url = this.getClass().getClassLoader().getResource((String)value);
            if (url != null) {
                return new ImageIcon(url);
            }
        }
        return null;
    }

    private class DefaultLayout
    implements LayoutManager {
        XPhoto root;

        private DefaultLayout() {
            this.root = XPhoto.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int width = margin.left + margin.right;
                int height = margin.top + margin.bottom;
                return new Dimension(width, height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                JLabel c = null;
                c = XPhoto.this.iicon == null ? XPhoto.this.noImageCanvas : XPhoto.this.imageCanvas;
                if (c.getParent() == null) {
                    parent.add(c);
                }
                c.setBounds(x, y, w, h);
            }
        }
    }

    private class ImageCanvas
    extends JLabel {
        XPhoto root;

        ImageCanvas() {
            this.root = XPhoto.this;
            this.setHorizontalAlignment(0);
        }

        @Override
        public void paintComponent(Graphics g) {
            BufferedImage bi;
            super.paintComponent(g);
            ImageIcon iicon = this.root.iicon;
            if (iicon == null) {
                return;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            Rectangle rect = new Rectangle(0, 0, width, height);
            if (XPhoto.this.isScaled()) {
                rect = XPhoto.this.getScaleRect(iicon, width, height);
            }
            if ((bi = XPhoto.this.getIconImage()) != null) {
                Image scaledImage = bi.getScaledInstance(rect.width, rect.height, 4);
                Graphics2D g2 = (Graphics2D)g.create();
                g2.drawImage(scaledImage, rect.x, rect.y, rect.width, rect.height, null);
                g2.dispose();
            }
        }

        private BufferedImage createCompatibleImage(int width, int height) {
            GraphicsConfiguration gc = this.getGC();
            BufferedImage bi = gc.createCompatibleImage(width, height, 3);
            return bi;
        }

        private GraphicsConfiguration getGC() {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
    }

    private class NoImageCanvas
    extends JLabel {
        private ImageIcon photoIcon;

        private NoImageCanvas() {
        }

        private ImageIcon getPhotoIcon() {
            if (this.photoIcon == null) {
                try {
                    ClassLoader loader = null;
                    loader = Beans.isDesignTime() ? this.getClass().getClassLoader() : ClientContext.getCurrentContext().getClassLoader();
                    URL url = loader.getResource(XPhoto.this.getNoImageIcon());
                    this.photoIcon = new ImageIcon(url);
                }
                catch (Throwable ex) {
                    System.out.println("[WARN] failed to load icon caused by " + ex.getClass().getName() + ": " + ex.getMessage());
                }
            }
            return this.photoIcon;
        }

        @Override
        public void paint(Graphics g) {
            ImageIcon photoIcon;
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            Color oldColor = g2.getColor();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color bgcolor = XPhoto.this.getNoImageBackground();
            if (bgcolor != null) {
                g2.setColor(bgcolor);
                g2.fillRect(0, 0, width, height);
            }
            if (XPhoto.this.isShowNoImageIcon() && (photoIcon = this.getPhotoIcon()) != null) {
                Rectangle nrect = new Rectangle(0, 0, width, height);
                if (XPhoto.this.isScaled()) {
                    nrect = XPhoto.this.getScaleRect(photoIcon, width, height);
                }
                g2.drawImage(photoIcon.getImage(), nrect.x, nrect.y, nrect.width, nrect.height, null);
            }
            if (XPhoto.this.isShowNoImageText()) {
                String str = "No Available";
                FontMetrics metrics = g2.getFontMetrics(this.getFont());
                int fw = metrics.stringWidth(str);
                int fh = metrics.getHeight();
                int x = Math.max((width - fw) / 2, 0);
                int y = Math.max(height / 2 - fh / 2, 0) + 4;
                Color shadowColor = Color.decode("#808080");
                Color forecolor = XPhoto.this.getNoImageForeground();
                if (forecolor == null) {
                    forecolor = Color.WHITE;
                }
                g2.setFont(this.getFont());
                g2.setColor(shadowColor);
                g2.drawString(str, x, y + 1);
                g2.setColor(forecolor);
                g2.drawString(str, x, y);
                str = "Photo";
                fw = metrics.stringWidth(str);
                fh = metrics.getHeight();
                x = Math.max((width - fw) / 2, 0);
                y = Math.max(height / 2 + fh / 2, 0) + 4;
                g2.setColor(shadowColor);
                g2.drawString(str, x, y + 1);
                g2.setColor(forecolor);
                g2.drawString(str, x, y);
            }
            g2.dispose();
        }
    }
}

