/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.text.DefaultPasswordField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class XPasswordField
extends DefaultPasswordField
implements UIInput,
ActiveControl,
Validatable,
MouseEventSupport.ComponentInfo {
    protected Binding binding;
    private String[] depends = new String[0];
    private String hint;
    private boolean nullWhenEmpty = true;
    private int index;
    private boolean showHint;
    private boolean isHintShown;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private ControlProperty property;
    private ActionMessage actionMessage;
    private boolean required;

    @Override
    protected void initDefaults() {
        super.setFont(Font.decode("Monospaced--"));
        Insets margin = UIManager.getInsets("TextField.margin");
        if (margin != null) {
            Border borderOut = this.getBorder();
            Border borderIn = BorderFactory.createEmptyBorder(0, margin.left, 0, 0);
            this.setBorder(BorderFactory.createCompoundBorder(borderOut, borderIn));
        }
        if (Beans.isDesignTime()) {
            return;
        }
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XPasswordField.this.refresh();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public void setHint(String hint) {
        this.hint = hint;
        this.showHint = hint != null && hint.length() > 0;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Object getValue() {
        if (Beans.isDesignTime()) {
            return "";
        }
        return String.valueOf(this.getPassword());
    }

    @Override
    public void setValue(Object value) {
        super.setText(value == null ? "" : value.toString());
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public void load() {
        if (this.showHint) {
            this.isHintShown = true;
        }
    }

    @Override
    public void refresh() {
        block5: {
            try {
                this.updateBackground();
                Object value = UIControlUtil.getBeanValue(this);
                this.setValue(value);
            }
            catch (Throwable e) {
                this.setValue(null);
                if (!ClientContext.getCurrentContext().isDebugMode()) break block5;
                e.printStackTrace();
            }
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Comparable<Character>> map = new HashMap<String, Comparable<Character>>();
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("nullWhenEmpty", Boolean.valueOf(this.isNullWhenEmpty()));
        map.put("required", Boolean.valueOf(this.isRequired()));
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    @Override
    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public ActionMessage getActionMessage() {
        if (this.actionMessage == null) {
            this.actionMessage = new ActionMessage();
        }
        return this.actionMessage;
    }

    @Override
    public void validateInput() {
        this.validateInput(this.getActionMessage());
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        this.getControlProperty().setErrorMessage(null);
        char[] chars = this.getPassword();
        if ((chars == null || chars.length == 0) && this.isRequired()) {
            am.addMessage("", "{0} is required.", new Object[]{this.getCaption()});
            this.getControlProperty().setErrorMessage(am.toString());
        }
    }
}

