/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.control.menu.MenuProxy;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.beans.Beans;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class XMenu
extends JPanel
implements UIControl {
    private Binding binding;
    private int index;
    private String[] depends;
    private boolean dynamic;
    private String handler;
    private TreeNodeModel nodeModel;
    private Node selectedNode;
    private JMenuBar menuBar;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public XMenu() {
        super.setLayout(new BorderLayout());
        this.setOpaque(false);
        if (Beans.isDesignTime()) {
            JMenuBar jmb = new JMenuBar();
            jmb.add(new JMenu("XMenu1"));
            this.add(jmb);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void refresh() {
        String whenExpr;
        if (this.dynamic) {
            this.buildPlainMenu(null);
        }
        if ((whenExpr = this.getVisibleWhen()) != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        if (ValueUtil.isEmpty((Object)this.handler)) {
            throw new IllegalStateException("XTree Error: A handler must be provided");
        }
        this.nodeModel = (TreeNodeModel)UIControlUtil.getBeanValue(this, this.handler);
        this.menuBar = new JMenuBar();
        this.add(this.menuBar);
        if (!this.dynamic) {
            this.buildPlainMenu(null);
        }
    }

    private void buildPlainMenu(Node parent) {
        this.menuBar.removeAll();
        Node[] nodes = this.nodeModel.fetchNodes(this.nodeModel.getRootNode());
        if (parent == null) {
            for (Node n : nodes) {
                this.menuBar.add(new MenuProxy(this, this.nodeModel, n));
            }
        }
        this.menuBar.revalidate();
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }
}

