/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.ListPaneModel;
import com.rameses.rcp.common.MapObject;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.BreakException;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XList
extends JList
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private ListSelectionSupport selectionSupport;
    private Binding binding;
    private String[] depends;
    private String varName;
    private String varStatus;
    private String expression;
    private String items;
    private String handler;
    private String openAction;
    private boolean dynamic;
    private int index;
    private ListPaneModel listPaneModel;
    private DefaultListModelImpl model;
    private Insets padding = new Insets(1, 3, 1, 3);
    private int cellVerticalAlignment = 0;
    private int cellHorizontalAlignment = 10;
    private int cellHorizontalTextPosition = 11;
    private int cellVecticalTextPosition = 0;
    private boolean enableNavigation;
    private FontSupport fontSupport;
    private Font sourceFont;
    private String fontStyle;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private RefreshTask refreshTask;
    private ControlProperty property;
    private Timer timer;

    public XList() {
        super.addListSelectionListener(this.getSelectionSupport());
        this.setCellRenderer(new DefaultCellRenderer());
        this.setEnableNavigation(true);
        this.setMultiselect(false);
        this.setVarName("item");
        if (Beans.isDesignTime()) {
            this.setPreferredSize(new Dimension(80, 100));
            super.setModel(new AbstractListModel(){
                String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

                @Override
                public int getSize() {
                    return this.strings.length;
                }

                @Override
                public Object getElementAt(int i) {
                    return this.strings[i];
                }
            });
        } else {
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XList.this.fireOpenItem();
                }
            }, KeyStroke.getKeyStroke(10, 0), 0);
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (XList.this.listPaneModel == null) {
                        return;
                    }
                    if (!XList.this.listPaneModel.isEditable()) {
                        return;
                    }
                    if (!XList.this.listPaneModel.isAllowRemove()) {
                        return;
                    }
                    XList.this.fireRemoveItem();
                }
            }, KeyStroke.getKeyStroke(127, 0), 0);
        }
        new MouseEventSupport(this).install();
    }

    public final void setModel(ListModel model) {
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isEnableNavigation() {
        return this.enableNavigation;
    }

    public void setEnableNavigation(boolean enableNavigation) {
        this.enableNavigation = enableNavigation;
        boolean enabled = this.isEnabled();
        this.firePropertyChange("enabled", !enabled, enabled);
    }

    public boolean isMultiselect() {
        return this.getSelectionMode() == 2;
    }

    public void setMultiselect(boolean multi) {
        if (multi) {
            this.setSelectionMode(2);
        } else {
            this.setSelectionMode(0);
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding == null ? new Insets(0, 0, 0, 0) : padding;
    }

    public int getCellVerticalAlignment() {
        return this.cellVerticalAlignment;
    }

    public void setCellVerticalAlignment(int cellVerticalAlignment) {
        this.cellVerticalAlignment = cellVerticalAlignment;
    }

    public int getCellHorizontalAlignment() {
        return this.cellHorizontalAlignment;
    }

    public void setCellHorizontalAlignment(int cellHorizontalAlignment) {
        this.cellHorizontalAlignment = cellHorizontalAlignment;
    }

    public int getCellVerticalTextPosition() {
        return this.cellVecticalTextPosition;
    }

    public void setCellVerticalTextPosition(int cellVecticalTextPosition) {
        this.cellVecticalTextPosition = cellVecticalTextPosition;
    }

    public int getCellHorizontalTextPosition() {
        return this.cellHorizontalTextPosition;
    }

    public void setCellHorizontalTextPosition(int cellHorizontalTextPosition) {
        this.cellHorizontalTextPosition = cellHorizontalTextPosition;
    }

    public String getOpenAction() {
        return this.openAction;
    }

    public void setOpenAction(String openAction) {
        this.openAction = openAction;
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        if (this.sourceFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            this.sourceFont = this.getFontSupport().applyStyles(this.sourceFont, attrs);
        }
        super.setFont(this.sourceFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        Font font;
        this.fontStyle = fontStyle;
        if (this.sourceFont == null) {
            this.sourceFont = super.getFont();
        }
        if ((font = this.sourceFont) == null) {
            return;
        }
        Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
        font = this.getFontSupport().applyStyles(font, attrs);
        super.setFont(font);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public void load() {
        this.model = new DefaultListModelImpl();
        super.setModel(this.model);
        if (!this.isDynamic()) {
            this.buildList();
        }
    }

    @Override
    public void refresh() {
        long intervalrate;
        this.refresh(this.isDynamic());
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
        long l = intervalrate = this.listPaneModel == null ? 0L : this.listPaneModel.getRefreshInterval();
        if (intervalrate > 0L) {
            this.executeRefreshTask(intervalrate);
        }
    }

    private void refresh(boolean reload) {
        if (reload) {
            this.buildList();
        }
        try {
            this.model.is_adjusting = true;
            this.selectSelectedItems();
        }
        finally {
            this.model.is_adjusting = false;
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("expression", this.getExpression());
        map.put("handler", this.getHandler());
        map.put("items", this.getItems());
        map.put("multiselect", this.isMultiselect());
        map.put("openAction", this.getOpenAction());
        map.put("varName", this.getVarName());
        map.put("varStatus", this.getVarStatus());
        return map;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.getSelectionSupport().add(listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getSelectionSupport().remove(listener);
    }

    private ListSelectionSupport getSelectionSupport() {
        if (this.selectionSupport == null) {
            this.selectionSupport = new ListSelectionSupport();
        }
        return this.selectionSupport;
    }

    private void fireOpenItem() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                XList.this.openItem();
            }
        });
    }

    private void fireRemoveItem() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XList.this.removeItem();
                    XList.this.refresh(true);
                }
                catch (BreakException breakException) {
                }
                catch (Exception e) {
                    MsgBox.err(e);
                }
            }
        });
    }

    protected void openItem() {
        try {
            if (ValueUtil.isEmpty((Object)this.openAction)) {
                return;
            }
            MethodResolver mr = MethodResolver.getInstance();
            Object outcome = mr.invoke(this.binding.getBean(), this.openAction, null, null);
            if (outcome == null) {
                return;
            }
            this.binding.fireNavigation(outcome);
        }
        catch (BreakException mr) {
        }
        catch (Exception e) {
            MsgBox.err(e);
        }
    }

    protected boolean removeItem() {
        Object value = this.getSelectedValue();
        return this.removeItem(value);
    }

    protected boolean removeItem(Object item) {
        if (this.listPaneModel == null) {
            return false;
        }
        return this.listPaneModel.removeItem(item);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && e.getClickCount() == 2) {
            e.consume();
            this.fireOpenItem();
        } else {
            super.processMouseEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildList() {
        boolean hasItems;
        String strHandler = this.getHandler();
        String strItems = this.getItems();
        boolean hasHandler = strHandler != null && strHandler.length() > 0;
        boolean bl = hasItems = strItems != null && strItems.length() > 0;
        if (!hasHandler && !hasItems) {
            return;
        }
        ListPaneModel newModel = null;
        if (hasHandler) {
            Object value = null;
            try {
                value = UIControlUtil.getBeanValue(this, strHandler);
            }
            catch (Throwable t) {
                System.out.println("[WARN] error get bean value caused by " + t.getMessage());
            }
            if (value instanceof ListPaneModel) {
                newModel = (ListPaneModel)value;
            }
        } else if (hasItems) {
            Object value = null;
            try {
                value = UIControlUtil.getBeanValue(this, strItems);
            }
            catch (Throwable t) {
                System.out.println("[WARN] error get bean value caused by " + t.getMessage());
            }
            newModel = new DefaultListPaneModel(value);
        }
        try {
            this.model.is_adjusting = true;
            this.loadItems(newModel);
        }
        finally {
            this.model.is_adjusting = false;
        }
    }

    private void loadItems(ListPaneModel newModel) {
        if (newModel == null) {
            return;
        }
        HashMap params = new HashMap();
        ArrayList list = newModel.fetchList(params);
        if (list == null) {
            list = new ArrayList();
        }
        this.model.clear();
        int i = 0;
        for (Object o : list) {
            this.model.add(i++, o);
        }
        ListPaneModel oldModel = this.listPaneModel;
        if (oldModel != null) {
            oldModel.setProvider(null);
        }
        this.listPaneModel = newModel;
        newModel.setProvider(new ProviderImpl());
        newModel.afterFetchList();
    }

    private void selectSelectedItems() {
        Object value = null;
        String name = this.getName();
        if (name != null && name.length() > 0) {
            try {
                value = UIControlUtil.getBeanValue(this);
            }
            catch (Throwable e) {
                System.out.println("[WARN] error get bean value caused by " + e.getMessage());
            }
        }
        if (value == null) {
            this.model.is_adjusting = false;
            this.setSelectedIndex(0);
        } else if (this.isMultiselect()) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (value instanceof Collection) {
                list.addAll((Collection)value);
            } else if (value.getClass().isArray()) {
                for (Object o : (Object[])value) {
                    list.add(o);
                }
            }
            if (list.size() == 0) {
                return;
            }
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < this.model.getSize(); ++i) {
                Object item = this.model.getElementAt(i);
                if (!list.remove(item)) continue;
                indices.add(i);
            }
            if (indices.size() == 0) {
                return;
            }
            ListSelectionModel sm = this.getSelectionModel();
            sm.clearSelection();
            int size = this.getModel().getSize();
            for (int i = 0; i < indices.size(); ++i) {
                int idx = Integer.parseInt(indices.get(i) + "");
                if (idx >= size) continue;
                sm.addSelectionInterval(idx, idx);
            }
        } else {
            this.model.is_adjusting = false;
            this.setSelectedValue(value, true);
        }
    }

    private void updateBeanValueToNull() {
        String sname;
        String vstat = this.getVarStatus();
        if (vstat != null) {
            UIControlUtil.setBeanValue(this.getBinding(), vstat, null);
        }
        if ((sname = this.getName()) != null) {
            UIControlUtil.setBeanValue(this.getBinding(), sname, null);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XList.this.binding.notifyDepends(sname);
                }
            });
        }
    }

    @Override
    protected ListSelectionModel createSelectionModel() {
        return new ListSelectionModelImpl();
    }

    private boolean beforeSelectionIndex(int lead) {
        if (!this.isEnableNavigation()) {
            return false;
        }
        if (this.listPaneModel == null) {
            return true;
        }
        try {
            Object o;
            Object v0 = o = lead < 0 ? null : this.getModel().getElementAt(lead);
            if (!this.listPaneModel.beforeSelect(o)) {
                return false;
            }
        }
        catch (Throwable t) {
            MsgBox.err(t);
        }
        return true;
    }

    @Override
    public void setSelectionInterval(int anchor, int lead) {
        if (!this.beforeSelectionIndex(lead)) {
            return;
        }
        super.setSelectionInterval(anchor, lead);
    }

    private String getProperty(Map map, String name) {
        Object value = map == null ? null : (Object)map.get(name);
        return value == null ? null : value.toString();
    }

    private void executeRefreshTask(long interval) {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new RefreshTask(), interval, interval);
        }
    }

    private class RefreshTask
    extends TimerTask {
        XList root;

        private RefreshTask() {
            this.root = XList.this;
        }

        @Override
        public void run() {
            if (SwingUtilities.getRoot(this.root) != null) {
                this.root.refresh(true);
            }
        }
    }

    private class ProviderImpl
    implements ListPaneModel.Provider {
        XList root;

        private ProviderImpl() {
            this.root = XList.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public void repaint() {
            this.root.repaint();
        }

        @Override
        public void refresh() {
            this.root.refresh();
        }

        @Override
        public void reload() {
            this.root.refresh(true);
        }

        @Override
        public void setSelectedIndex(int index) {
            int size = this.root.getModel().getSize();
            if (index >= 0 && index < size) {
                this.root.setSelectedIndex(index);
            }
        }

        @Override
        public Object getItem(int index) {
            try {
                return this.root.getModel().getElementAt(index);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void addItem(Object item) throws Exception {
            if (item == null) {
                return;
            }
            if (this.root.listPaneModel != null) {
                if (!this.root.listPaneModel.isEditable()) {
                    return;
                }
                if (!this.root.listPaneModel.isAllowAdd()) {
                    return;
                }
            }
            this.root.model.addElement(item);
        }

        @Override
        public void removeSelectedItem() {
            if (this.root.listPaneModel == null) {
                return;
            }
            if (!this.root.listPaneModel.isEditable()) {
                return;
            }
            if (!this.root.listPaneModel.isAllowRemove()) {
                return;
            }
            int size = this.root.model.getSize();
            int selindex = this.root.getSelectedIndex();
            if (selindex >= 0 && selindex < size && this.root.listPaneModel.removeItemIndex(selindex)) {
                this.root.model.remove(selindex);
                size = this.root.model.getSize();
                if (size <= 0) {
                    this.root.updateBeanValueToNull();
                } else if (selindex >= size) {
                    this.root.setSelectedIndex(selindex - 1);
                } else {
                    this.root.setSelectedIndex(selindex);
                }
            }
        }
    }

    private class DefaultListModelImpl
    extends DefaultListModel {
        boolean is_adjusting;

        private DefaultListModelImpl() {
        }

        void fireItemAdded(int index0, int index1) {
            this.fireIntervalAdded(XList.this, index0, index1);
        }

        void fireItemRemoved(int index0, int index1) {
            this.fireIntervalRemoved(XList.this, index0, index1);
        }
    }

    private class DefaultListPaneModel
    extends ListPaneModel {
        private List list;

        DefaultListPaneModel(Object items) {
            if (items instanceof Object[]) {
                this.list = Arrays.asList((Object[])items);
            } else if (items instanceof List) {
                this.list = (List)items;
            }
        }

        @Override
        public List fetchList(Map params) {
            return this.list;
        }
    }

    public class ItemStatus {
        private Object value;
        private String name;
        private int index;
        private boolean multiSelect;

        public Object getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isMultiSelect() {
            return this.multiSelect;
        }
    }

    private class ListSelectionSupport
    implements ListSelectionListener {
        XList root;
        List<ListSelectionListener> listeners;

        private ListSelectionSupport() {
            this.root = XList.this;
            this.listeners = new ArrayList<ListSelectionListener>();
        }

        void remove(ListSelectionListener listener) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }

        void add(ListSelectionListener listener) {
            if (listener != null) {
                this.listeners.remove(listener);
                this.listeners.add(listener);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (((XList)this.root).model.is_adjusting) {
                return;
            }
            try {
                final Binding binding = this.root.getBinding();
                int selIndex = this.root.getSelectedIndex();
                if (selIndex != -1 && !evt.getValueIsAdjusting()) {
                    boolean beanValueChanged;
                    Object oldValue = UIControlUtil.getBeanValue(binding, this.root.getName());
                    final Object newValue = this.root.isMultiselect() ? this.root.getSelectedValues() : this.root.getSelectedValue();
                    boolean bl = beanValueChanged = !ValueUtil.isEqual((Object)oldValue, (Object)newValue);
                    if (beanValueChanged) {
                        UIControlUtil.setBeanValue(binding, this.root.getName(), newValue);
                        if (this.root.getVarStatus() != null) {
                            ItemStatus stat = new ItemStatus();
                            stat.multiSelect = this.root.isMultiselect();
                            stat.index = this.root.getSelectedIndex();
                            stat.name = this.root.getName();
                            stat.value = newValue;
                            UIControlUtil.setBeanValue(this.root.getBinding(), this.root.getVarStatus(), (Object)stat);
                        }
                        binding.getValueChangeSupport().notify(this.root.getName(), newValue);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (ListSelectionSupport.this.root.listPaneModel == null) {
                                    return;
                                }
                                ListSelectionSupport.this.root.listPaneModel.onselect(newValue);
                            }
                            catch (Throwable e) {
                                System.out.println("[WARN] error onselect caused by " + e.getMessage());
                            }
                        }
                    });
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            binding.notifyDepends(XList.this);
                        }
                    });
                }
                this.notifyListeners(evt);
            }
            catch (Throwable ex) {
                MsgBox.err(ex);
            }
        }

        private void notifyListeners(ListSelectionEvent evt) {
            for (ListSelectionListener listener : this.listeners) {
                listener.valueChanged(evt);
            }
        }
    }

    private class DefaultCellRenderer
    implements ListCellRenderer {
        XList root;
        private JPanel panel;
        private JLabel cellLabel;
        private JLabel cellLabelR;
        private FontSupport fontSupport;
        private HashMap itemObject;

        DefaultCellRenderer() {
            this.root = XList.this;
            this.panel = new JPanel(new BorderLayout());
            this.panel.setOpaque(true);
            this.cellLabel = new JLabel();
            this.cellLabel.setOpaque(false);
            this.cellLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.panel.add(this.cellLabel);
            this.cellLabelR = new JLabel();
            this.cellLabelR.setOpaque(false);
            this.panel.add((Component)this.cellLabelR, "East");
            this.fontSupport = new FontSupport();
            this.itemObject = new HashMap();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Insets pads = this.root.getPadding();
            if (pads == null) {
                pads = new Insets(1, 3, 1, 3);
            }
            this.panel.setBorder(BorderFactory.createEmptyBorder(pads.top, pads.left, pads.bottom, pads.right));
            this.panel.setSize(list.getFixedCellWidth(), list.getFixedCellHeight());
            this.panel.setEnabled(list.isEnabled());
            this.panel.setFont(list.getFont());
            this.cellLabel.setFont(list.getFont());
            this.cellLabelR.setFont(list.getFont());
            this.cellLabel.setVerticalAlignment(XList.this.getCellVerticalAlignment());
            this.cellLabel.setHorizontalAlignment(XList.this.getCellHorizontalAlignment());
            this.cellLabel.setVerticalTextPosition(XList.this.getCellVerticalTextPosition());
            this.cellLabel.setHorizontalTextPosition(XList.this.getCellHorizontalTextPosition());
            if (this.panel.isEnabled()) {
                this.panel.setEnabled(this.root.isEnableNavigation());
            }
            if (isSelected) {
                this.panel.setBackground(list.getSelectionBackground());
                this.panel.setForeground(list.getSelectionForeground());
                this.cellLabel.setForeground(list.getSelectionForeground());
                this.cellLabelR.setForeground(list.getSelectionForeground());
                this.fontSupport.applyStyles((JComponent)this.cellLabel, "font-weight:bold;");
            } else {
                this.panel.setBackground(list.getBackground());
                this.panel.setForeground(list.getForeground());
                this.cellLabel.setForeground(list.getForeground());
                this.cellLabelR.setForeground(list.getForeground());
            }
            if (Beans.isDesignTime()) {
                this.cellLabel.setText(value + "");
                return this.cellLabel;
            }
            Object statusText = null;
            Object cellValue = value;
            String expr = XList.this.getExpression();
            if (expr != null) {
                try {
                    Object exprBean = this.createExpressionBean(value);
                    cellValue = UIControlUtil.evaluateExpr(exprBean, expr);
                }
                catch (Throwable exprBean) {
                    // empty catch block
                }
            }
            if (this.root.listPaneModel != null) {
                this.itemObject.put("index", index);
                this.itemObject.put("selected", isSelected);
                this.itemObject.put("data", value);
                Object txt = this.root.listPaneModel.buildDisplayText(this.itemObject);
                if (txt != null) {
                    cellValue = txt;
                }
                if ((txt = this.root.listPaneModel.buildStatusText(this.itemObject)) != null) {
                    statusText = txt;
                }
            }
            this.cellLabel.setText(cellValue == null ? "" : cellValue.toString());
            this.cellLabelR.setText(statusText == null ? "" : statusText.toString());
            String strIcon = new MapObject(value).getString("icon");
            if (strIcon == null || strIcon.length() == 0) {
                String string = strIcon = this.root.listPaneModel == null ? null : this.root.listPaneModel.getDefaultIcon();
            }
            if (strIcon != null && strIcon.length() > 0) {
                Icon anIcon = ImageIconSupport.getInstance().getIcon(strIcon);
                if (anIcon == null) {
                    try {
                        anIcon = UIManager.getLookAndFeelDefaults().getIcon(strIcon);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.cellLabel.setIcon(anIcon);
            }
            return this.panel;
        }

        private Object createExpressionBean(Object itemBean) {
            ExprBeanSupport beanSupport = new ExprBeanSupport(XList.this.binding.getBean());
            beanSupport.setItem(XList.this.getVarName(), itemBean);
            return beanSupport.createProxy();
        }
    }

    public class ItemStat {
        public int index;
        public boolean selected;
        public Object data;
    }

    private class ListSelectionModelImpl
    extends DefaultListSelectionModel {
        XList root;

        private ListSelectionModelImpl() {
            this.root = XList.this;
        }

        @Override
        public void moveLeadSelectionIndex(int leadIndex) {
            if (!this.root.beforeSelectionIndex(leadIndex)) {
                return;
            }
            super.moveLeadSelectionIndex(leadIndex);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (index0 == 0 && index1 == 0 && this.root.getSelectedIndex() < 0) {
                super.setSelectionInterval(index0, index1);
            } else {
                if (!this.root.beforeSelectionIndex(index1)) {
                    return;
                }
                super.setSelectionInterval(index0, index1);
            }
        }
    }
}

