/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.DocViewModel;
import com.rameses.rcp.common.HtmlViewModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.Task;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.swing.HtmlViewPane;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UICommandUtil;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.Beans;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.text.html.HTMLDocument;

public class XHtmlView
extends HtmlViewPane
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private ControlProperty controlProperty;
    private Binding binding;
    private String[] depends;
    private int index;
    private DocViewModel docModel;
    private String visibleWhen;
    private int stretchWidth;
    private int stretchHeight;
    private String handler;
    private boolean dynamic;
    private JPopupMenu popup;

    public XHtmlView() {
        if (Beans.isDesignTime()) {
            return;
        }
        new MouseEventSupport(this).install();
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        block19: {
            block18: {
                DocViewModel newModel = null;
                try {
                    String csstext;
                    Object value = UIControlUtil.getBeanValue(this);
                    if (value instanceof DocViewModel) {
                        newModel = (DocViewModel)value;
                        value = newModel.getValue();
                    }
                    if (newModel instanceof HtmlViewModel && (csstext = ((HtmlViewModel)newModel).getStyles()) != null && csstext.trim().length() > 0) {
                        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(csstext);
                    }
                    URL url = null;
                    if (value == null) {
                        this.setText("");
                        this.setCaretPosition(0);
                    } else if (value instanceof URL) {
                        url = (URL)value;
                    } else if (value.toString().startsWith("http://")) {
                        url = new URL(value.toString());
                    } else {
                        this.setText(value.toString());
                        this.setCaretPosition(0);
                    }
                    if (this.docModel != null) {
                        this.docModel.setProvider(null);
                    }
                    this.docModel = newModel;
                    if (this.docModel != null) {
                        newModel.setProvider(new ViewProviderImpl());
                    }
                    if (url != null) {
                        URLWorkerTask uwt = new URLWorkerTask(url);
                        ClientContext.getCurrentContext().getTaskManager().addTask(uwt);
                    }
                }
                catch (Throwable t) {
                    this.setText("");
                    if (newModel != null) {
                        newModel.setProvider(null);
                    }
                    System.out.println("[WARN] refresh failed caused by " + t.getMessage());
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block18;
                    t.printStackTrace();
                }
            }
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.length() <= 0) break block19;
                Object bean = this.getBinding().getBean();
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean(bean, visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public Map getInfo() {
        return null;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.controlProperty == null) {
            this.controlProperty = new ControlProperty();
        }
        return this.controlProperty;
    }

    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    protected void processAction(String name, Map params) {
        if (name == null || name.length() == 0) {
            return;
        }
        Object outcome = null;
        try {
            MethodResolver mresolver = MethodResolver.getInstance();
            outcome = mresolver.invoke(this.getBinding().getBean(), name, new Object[]{params});
        }
        catch (Throwable t) {
            System.out.println("[WARN] error invoking method '" + name + "' caused by " + t.getMessage());
        }
        if (outcome instanceof Opener) {
            if (outcome instanceof PopupMenuOpener) {
                final PopupMenuOpener menu = (PopupMenuOpener)outcome;
                List items = menu.getItems();
                if (items == null || items.isEmpty()) {
                    return;
                }
                if (items.size() == 1 && menu.isExecuteOnSingleResult()) {
                    Object o = menu.getFirst();
                    if (o instanceof Opener) {
                        this.getBinding().fireNavigation((Opener)o);
                    } else {
                        ((Action)o).execute();
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            XHtmlView.this.show(menu);
                        }
                    });
                }
            } else {
                this.getBinding().fireNavigation((Opener)outcome);
            }
        }
    }

    protected void show(PopupMenuOpener menu) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        } else {
            this.popup.setVisible(false);
        }
        this.popup.removeAll();
        for (Object o : menu.getItems()) {
            ActionMenuItem ami = null;
            ami = o instanceof Opener ? new ActionMenuItem((Opener)o) : new ActionMenuItem((Action)o);
            Dimension dim = ami.getPreferredSize();
            ami.setPreferredSize(new Dimension(Math.max(dim.width, 100), dim.height));
            this.popup.add(ami);
        }
        this.popup.pack();
        Point mousePoint = this.getMousePoint();
        Rectangle rect = this.getBounds();
        int x = rect.x + (mousePoint == null ? 0 : mousePoint.x);
        int y = rect.y + (mousePoint == null ? 0 : mousePoint.y);
        this.popup.show(this, x, y);
        this.popup.requestFocus();
        mousePoint = null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getParent().addComponentListener(new ComponentAdapterImpl());
    }

    private class ComponentAdapterImpl
    extends ComponentAdapter {
        XHtmlView root;

        private ComponentAdapterImpl() {
            this.root = XHtmlView.this;
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            if (this.root.docModel != null) {
                int w = ce.getComponent().getWidth();
                int h = ce.getComponent().getHeight();
                DocViewModel.ResizeEvent re = new DocViewModel.ResizeEvent(w, h);
                XHtmlView.this.docModel.onresize(re);
            }
        }
    }

    private class ActionMenuItem
    extends JMenuItem {
        XHtmlView root;
        private Object source;

        ActionMenuItem(Opener anOpener) {
            this.root = XHtmlView.this;
            this.source = anOpener;
            this.setText(anOpener.getCaption());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeOpener(e);
                }
            });
            Object ov = anOpener.getProperties().get("mnemonic");
            if (ov != null && ov.toString().trim().length() > 0) {
                this.setMnemonic(ov.toString().trim().charAt(0));
            }
            if ((ov = anOpener.getProperties().get("icon")) != null && ov.toString().length() > 0) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(ov.toString()));
            }
        }

        ActionMenuItem(Action anAction) {
            this.root = XHtmlView.this;
            this.source = anAction;
            this.setText(anAction.getCaption());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeAction(e);
                }
            });
            this.setMnemonic(anAction.getMnemonic());
            String sicon = anAction.getIcon();
            if (sicon != null && sicon.length() > 0) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(sicon));
            }
        }

        void invokeOpener(ActionEvent e) {
            try {
                UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), (Opener)this.source);
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        void invokeAction(ActionEvent e) {
            try {
                Object outcome = ((Action)this.source).execute();
                if (outcome instanceof Opener) {
                    UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), (Opener)outcome);
                }
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }
    }

    private class URLWorkerTask
    extends Task {
        XHtmlView root;
        private URL url;
        private boolean done;

        URLWorkerTask(URL url) {
            this.root = XHtmlView.this;
            this.url = url;
        }

        @Override
        public boolean accept() {
            return !this.done;
        }

        @Override
        public void execute() {
            try {
                this.root.setText("<html><body><b>Loading...</b></body></html>");
                if (this.url != null) {
                    this.root.setPage(this.url);
                }
                this.root.setCaretPosition(0);
            }
            catch (Throwable t) {
                this.root.setText("<html><body color=\"red\">error caused by " + t.getMessage() + "</body></html>");
                if (ClientContext.getCurrentContext().isDebugMode()) {
                    t.printStackTrace();
                }
            }
            finally {
                this.done = true;
            }
        }
    }

    private class ViewProviderImpl
    implements HtmlViewModel.ViewProvider {
        XHtmlView root;

        private ViewProviderImpl() {
            this.root = XHtmlView.this;
        }

        @Override
        public void insertText(String text) {
        }

        @Override
        public void appendText(String text) {
        }

        @Override
        public String getText() {
            return this.root.getText();
        }

        @Override
        public void setText(String text) {
        }

        @Override
        public void load() {
        }

        @Override
        public void refresh() {
            this.root.refresh();
        }

        @Override
        public void requestFocus() {
            if (!this.root.isEnabled()) {
                return;
            }
            this.root.grabFocus();
            this.root.requestFocusInWindow();
        }

        public Object invokeJS(String text) {
            return null;
        }

        @Override
        public int getWidth() {
            Container con = this.root.getParent();
            if (con instanceof JViewport) {
                return con.getWidth();
            }
            return this.root.getWidth();
        }

        @Override
        public int getHeight() {
            Container con = this.root.getParent();
            if (con instanceof JViewport) {
                return con.getHeight();
            }
            return this.root.getHeight();
        }
    }
}

