/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.HtmlEditorModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.HtmlEditorPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import java.awt.Font;
import java.awt.Insets;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.html.HTMLDocument;

public class XHtmlEditor
extends HtmlEditorPanel
implements UIInput,
ActiveControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private boolean nullWhenEmpty;
    private boolean immediate;
    private HtmlEditorModel model;
    private ControlProperty controlProperty;
    private String visibleWhen;
    private String handler;
    private String varName;
    private String itemExpression;
    private int stretchWidth;
    private int stretchHeight;

    public XHtmlEditor() {
        this.initComponent();
    }

    private void initComponent() {
        this.nullWhenEmpty = true;
        this.varName = "item";
        try {
            HTMLDocument doc = this.getDocument();
            ClassLoader cloader = ClientContext.getCurrentContext().getClassLoader();
            URL url = cloader.getResource("images");
            if (url != null) {
                doc.setBase(url);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getItemExpression() {
        return this.itemExpression;
    }

    public void setItemExpression(String itemExpression) {
        this.itemExpression = itemExpression;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void load() {
        this.setEditorInputVerifier(UIInputUtil.VERIFIER);
        this.setEditorClientProperty(UIInput.class, this);
        Object bean = this.getBinding().getBean();
        Object ohandler = UIControlUtil.getBeanValue(bean, this.getHandler());
        this.model = ohandler instanceof HtmlEditorModel ? (HtmlEditorModel)ohandler : new HtmlEditorModelImpl();
    }

    @Override
    public void refresh() {
        block7: {
            block6: {
                try {
                    this.setValue(UIControlUtil.getBeanValue(this));
                }
                catch (Throwable t) {
                    this.setText("");
                    System.out.println("[WARN] refresh failed caused by " + t.getMessage());
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block6;
                    t.printStackTrace();
                }
            }
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.length() <= 0) break block7;
                Object bean = this.getBinding().getBean();
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean(bean, visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public Map getInfo() {
        return null;
    }

    @Override
    public Object getValue() {
        Object value = super.getValue();
        if (value == null) {
            return null;
        }
        String str = value == null ? null : value.toString();
        int idx0 = str.indexOf("<body>");
        if (idx0 < 0) {
            return str;
        }
        int idx1 = str.indexOf("</body>", idx0);
        if (idx1 < 0) {
            return str;
        }
        return str.substring(idx0 + 7, idx1);
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public boolean isReadonly() {
        return !this.isEditable();
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.setEditable(!readonly);
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        super.setRequestFocus(focus);
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.controlProperty == null) {
            this.controlProperty = new ControlProperty();
        }
        return this.controlProperty;
    }

    public boolean isRequired() {
        return this.getControlProperty().isRequired();
    }

    public void setRequired(boolean required) {
        this.getControlProperty().setRequired(required);
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private Object createExpressionBean(Object itemBean) {
        Object bean = this.getBinding().getBean();
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    @Override
    protected Object getFormattedText(Object item) {
        String expression = this.getItemExpression();
        if (expression == null || expression.length() == 0) {
            return item.toString();
        }
        Object exprBean = this.createExpressionBean(item);
        return UIControlUtil.evaluateExpr(exprBean, expression);
    }

    @Override
    protected List fetchList(Map params) {
        return this.model == null ? null : this.model.fetchList(params);
    }

    private Map createMap(Object key, Object value) {
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put(key, value);
        return data;
    }

    @Override
    protected String getTemplate(Object item) {
        Object o = this.model == null ? null : this.model.getTemplate(item);
        return o == null ? null : o.toString();
    }

    private class HtmlEditorModelImpl
    extends HtmlEditorModel {
        private HtmlEditorModelImpl() {
        }
    }
}

