/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.DocViewModel;
import com.rameses.rcp.common.FormulaEditorModel;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.editor.FormulaDocument;
import com.rameses.rcp.framework.ActionHandler;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;

public class XFormulaEditor
extends JTextPane
implements UIInput,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private Binding binding;
    private String[] depends;
    private int index;
    private String handler;
    private Object handlerObject;
    private String keywordItems;
    private boolean dynamic;
    private boolean readonly;
    private boolean nullWhenEmpty;
    private TrimSpaceOption trimSpaceOption = TrimSpaceOption.NONE;
    private ActionHandlerImpl actionHandler = new ActionHandlerImpl();
    private List<String> keywords;
    private FormulaDocument document;
    private FormulaEditorModel model;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;
    private String disableWhen;
    private ControlProperty property;

    public XFormulaEditor() {
        super.setDocument(this.getFormulaDocument());
        new MouseEventSupport(this).install();
    }

    @Override
    public final void setDocument(Document doc) {
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.setText(name);
        }
    }

    private FormulaDocument getFormulaDocument() {
        if (this.document == null) {
            this.document = new FormulaDocument();
        }
        return this.document;
    }

    public List<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        return this.keywords;
    }

    public FormulaEditorModel getModel() {
        return this.model;
    }

    public void setModel(FormulaEditorModel model) {
        this.model = model;
    }

    public String getKeywordItems() {
        return this.keywordItems;
    }

    public void setKeywordItems(String varItems) {
        this.keywordItems = varItems;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption trimSpaceOption) {
        this.trimSpaceOption = trimSpaceOption;
    }

    public TextCase getTextCase() {
        return this.getFormulaDocument().getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        this.getFormulaDocument().setTextCase(textCase);
    }

    public void setTextCase(String sTextCase) {
        this.getFormulaDocument().setTextCaseAsString(sTextCase);
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        if (this.binding != null) {
            this.binding.getActionHandlerSupport().remove(this.actionHandler);
        }
        this.binding = binding;
        if (binding != null) {
            binding.getActionHandlerSupport().add(this.actionHandler);
        }
    }

    @Override
    public void load() {
        Object value;
        block6: {
            value = this.getHandlerObject();
            if (!ValueUtil.isEmpty((Object)this.getHandler())) {
                try {
                    value = UIControlUtil.getBeanValue(this, this.getHandler());
                }
                catch (Exception ex) {
                    if (!ClientContext.getCurrentContext().isDebugMode()) break block6;
                    ex.printStackTrace();
                }
            }
        }
        if (value instanceof FormulaEditorModel) {
            this.model = (FormulaEditorModel)value;
            this.model.setProvider(new DocumentProvider());
        } else {
            this.model = null;
        }
        if (!this.isDynamic()) {
            this.loadVariables();
        }
        this.setInputVerifier(UIInputUtil.VERIFIER);
    }

    @Override
    public void refresh() {
        int oldCaretPos;
        block11: {
            Binding binding = this.getBinding();
            String whenExpr = this.getVisibleWhen();
            if (whenExpr != null && whenExpr.length() > 0) {
                boolean result = false;
                try {
                    result = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(result);
            }
            if ((whenExpr = this.getDisableWhen()) != null && whenExpr.length() > 0) {
                boolean disabled = false;
                try {
                    disabled = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setEnabled(!disabled);
            }
            if (this.dynamic) {
                this.loadVariables();
            }
            oldCaretPos = this.getCaretPosition();
            try {
                Object value = UIControlUtil.getBeanValue(this);
                this.getFormulaDocument().setValue(value, this.getInputAttributes().copyAttributes());
            }
            catch (Exception e) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block11;
                e.printStackTrace();
            }
        }
        try {
            this.setCaretPosition(oldCaretPos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public Object getValue() {
        String text = this.getText();
        if (ValueUtil.isEmpty((Object)text)) {
            return this.isNullWhenEmpty() ? null : text;
        }
        if (this.getTrimSpaceOption() != null) {
            return this.getTrimSpaceOption().trim(text);
        }
        return text;
    }

    @Override
    public void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.setEditable(!readonly);
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dynamic", this.isDynamic());
        map.put("handler", this.getHandler());
        map.put("handlerObject", this.getHandlerObject());
        map.put("keywordItems", this.getKeywordItems());
        map.put("nullWhenEmpty", this.isNullWhenEmpty());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    private void loadVariables() {
        List<String> items;
        ArrayList<String> list;
        block11: {
            list = new ArrayList<String>();
            List<String> keywords = this.getKeywords();
            if (keywords != null && !keywords.isEmpty()) {
                list.addAll(keywords);
            }
            try {
                Object value = null;
                String sname = this.getKeywordItems();
                if (sname != null) {
                    value = UIControlUtil.getBeanValue(this, sname);
                }
                if (value != null) {
                    if (value instanceof Collection) {
                        for (Object o : (Collection)value) {
                            list.add(o + "");
                        }
                    } else if (value.getClass().isArray()) {
                        for (Object o : (Object[])value) {
                            list.add(o + "");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block11;
                e.printStackTrace();
            }
        }
        this.document.getKeywords().clear();
        this.document.getKeywords().addAll(list);
        if (this.model != null && (items = this.model.getKeywords()) != null) {
            this.document.getKeywords().addAll(items);
        }
    }

    private class ActionHandlerImpl
    implements ActionHandler {
        XFormulaEditor root;

        private ActionHandlerImpl() {
            this.root = XFormulaEditor.this;
        }

        @Override
        public void onBeforeExecute() {
        }

        @Override
        public void onAfterExecute() {
            if (!XFormulaEditor.this.document.isDirty()) {
                return;
            }
            UIInputUtil.updateBeanValue(this.root);
        }
    }

    private class DocumentProvider
    implements DocViewModel.Provider {
        private XFormulaEditor root;

        private DocumentProvider() {
            this.root = XFormulaEditor.this;
        }

        @Override
        public String getText() {
            return this.root.getText();
        }

        @Override
        public void setText(String text) {
            this.root.setText(text == null ? "" : text);
            this.root.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertText(String text) {
            if (text == null) {
                return;
            }
            int caretPos = this.root.getCaretPosition();
            try {
                int caretCharPos;
                int n = caretCharPos = text == null ? -1 : text.indexOf(124);
                if (caretCharPos >= 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(text.substring(0, caretCharPos));
                    sb.append(' ');
                    sb.append(text.substring(caretCharPos + 1));
                    text = sb.toString();
                }
                AttributeSet attr = this.root.getInputAttributes().copyAttributes();
                this.root.document.insertString(caretPos, text, attr);
                if (caretCharPos >= 0) {
                    this.root.setCaretPosition(caretPos + caretCharPos);
                }
            }
            catch (Exception ex) {
                System.out.println("[XFormulaEditor] failed to insert text at position " + caretPos + " caused by " + ex.getMessage());
            }
            finally {
                this.repaint();
            }
        }

        @Override
        public void appendText(String text) {
        }

        @Override
        public void requestFocus() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentProvider.this.root.requestFocus();
                    DocumentProvider.this.root.grabFocus();
                }
            });
        }

        @Override
        public void load() {
            this.root.load();
        }

        @Override
        public void refresh() {
            this.root.refresh();
        }

        private void repaint() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentProvider.this.root.repaint();
                }
            });
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }
    }
}

