/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.FormControl;
import com.rameses.rcp.common.FormPanelModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.PropertyChangeSupport;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.ValidatorEvent;
import com.rameses.rcp.constant.UIConstants;
import com.rameses.rcp.control.FormControlUtil;
import com.rameses.rcp.control.FormItemPanel;
import com.rameses.rcp.control.FormItemProperty;
import com.rameses.rcp.control.FormPanelProperty;
import com.rameses.rcp.control.ItemPanel;
import com.rameses.rcp.control.XEditorPane;
import com.rameses.rcp.control.XLabel;
import com.rameses.rcp.control.border.XLineBorder;
import com.rameses.rcp.control.border.XUnderlineBorder;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.BindingListener;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlContainer;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIComposite;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.UIFocusableContainer;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.UILookup;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class XFormPanel
extends JPanel
implements FormPanelProperty,
UIComposite,
ControlContainer,
Validatable,
ActiveControl,
UIConstants,
MouseEventSupport.ComponentInfo {
    private int cellspacing = 2;
    private Insets cellpadding = new Insets(0, 0, 0, 0);
    private String orientation = "VERTICAL";
    private String visibleWhen;
    private Insets padding;
    private int captionWidth = 80;
    private String captionVAlignment = "TOP";
    private String captionHAlignment = "LEFT";
    private String captionOrientation = "LEFT";
    private String captionFontStyle;
    private Font captionFont;
    private Color captionForeground;
    private Border captionBorder = new XUnderlineBorder();
    private Insets captionPadding = new Insets(0, 1, 0, 5);
    private boolean addCaptionColon = true;
    private boolean showCategory;
    private Binding binding;
    private String[] depends;
    private int index;
    private List<UIControl> controls = new ArrayList<UIControl>();
    private boolean dynamic;
    private ControlProperty property = new ControlProperty();
    private ActionMessage actionMessage = new ActionMessage();
    private PropertyChangeSupport propertySupport;
    private List<UIControl> nonDynamicControls = new ArrayList<UIControl>();
    private boolean loaded;
    private boolean reloaded;
    private boolean dynamicControlsRemoved;
    private String viewType;
    private String oldViewType;
    private boolean viewTypeSet;
    private LayoutManager layout;
    private JEditorPane htmlPane;
    private String emptyWhen;
    private String emptyText;
    private XLabel emptyLbl;
    private FormPanelModel model;
    private FormPanelModel.Listener defaultListener;
    private JLabel lblFont = new JLabel();
    private int stretchWidth;
    private int stretchHeight;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private InnerBorder innerBorder;

    public XFormPanel() {
        this.initComponent();
    }

    private void initComponent() {
        this.propertySupport = new PropertyChangeSupport();
        this.layout = new Layout();
        super.setLayout(this.layout);
        this.setPadding(new Insets(0, 5, 5, 5));
        this.setOpaque(false);
        new MouseEventSupport(this).install();
        this.setCaptionForeground(new Color(60, 60, 60));
        this.setBorder(this.getInnerBorder());
        Color color = new Color(180, 180, 180);
        Insets padding = new Insets(2, 0, 0, 0);
        this.captionBorder = new XLineBorder(color, 1, padding, true, true, false, true);
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    @Override
    public PropertyChangeSupport getPropertySupport() {
        return this.propertySupport;
    }

    private FormItemPanel getLastItem() {
        int index = super.getComponentCount() - 1;
        if (index < 0) {
            return null;
        }
        Component c = super.getComponent(index);
        if (c instanceof FormItemPanel) {
            return (FormItemPanel)c;
        }
        return null;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof FormItemPanel) {
            super.addImpl(comp, constraints, index);
            return;
        }
        ItemPanel p = null;
        Component control = comp;
        if (comp instanceof ActiveControl) {
            p = new ItemPanel(this, comp);
        } else if (comp instanceof JScrollPane && (control = ((JScrollPane)comp).getViewport().getView()) instanceof ActiveControl) {
            p = new ItemPanel(this, control, comp);
        }
        if (p != null) {
            FormItemPanel form;
            if (!this.loaded && control instanceof UIControl) {
                this.nonDynamicControls.add((UIControl)((Object)control));
            }
            if ((form = this.getLastItem()) == null) {
                super.addImpl(p, constraints, index);
            } else {
                form.add(p);
            }
        }
    }

    @Override
    public void remove(Component comp) {
        if (comp == null) {
            return;
        }
        Container parent = comp.getParent();
        if (parent == null) {
            return;
        }
        if (parent == this) {
            super.remove(comp);
        } else if (parent instanceof ItemPanel) {
            Container ipc = parent.getParent();
            ipc.remove(parent);
        }
    }

    private int indexOf(Component comp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ItemPanel p;
            Component c = this.getComponent(i);
            if (c == comp) {
                return i;
            }
            if (!(c instanceof ItemPanel) || (p = (ItemPanel)c).getEditorComponent() != comp) continue;
            return i;
        }
        return -1;
    }

    private Component resolveComponent(Component comp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (c == comp) {
                return comp;
            }
            if (!(c instanceof FormItemPanel)) continue;
            Component[] ficomps = ((FormItemPanel)c).getComponents();
            for (int ii = 0; ii < ficomps.length; ++ii) {
                Component cc = ficomps[ii];
                if (cc == comp) {
                    return cc;
                }
                if (!(cc instanceof ItemPanel)) continue;
                ItemPanel ipc = (ItemPanel)cc;
                if (ipc.getEditorComponent() == cc) {
                    return ipc;
                }
                if (ipc.getEditorWrapper() != cc) continue;
                return ipc;
            }
        }
        return null;
    }

    @Override
    public boolean isShowCategory() {
        return this.showCategory;
    }

    public void setShowCategory(boolean showCategory) {
        this.showCategory = showCategory;
        this.propertySupport.firePropertyChange("showCategory", showCategory);
    }

    @Override
    public List<? extends UIControl> getControls() {
        return this.controls;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void validateInput() {
        this.validateInput(this.actionMessage);
    }

    public void validateInput(ActionMessage am) {
        am.clearMessages();
        if (ValueUtil.isEqual((Object)this.viewType, (Object)"html")) {
            return;
        }
        for (UIControl c : this.controls) {
            if (!(c instanceof Validatable)) continue;
            Validatable v = (Validatable)((Object)c);
            UIControlUtil.validate(v, am);
        }
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public void requestFocus() {
        this.focusFirstInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean focusFirstInput() {
        ArrayList<UIControl> allControls = new ArrayList<UIControl>();
        if (!this.nonDynamicControls.isEmpty()) {
            allControls.addAll(this.nonDynamicControls);
        }
        allControls.addAll(this.controls);
        try {
            for (UIControl c : allControls) {
                if (this.actionMessage.hasMessages()) {
                    if (!(c instanceof Validatable)) continue;
                    Validatable v = (Validatable)((Object)c);
                    v.validateInput();
                    if (!v.getActionMessage().hasMessages()) continue;
                    ((Component)((Object)v)).requestFocus();
                    boolean bl = true;
                    return bl;
                }
                if (c instanceof UIFocusableContainer) {
                    UIFocusableContainer uis = (UIFocusableContainer)c;
                    if (!uis.focusFirstInput()) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!(c instanceof UIInput)) continue;
                UIInput u = (UIInput)c;
                JComponent jc = (JComponent)((Object)c);
                if (!jc.isEnabled() || !jc.isFocusable()) continue;
                jc.requestFocus();
                jc.requestFocusInWindow();
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            allControls = null;
        }
        return false;
    }

    @Override
    public boolean isHasNonDynamicContents() {
        return !this.nonDynamicControls.isEmpty();
    }

    @Override
    public UIControl find(String name) {
        for (UIControl uic : this.controls) {
            if (!ValueUtil.isEqual((Object)name, (Object)uic.getName())) continue;
            return uic;
        }
        return null;
    }

    @Override
    public void refresh() {
        block8: {
            if (this.isDynamic()) {
                this.build();
            }
            if (this.reloaded || this.viewTypeSet && !ValueUtil.isEqual((Object)this.oldViewType, (Object)this.viewType)) {
                this.refreshForm();
                this.oldViewType = this.viewType;
                this.reloaded = false;
            } else if (ValueUtil.isEqual((Object)this.viewType, (Object)"html")) {
                this.refreshHtml();
            }
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.length() <= 0) break block8;
                Object bean = this.getBinding().getBean();
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean(bean, visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(b);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void load() {
        this.binding.addBindingListener(new FormPanelBindingListener());
        if (!this.isDynamic()) {
            this.build();
        }
        this.loaded = true;
        this.reloaded = true;
    }

    @Override
    public void reload() {
        this.build();
        this.reloaded = true;
    }

    @Override
    public Map getInfo() {
        return null;
    }

    private Component getClosestFormItemPanel(JComponent jc) {
        if (jc == null) {
            return null;
        }
        for (Container con = jc.getParent(); con != null; con = con.getParent()) {
            if (!(con instanceof FormItemPanel)) continue;
            return con;
        }
        return null;
    }

    private void build() {
        if (ValueUtil.isEmpty((Object)this.getName())) {
            return;
        }
        for (UIControl u : this.controls) {
            JComponent jc = (JComponent)((Object)u);
            Component c = this.getClosestFormItemPanel(jc);
            if (c == null) {
                this.remove(jc);
            } else {
                this.remove(c);
            }
            u = null;
        }
        this.controls.clear();
        this.property.setRequired(false);
        boolean htmlView = "html".equals(this.viewType);
        List list = this.getFormControls();
        FormControlUtil fcUtil = FormControlUtil.getInstance();
        EditorInputSupport inputSupport = new EditorInputSupport();
        for (FormControl fc : list) {
            UIControl uic = fcUtil.getControl(fc);
            if (uic == null) continue;
            if (fc instanceof FormControlMap) {
                FormControlMap fcm = (FormControlMap)fc;
                uic.putClientProperty("UIControl.userObject", fcm.getData());
            }
            uic.putClientProperty(UIInputUtil.Support.class, inputSupport);
            uic.setBinding(this.binding);
            uic.load();
            if (uic instanceof Validatable && ((Validatable)((Object)uic)).isRequired()) {
                this.property.setRequired(true);
            }
            if (uic instanceof JComponent) {
                ((JComponent)((Object)uic)).putClientProperty(FormControl.class, fc);
            }
            this.controls.add(uic);
        }
    }

    private void refreshForm() {
        boolean htmlView = "html".equals(this.viewType);
        if (!htmlView && this.htmlPane != null) {
            this.remove(this.htmlPane);
            this.htmlPane = null;
        }
        if (htmlView) {
            for (UIControl u : this.nonDynamicControls) {
                this.remove((Component)((Object)u));
            }
            this.dynamicControlsRemoved = true;
            for (UIControl u : this.controls) {
                this.remove((Component)((Object)u));
            }
            if (this.htmlPane == null) {
                this.initHtmlPane();
            }
        } else {
            super.setLayout(this.layout);
        }
        boolean empty = false;
        if (this.controls.size() == 0 && this.nonDynamicControls.size() == 0 && !ValueUtil.isEmpty((Object)this.emptyText)) {
            empty = true;
        } else if (!ValueUtil.isEmpty((Object)this.emptyWhen)) {
            try {
                empty = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), this.emptyWhen);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!empty) {
            if (this.emptyLbl != null) {
                this.remove(this.emptyLbl);
                this.emptyLbl = null;
            }
            if (htmlView) {
                FormControlUtil fcUtil = FormControlUtil.getInstance();
                this.htmlPane.setText(fcUtil.renderHtml(this.getAllControls(), this));
            } else {
                super.setLayout(this.layout);
                if (this.dynamicControlsRemoved) {
                    for (UIControl u : this.nonDynamicControls) {
                        this.add((Component)((Object)u));
                        u.refresh();
                    }
                    this.dynamicControlsRemoved = false;
                }
                FormItemPanel formItemPanel = null;
                WeakHashMap categories = new WeakHashMap();
                for (UIControl u : this.controls) {
                    if (this.reloaded && u instanceof JComponent) {
                        JComponent jc = (JComponent)((Object)u);
                        if (this.model != null && this.isShowCategory()) {
                            String s;
                            String fiCaption;
                            String oldCategoryid;
                            FormControl fc = (FormControl)jc.getClientProperty(FormControl.class);
                            String newCategoryid = fc == null ? null : fc.getCategoryid();
                            String string = oldCategoryid = formItemPanel == null ? null : formItemPanel.getId();
                            if (formItemPanel == null || !(newCategoryid + "").equals(oldCategoryid + "")) {
                                formItemPanel = new FormItemPanel(newCategoryid);
                                formItemPanel.setFormPanelProperty(this);
                                this.add(formItemPanel);
                            }
                            if (((fiCaption = formItemPanel.getCaption()) == null || fiCaption.length() == 0) && (s = this.model.getCategory(newCategoryid)) != null) {
                                formItemPanel.setCaption(s);
                            }
                        }
                        this.add(jc);
                    }
                    u.refresh();
                }
                categories.clear();
            }
        } else if (htmlView) {
            Font f = this.getFont();
            StringBuffer sb = new StringBuffer().append("<html>").append("<head>").append("<style> body, td, div, span { ").append("  font-family: \"" + f.getFamily() + "\"; ").append("  font-size: " + f.getSize()).append("}</style>").append("</head>").append("<body>").append(this.emptyText == null ? "" : this.emptyText).append("</body>").append("</html>");
            this.htmlPane.setText(sb.toString());
            this.htmlPane.setCaretPosition(0);
        } else if (this.emptyText != null) {
            if (this.emptyLbl == null) {
                this.emptyLbl = new XLabel();
                this.emptyLbl.setShowCaption(false);
            }
            this.emptyLbl.setExpression(this.emptyText);
            this.add(this.emptyLbl);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void refreshHtml() {
        boolean empty = false;
        if (this.controls.size() == 0 && this.nonDynamicControls.size() == 0 && !ValueUtil.isEmpty((Object)this.emptyText)) {
            empty = true;
        } else if (!ValueUtil.isEmpty((Object)this.emptyWhen)) {
            Object result = UIControlUtil.evaluateExpr(this.binding.getBean(), this.emptyWhen);
            boolean bl = empty = !"false".equals(result + "");
        }
        if (!empty) {
            List<UIControl> allControls = this.getAllControls();
            for (UIControl c : allControls) {
                c.refresh();
            }
            FormControlUtil fcUtil = FormControlUtil.getInstance();
            this.htmlPane.setText(fcUtil.renderHtml(allControls, this));
            this.htmlPane.setCaretPosition(0);
        } else {
            Font f = this.getFont();
            String html = "<font face='" + f.getFamily() + "' size='" + f.getSize() + "pt'>" + (this.emptyText == null ? "" : this.emptyText) + "</font>";
            this.htmlPane.setText(html);
        }
    }

    private void initHtmlPane() {
        XEditorPane editorPane = new XEditorPane();
        editorPane.setBinding(this.binding);
        super.setLayout(new BorderLayout());
        super.addImpl(editorPane, null, 0);
        this.htmlPane = editorPane;
    }

    private List getFormControls() {
        FormPanelModel oldModel;
        List<Map> value = null;
        try {
            value = UIControlUtil.getBeanValue(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FormPanelModel formModel = null;
        if (value instanceof FormPanelModel) {
            formModel = (FormPanelModel)((Object)value);
        } else {
            DefaultFormPanelModel dpm = new DefaultFormPanelModel();
            dpm.setValue(value);
            formModel = dpm;
        }
        if (this.defaultListener == null) {
            this.defaultListener = new ModelListener();
        }
        if ((value = formModel.getFormControls()) == null) {
            value = formModel.getControlList();
        }
        ArrayList<FormControl> list = new ArrayList<FormControl>();
        if (value != null) {
            if (value.getClass().isArray()) {
                for (Object o : (Object[])value) {
                    if (o == null) continue;
                    list.add(this.toFormControl(o));
                }
            } else if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    if (o == null) continue;
                    list.add(this.toFormControl(o));
                }
            }
        }
        if ((oldModel = this.model) != null) {
            oldModel.setListener(null);
            oldModel.setProvider(null);
        }
        formModel.setListener(this.defaultListener);
        formModel.setProvider(new ModelProviderSupport());
        this.model = formModel;
        return list;
    }

    private FormControl toFormControl(Object value) {
        if (value instanceof FormControl) {
            return (FormControl)value;
        }
        if (value instanceof Map) {
            return new FormControlMap((Map)value);
        }
        throw new IllegalStateException("The form controls must be an instance of FormControl or Map");
    }

    private String lookupAlignment(String alignment, String defaultvalue, boolean vertical) {
        if (vertical) {
            String str = (alignment == null ? defaultvalue : alignment).toLowerCase();
            if (str.equals("top")) {
                return "TOP";
            }
            if (str.equals("bottom")) {
                return "BOTTOM";
            }
            return "CENTER";
        }
        String str = (alignment == null ? defaultvalue : alignment).toLowerCase();
        if (str.equals("right")) {
            return "RIGHT";
        }
        if (str.equals("center")) {
            return "CENTER";
        }
        return "LEFT";
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    @Override
    public int getCellspacing() {
        return this.cellspacing;
    }

    public void setCellspacing(int cellspacing) {
        this.cellspacing = cellspacing;
        this.propertySupport.firePropertyChange("cellSpacing", cellspacing);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public int getCaptionWidth() {
        return this.captionWidth;
    }

    public void setCaptionWidth(int captionWidth) {
        this.captionWidth = captionWidth;
        this.updateLabelComponent();
    }

    public String getCaptionVAlignment() {
        return this.captionVAlignment;
    }

    public void setCaptionVAlignment(String captionVAlignment) {
        this.captionVAlignment = this.lookupAlignment(captionVAlignment, "TOP", true);
        this.updateLabelComponent();
    }

    public String getCaptionHAlignment() {
        return this.captionHAlignment;
    }

    public void setCaptionHAlignment(String captionHAlignment) {
        this.captionHAlignment = this.lookupAlignment(captionHAlignment, "LEFT", false);
        this.updateLabelComponent();
    }

    public String getCaptionOrientation() {
        return this.captionOrientation;
    }

    public void setCaptionOrientation(String captionOrientation) {
        this.captionOrientation = captionOrientation == null ? "LEFT" : captionOrientation.toUpperCase();
        this.updateLabelComponent();
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation == null ? "VERTICAL" : orientation.toUpperCase();
    }

    public Insets getCaptionPadding() {
        return this.captionPadding;
    }

    public void setCaptionPadding(Insets captionPadding) {
        this.captionPadding = captionPadding;
        this.updateLabelComponent();
    }

    @Override
    public Insets getCellpadding() {
        return this.cellpadding;
    }

    public void setCellpadding(Insets cellpadding) {
        this.cellpadding = cellpadding == null ? new Insets(0, 0, 0, 0) : cellpadding;
        this.propertySupport.firePropertyChange("cellPadding", this.cellpadding);
    }

    public boolean isAddCaptionColon() {
        return this.addCaptionColon;
    }

    public void setAddCaptionColon(boolean addCaptionColon) {
        this.addCaptionColon = addCaptionColon;
        this.updateLabelComponent();
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    public Font getCaptionFont() {
        return this.captionFont;
    }

    public void setCaptionFont(Font captionFont) {
        this.captionFont = captionFont;
        if (captionFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getCaptionFontStyle());
            captionFont = this.getFontSupport().applyStyles(captionFont, attrs);
        } else {
            this.updateLabelsFont(captionFont);
        }
    }

    public String getCaptionFontStyle() {
        return this.captionFontStyle;
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.captionFontStyle = captionFontStyle;
        Font font = this.getCaptionFont();
        if (font == null) {
            font = super.getFont();
        }
        Map attrs = this.getFontSupport().createFontAttributes(this.getCaptionFontStyle());
        font = this.getFontSupport().applyStyles(font, attrs);
        this.updateLabelsFont(font);
    }

    private void updateLabelComponent() {
        for (Component c : this.getComponents()) {
            if (!(c instanceof ItemPanel)) continue;
            ItemPanel ip = (ItemPanel)c;
            ip.updateLabelComponent();
            ip.revalidate();
        }
    }

    private void updateLabelsFont(Object fontObj) {
        if (fontObj == null) {
            return;
        }
        FontSupport fontSupport = new FontSupport();
        for (Component c : this.getComponents()) {
            if (!(c instanceof ItemPanel)) continue;
            ItemPanel ip = (ItemPanel)c;
            if (fontObj instanceof Font) {
                ip.updateLabelFont((Font)fontObj);
            } else if (fontObj instanceof String) {
                ip.updateLabelFont(fontSupport, (String)fontObj);
            }
            ip.updateLabelComponent();
            ip.revalidate();
        }
    }

    public Color getCaptionForeground() {
        return this.captionForeground;
    }

    public void setCaptionForeground(Color captionForeground) {
        this.captionForeground = captionForeground;
        this.updateLabelComponent();
    }

    public Border getCaptionBorder() {
        return this.captionBorder;
    }

    public void setCaptionBorder(Border captionBorder) {
        this.captionBorder = captionBorder;
        this.updateLabelComponent();
    }

    @Override
    public void setRequired(boolean required) {
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.oldViewType = !this.viewTypeSet ? viewType : this.viewType;
        this.viewType = viewType;
        this.viewTypeSet = true;
    }

    public boolean isChildrenAcceptStyles() {
        return false;
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public List<UIControl> getAllControls() {
        ArrayList<UIControl> allControls = new ArrayList<UIControl>();
        allControls.addAll(this.nonDynamicControls);
        allControls.addAll(this.controls);
        return allControls;
    }

    public String getEmptyWhen() {
        return this.emptyWhen;
    }

    public void setEmptyWhen(String emptyWhen) {
        this.emptyWhen = emptyWhen;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
        this.fontChanged();
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
        this.fontChanged();
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    private void fontChanged() {
    }

    private InnerBorder getInnerBorder() {
        if (this.innerBorder == null) {
            this.innerBorder = new InnerBorder();
        }
        return this.innerBorder;
    }

    private class InnerBorder
    extends AbstractBorder {
        XFormPanel root;

        private InnerBorder() {
            this.root = XFormPanel.this;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets();
        }

        @Override
        public Insets getBorderInsets(Component c, Insets ins) {
            Insets pad = this.getBorderInsets();
            if (ins == null) {
                ins = new Insets(0, 0, 0, 0);
            }
            ins.top = pad.top;
            ins.left = pad.left;
            ins.bottom = pad.bottom;
            ins.right = pad.right;
            return ins;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        public Insets getBorderInsets() {
            Insets pad = this.root.getPadding();
            if (pad == null) {
                pad = new Insets(0, 0, 0, 0);
            }
            return new Insets(pad.top, pad.left, pad.bottom, pad.right);
        }
    }

    private class ModelProviderSupport
    implements FormPanelModel.Provider {
        XFormPanel root;

        private ModelProviderSupport() {
            this.root = XFormPanel.this;
        }

        @Override
        public Object getBinding() {
            return this.root.getBinding();
        }

        @Override
        public Object getBindingBean() {
            Binding binding = this.root.getBinding();
            return binding == null ? null : binding.getBean();
        }
    }

    private class EditorInputSupport
    implements UIInputUtil.Support {
        XFormPanel root;
        PropertyResolver propertyResolver;

        private EditorInputSupport() {
            this.root = XFormPanel.this;
            this.propertyResolver = PropertyResolver.getInstance();
        }

        @Override
        public Object setValue(String name, Object value) {
            return this.setValue(name, value, null);
        }

        @Override
        public Object setValue(String name, Object value, JComponent jcomp) {
            boolean forceUpdate;
            if (this.root.model == null) {
                System.out.println("[WARN] No available FormPanelModel attached");
                return null;
            }
            boolean bl = jcomp == null ? false : (forceUpdate = jcomp.getClientProperty("UIControl.forceUpdate") == Boolean.TRUE);
            boolean noBeanUpdate = jcomp == null ? false : jcomp.getClientProperty("UIControl.noBeanUpdate") == Boolean.TRUE;
            UIControl uic = null;
            if (forceUpdate && jcomp instanceof UIControl) {
                uic = (UIControl)((Object)jcomp);
            } else if (jcomp instanceof UIInput) {
                uic = (UIControl)((Object)jcomp);
            } else if (jcomp instanceof UILookup) {
                uic = (UIControl)((Object)jcomp);
            } else {
                System.out.println("[WARN] EditorInputSupport does not support this type of component");
                return null;
            }
            Binding binding = uic.getBinding();
            Object userObj = uic.getClientProperty("UIControl.userObject");
            if (!noBeanUpdate) {
                try {
                    this.propertyResolver.setProperty(userObj, "name", (Object)name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.propertyResolver.setProperty(userObj, "value", value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            boolean has_value_changed = false;
            try {
                Object oldvalue;
                Object bean = binding == null ? null : binding.getBean();
                Object object = oldvalue = bean == null ? null : this.propertyResolver.getProperty(bean, name);
                if (!ValueUtil.isEqual((Object)oldvalue, (Object)value)) {
                    has_value_changed = true;
                    this.root.model.updateBean(name, value, userObj);
                }
            }
            catch (Throwable bean) {
                // empty catch block
            }
            try {
                if (has_value_changed) {
                    this.fireOnChangeEvent(userObj, value);
                }
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
            if (has_value_changed) {
                binding.getValueChangeSupport().notify(name, value);
            }
            if (jcomp instanceof JTextComponent) {
                JTextComponent jtxt = (JTextComponent)jcomp;
                int oldCaretPos = jtxt.getCaretPosition();
                try {
                    uic.refresh();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                finally {
                    try {
                        jtxt.setCaretPosition(oldCaretPos);
                    }
                    catch (Exception exception) {}
                }
                jtxt.putClientProperty("CaretPosition", oldCaretPos);
            }
            binding.notifyDepends(uic);
            return null;
        }

        private void fireOnChangeEvent(Object userObj, Object value) {
            Object onchangeHandler = null;
            try {
                onchangeHandler = this.propertyResolver.getProperty(userObj, "onchange");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (onchangeHandler == null) {
                return;
            }
            new CallbackHandlerProxy(onchangeHandler).call(value);
        }
    }

    private class FormControlMap
    extends FormControl {
        private Map data;

        FormControlMap(Map data) {
            this.data = data;
            HashMap props = new HashMap();
            if (data != null) {
                props.putAll(data);
            }
            String type = (String)data.get("type");
            String categoryid = (String)data.get("categoryid");
            this.init(type, props, categoryid);
        }

        Map getData() {
            return this.data;
        }
    }

    private class DefaultFormPanelModel
    extends FormPanelModel {
        XFormPanel root;
        private List<FormControl> controls;

        private DefaultFormPanelModel() {
            this.root = XFormPanel.this;
            this.controls = new ArrayList<FormControl>();
        }

        void setValue(Object value) {
            block2: {
                block3: {
                    this.controls.clear();
                    if (value == null) break block2;
                    if (!value.getClass().isArray()) break block3;
                    for (Object o : (Object[])value) {
                        if (o == null) continue;
                        this.controls.add(this.root.toFormControl(o));
                    }
                    break block2;
                }
                if (!(value instanceof Collection)) break block2;
                for (Object o : (Collection)value) {
                    if (o == null) continue;
                    this.controls.add(this.root.toFormControl(o));
                }
            }
        }

        @Override
        public Object getFormControls() {
            return this.controls;
        }
    }

    private class ModelListener
    implements FormPanelModel.Listener {
        private ModelListener() {
        }

        @Override
        public void onPropertyUpdated(String name, Object value) {
            XFormPanel handle = XFormPanel.this;
            PropertyResolver res = PropertyResolver.getInstance();
            try {
                res.setProperty((Object)handle, name, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public String getHtmlFormat(boolean partial) {
            FormControlUtil fcUtil = FormControlUtil.getInstance();
            return fcUtil.renderHtml(XFormPanel.this.getAllControls(), XFormPanel.this, partial);
        }

        @Override
        public void onReload() {
            XFormPanel.this.reload();
            XFormPanel.this.refresh();
        }
    }

    private class FormPanelBindingListener
    implements BindingListener {
        private FormPanelBindingListener() {
        }

        @Override
        public void notifyDepends(UIControl u, Binding parent) {
            this.notifyDepends(u, parent, u.getName());
        }

        @Override
        public void notifyDepends(UIControl u, Binding parent, String name) {
            if (ValueUtil.isEmpty((Object)name)) {
                return;
            }
            if (ValueUtil.isEqual((Object)XFormPanel.this.viewType, (Object)"html")) {
                boolean shouldRefresh = false;
                for (UIControl control : XFormPanel.this.controls) {
                    if (!this.isDependent(name, control)) continue;
                    shouldRefresh = true;
                }
                if (shouldRefresh) {
                    XFormPanel.this.refreshHtml();
                }
            } else {
                HashSet refreshed = new HashSet();
                for (UIControl control : XFormPanel.this.controls) {
                    if (!this.isDependent(name, control)) continue;
                    this._doRefresh(control, refreshed);
                }
                refreshed.clear();
                refreshed = null;
            }
        }

        private boolean isDependent(String parentName, UIControl child) {
            if (child.getDepends() != null) {
                for (String s : child.getDepends()) {
                    if (!parentName.matches(s)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void refresh(String regEx) {
            if (ValueUtil.isEqual((Object)XFormPanel.this.viewType, (Object)"html")) {
                return;
            }
            HashSet refreshed = new HashSet();
            for (UIControl uu : XFormPanel.this.controls) {
                String name = uu.getName();
                if (regEx != null && name != null && !name.matches(regEx)) continue;
                this._doRefresh(uu, refreshed);
            }
            refreshed.clear();
            refreshed = null;
        }

        private void _doRefresh(UIControl u, Set refreshed) {
            if (refreshed.add(u)) {
                u.refresh();
            }
        }

        @Override
        public void validate(ActionMessage actionMessage, Binding parent) {
        }

        @Override
        public void validateBean(ValidatorEvent evt) {
        }

        @Override
        public void formCommit() {
        }

        @Override
        public void update() {
        }
    }

    private class Layout
    implements LayoutManager {
        private Logger logger = Logger.getLogger(this.getClass().getName());

        private Layout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                if ("HORIZONTAL".equals(XFormPanel.this.orientation)) {
                    this.layoutContainerHorizontal(parent);
                } else {
                    this.layoutContainerVertical(parent);
                }
            }
        }

        private int relayoutBounds(Container parent, Component[] comps) {
            Insets margin = parent.getInsets();
            int x = margin.left;
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                Rectangle rect = c.getBounds();
                int spacing = i > 0 ? XFormPanel.this.getCellspacing() : 0;
                c.setBounds(x += spacing + ((XFormPanel)XFormPanel.this).cellpadding.left, rect.y, rect.width, rect.height);
                x += rect.width + ((XFormPanel)XFormPanel.this).cellpadding.right;
            }
            int pw = parent.getWidth() - margin.right;
            return Math.max(pw - x, 0);
        }

        private void layoutContainerHorizontal(Container parent) {
            Component c;
            Component c2;
            int i;
            FormItemProperty fip;
            Insets margin = parent.getInsets();
            int x = margin.left;
            int y = margin.top;
            ArrayList<Component> list = new ArrayList<Component>();
            Component[] comps = this.getVisibleComponents(parent);
            for (int i2 = 0; i2 < comps.length; ++i2) {
                Component c3 = comps[i2];
                Dimension dim = c3.getPreferredSize();
                int spacing = i2 > 0 ? XFormPanel.this.getCellspacing() : 0;
                fip = (FormItemProperty)((Object)c3);
                int sw = fip.getStretchWidth();
                if (sw > 0) {
                    list.add(c3);
                }
                c3.setBounds(x += spacing + ((XFormPanel)XFormPanel.this).cellpadding.left, y, dim.width, dim.height);
                x += dim.width + ((XFormPanel)XFormPanel.this).cellpadding.right;
            }
            if (list.isEmpty()) {
                return;
            }
            int w = parent.getWidth() - (margin.left + margin.right);
            int extrawidth = Math.max(w - x, 0);
            if (extrawidth == 0) {
                return;
            }
            int[] widths = new int[list.size()];
            for (i = 0; i < list.size(); ++i) {
                int xw;
                c2 = (Component)list.get(i);
                FormItemProperty fip2 = (FormItemProperty)((Object)c2);
                int sw = fip2.getStretchWidth();
                double d0 = extrawidth;
                double d1 = (double)sw / 100.0;
                double d2 = d0 * d1;
                widths[i] = xw = new BigDecimal(d2).setScale(0, RoundingMode.HALF_UP).intValue();
            }
            while (this.sum(widths) > extrawidth) {
                i = 0;
                while (i < widths.length && this.sum(widths) - 1 >= extrawidth) {
                    int n = i++;
                    widths[n] = widths[n] - 1;
                }
            }
            for (i = 0; i < widths.length; ++i) {
                c2 = (Component)list.get(i);
                Rectangle rect = c2.getBounds();
                Dimension dim = c2.getPreferredSize();
                c2.setBounds(rect.x, rect.y, dim.width + widths[i], rect.height);
            }
            this.relayoutBounds(parent, comps);
            if (comps.length > 0 && (fip = (FormItemProperty)((Object)(c = comps[comps.length - 1]))).getStretchWidth() > 0) {
                Rectangle rect = c.getBounds();
                int cx = rect.x + rect.width;
                int px = parent.getWidth() - margin.right - ((XFormPanel)XFormPanel.this).cellpadding.right;
                if (cx < px) {
                    int w0 = Math.max(px - cx, 0);
                    c.setBounds(rect.x, rect.y, rect.width + w0, rect.height);
                }
            }
        }

        private int sum(int[] values) {
            int result = 0;
            for (int i = 0; i < values.length; ++i) {
                result += values[i];
            }
            return result;
        }

        private void layoutContainerVertical(Container parent) {
            int i;
            Insets margin = parent.getInsets();
            int x = margin.left;
            int y = margin.top;
            int w = parent.getWidth() - (margin.left + margin.right);
            int h = parent.getHeight() - (margin.top + margin.bottom);
            int preferredMaxWidth = 0;
            Component[] comps = this.getVisibleComponents(parent);
            for (i = 0; i < comps.length; ++i) {
                Dimension dim = comps[i].getPreferredSize();
                preferredMaxWidth = Math.max(preferredMaxWidth, dim.width);
            }
            for (i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                Dimension dim = c.getPreferredSize();
                FormItemProperty fip = (FormItemProperty)((Object)c);
                if (i > 0) {
                    y += XFormPanel.this.getCellspacing();
                    if (XFormPanel.this.isShowCategory()) {
                        y += 10;
                    }
                }
                int dw = dim.width;
                int sw = fip.getStretchWidth();
                if (XFormPanel.this.isShowCategory() && sw == 0) {
                    sw = 100;
                }
                if (sw > 0) {
                    double d1;
                    double d2;
                    double d0 = w;
                    if (w < preferredMaxWidth) {
                        d0 = preferredMaxWidth;
                    }
                    if ((dw = new BigDecimal(d2 = d0 * (d1 = (double)sw / 100.0)).setScale(0, RoundingMode.HALF_UP).intValue()) < dim.width) {
                        dw = dim.width;
                    }
                }
                c.setBounds(x, y += ((XFormPanel)XFormPanel.this).cellpadding.top, dw, dim.height);
                y += dim.height + ((XFormPanel)XFormPanel.this).cellpadding.bottom;
            }
        }

        private Component[] getVisibleComponents(Container parent) {
            ArrayList<Component> results = new ArrayList<Component>();
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!comps[i].isVisible()) continue;
                if (comps[i] instanceof FormItemProperty) {
                    results.add(comps[i]);
                    continue;
                }
                comps[i].setBounds(0, 0, 0, 0);
            }
            return results.toArray(new Component[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, 0);
                Component[] comps = parent.getComponents();
                dim = "HORIZONTAL".equals(XFormPanel.this.orientation) ? this.getHorizontalLayoutSize(comps) : this.getVerticalLayoutSize(comps);
                Insets margin = parent.getInsets();
                int w = dim.width + margin.left + margin.right;
                int h = dim.height + margin.top + margin.bottom;
                return new Dimension(w, h);
            }
        }

        private Dimension getHorizontalLayoutSize(Component[] comps) {
            int w = 0;
            int h = 0;
            boolean hasVisibleComponents = false;
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!c.isVisible() || !(c instanceof FormItemProperty)) continue;
                if (hasVisibleComponents) {
                    w += XFormPanel.this.getCellspacing();
                }
                Dimension dim = c.getPreferredSize();
                h = Math.max(h, dim.height + ((XFormPanel)XFormPanel.this).cellpadding.top + ((XFormPanel)XFormPanel.this).cellpadding.bottom);
                w += dim.width + ((XFormPanel)XFormPanel.this).cellpadding.left + ((XFormPanel)XFormPanel.this).cellpadding.right;
                hasVisibleComponents = true;
            }
            return new Dimension(w, h);
        }

        private Dimension getVerticalLayoutSize(Component[] comps) {
            int w = 0;
            int h = 0;
            boolean hasVisibleComponents = false;
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!c.isVisible() || !(c instanceof FormItemProperty)) continue;
                if (hasVisibleComponents) {
                    h += XFormPanel.this.getCellspacing();
                    if (XFormPanel.this.isShowCategory()) {
                        h += 10;
                    }
                }
                Dimension dim = c.getPreferredSize();
                w = Math.max(w, dim.width + ((XFormPanel)XFormPanel.this).cellpadding.left + ((XFormPanel)XFormPanel.this).cellpadding.right);
                h += dim.height + ((XFormPanel)XFormPanel.this).cellpadding.top + ((XFormPanel)XFormPanel.this).cellpadding.bottom;
                hasVisibleComponents = true;
            }
            return new Dimension(w, h);
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public Dimension maximumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        public float getLayoutAlignmentX(Container parent) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container parent) {
            return 0.0f;
        }

        public void invalidateLayout(Container parent) {
            this.layoutContainer(parent);
        }
    }
}

