/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.control.AbstractIconedTextField;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class XFileBrowser
extends AbstractIconedTextField {
    private JFileChooser fchooser;
    private boolean listFiles;
    private boolean multiSelect;
    private boolean selectFilesOnly;
    private boolean selectDirsOnly;
    private String dialogType;
    private String customFilter;
    private String fileNamePattern;
    private String expression;
    private String varName;
    private FileFilterProxy fileFilterProxy;

    public XFileBrowser() {
        this.initComponents();
    }

    private void initComponents() {
        this.dialogType = "open";
        this.fchooser = new JFileChooser();
        this.setListFiles(true);
        this.setMultiSelect(false);
        this.setSelectFilesOnly(true);
        this.setIcon("com/rameses/rcp/icons/folder_open.png");
        this.setOrientation("RIGHT");
        this.setHint("Browse File");
        super.setEditable(false);
        this.setVarName("item");
    }

    @Override
    public void setEditable(boolean b) {
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public boolean isNullWhenEmpty() {
        return true;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public Object getValue() {
        return this.isMultiSelect() ? this.fchooser.getSelectedFiles() : this.fchooser.getSelectedFile();
    }

    public String getCustomFilter() {
        return this.customFilter;
    }

    public void setCustomFilter(String customFilter) {
        this.customFilter = customFilter;
    }

    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isSelectFilesOnly() {
        return this.selectFilesOnly;
    }

    public void setSelectFilesOnly(boolean selectFilesOnly) {
        this.selectFilesOnly = selectFilesOnly;
    }

    public boolean isSelectDirectoriesOnly() {
        return this.selectDirsOnly;
    }

    public void setSelectDirectoriesOnly(boolean selectDirsOnly) {
        this.selectDirsOnly = selectDirsOnly;
    }

    public String getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(String dialogType) {
        this.dialogType = dialogType;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Override
    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void refresh() {
        block11: {
            try {
                if (!this.isReadonly() && !this.isFocusable()) {
                    this.setFocusable(true);
                }
                Object[] arr = null;
                Object value = UIControlUtil.getBeanValue(this);
                arr = value == null ? new Object[]{} : (value.getClass().isArray() ? (Object[])value : new Object[]{value});
                if (arr.length == 0) {
                    this.setText("");
                    if (this.multiSelect) {
                        this.fchooser.setSelectedFiles(null);
                    } else {
                        this.fchooser.setSelectedFile(null);
                    }
                } else {
                    String exprStr = this.getExpression();
                    StringBuilder sb = new StringBuilder();
                    ExprBeanSupport beanSupport = new ExprBeanSupport(this.getBinding().getBean());
                    boolean hasExpr = exprStr != null && exprStr.length() > 0;
                    for (int i = 0; i < arr.length; ++i) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        if (arr[i] == null) {
                            sb.append("null");
                            continue;
                        }
                        if (hasExpr) {
                            beanSupport.setItem(this.getVarName(), arr[i]);
                            sb.append(UIControlUtil.evaluateExpr(beanSupport.createProxy(), exprStr) + "");
                            continue;
                        }
                        sb.append(arr[i].toString());
                    }
                    this.setText(sb.toString());
                }
            }
            catch (Throwable e) {
                this.setText("");
                this.setFocusable(false);
                if (!ClientContext.getCurrentContext().isDebugMode()) break block11;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void load() {
    }

    @Override
    public void actionPerformed() {
        if (!this.isFocusable() || !this.isEnabled()) {
            return;
        }
        FileFilterImpl filter = null;
        filter = this.fileFilterProxy == null ? new FileFilterImpl() : this.fileFilterProxy;
        ((FileFilterImpl)filter).init();
        if (this.isSelectDirectoriesOnly()) {
            this.fchooser.setFileSelectionMode(1);
        }
        this.fchooser.setMultiSelectionEnabled(this.isMultiSelect());
        this.fchooser.setFileFilter(filter);
        this.fchooser.setSelectedFile(null);
        this.fchooser.setSelectedFiles(null);
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Component relativeComp = win instanceof Component ? (Component)win : null;
        int resp = 0;
        resp = "open".equals(this.dialogType) ? this.fchooser.showOpenDialog(relativeComp) : this.fchooser.showSaveDialog(relativeComp);
        if (resp == 0) {
            UIInputUtil.updateBeanValue(this);
        }
        this.refresh();
    }

    public void setCustomFileFilter(FileFilter customFileFilter) {
        this.fileFilterProxy = customFileFilter == null ? null : new FileFilterProxy(customFileFilter);
    }

    private class FileFilterImpl
    extends FileFilter {
        XFileBrowser root;
        private String _OldPattern;
        private String _NewPattern;
        private boolean _IsListFiles;

        private FileFilterImpl() {
            this.root = XFileBrowser.this;
        }

        void init() {
            String str = XFileBrowser.this.getFileNamePattern();
            if (str != null && str.trim().length() > 0) {
                Object value = null;
                try {
                    value = UIControlUtil.getBeanValue(XFileBrowser.this.getBinding(), str.trim());
                    str = value.toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (str == null) {
                str = "*";
            }
            this._OldPattern = str;
            this._NewPattern = str.replaceAll("[\\s]{1,}", "").replaceAll("\\*", ".*").replaceAll(",", "|").toLowerCase();
            this._IsListFiles = XFileBrowser.this.isListFiles();
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return XFileBrowser.this.isSelectDirectoriesOnly();
            }
            if (!this._IsListFiles) {
                return false;
            }
            return f.getName().toLowerCase().matches(this._NewPattern);
        }

        @Override
        public String getDescription() {
            if (this._NewPattern.equals(".*")) {
                return "All Files";
            }
            return this._OldPattern;
        }
    }

    private class FileFilterProxy
    extends FileFilterImpl {
        FileFilter handler;

        FileFilterProxy(FileFilter handler) {
            this.handler = handler;
        }

        @Override
        void init() {
        }

        @Override
        public boolean accept(File f) {
            return this.handler.accept(f);
        }

        @Override
        public String getDescription() {
            return this.handler.getDescription();
        }
    }
}

