/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.DataListModel;
import com.rameses.rcp.common.ObjectProxy;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.control.border.XEtchedBorder;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.swing.ListPane;
import com.rameses.rcp.swing.UIVisibility;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.ErrorDialog;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class XDropDownList
extends JButton
implements UIControl,
ActiveControl {
    private Binding binding;
    private String[] depends;
    private int index;
    private ControlProperty property;
    private String varName = "item";
    private String disableWhen;
    private String visibleWhen;
    private String expression;
    private String itemExpression;
    private String handler;
    private Object handlerObject;
    private Object modelObject;
    private MetaInfo metaInfo;
    private AbstractListDataProvider model;
    private ActionListenerImpl actionListener;
    private String title;
    private String iconResource;
    private String accelerator;
    private KeyStroke acceleratorKS;
    private Dimension popupSize;
    private int cellHeight;
    private boolean hideOnEmptyResult;
    private LabelCounter labelCounter;
    private UIVisibility visibility;
    private int stretchWidth;
    private int stretchHeight;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private JPopupMenu jpopup;
    private Renderer renderer;

    public XDropDownList() {
        this.initComponent();
    }

    private void initComponent() {
        this.labelCounter = new LabelCounter();
        this.labelCounter.setText("");
        this.labelCounter.setBounds(2, 2, 18, 18);
        this.addActionListener(this.getActionListener());
        this.setCellHeight(-1);
    }

    private ActionListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new ActionListenerImpl();
        }
        return this.actionListener;
    }

    public boolean isHideOnEmptyResult() {
        return this.hideOnEmptyResult;
    }

    public void setHideOnEmptyResult(boolean hideOnEmptyResult) {
        this.hideOnEmptyResult = hideOnEmptyResult;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getItemExpression() {
        return this.itemExpression;
    }

    public void setItemExpression(String itemExpression) {
        this.itemExpression = itemExpression;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Object getHandlerObject() {
        return this.handlerObject;
    }

    public void setHandlerObject(Object handlerObject) {
        this.handlerObject = handlerObject;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(String accelerator) {
        this.accelerator = accelerator;
        try {
            if (this.acceleratorKS != null) {
                this.unregisterKeyboardAction(this.acceleratorKS);
            }
            this.acceleratorKS = KeyStroke.getKeyStroke(accelerator);
            if (this.acceleratorKS != null) {
                this.registerKeyboardAction(this.getActionListener(), this.acceleratorKS, 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
        this.setIcon(ImageIconSupport.getInstance().getIcon(iconResource));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
    }

    public Dimension getPopupSize() {
        return this.popupSize;
    }

    public void setPopupSize(Dimension popupSize) {
        this.popupSize = popupSize;
    }

    public void setVisibility(UIVisibility visibility) {
        this.visibility = visibility;
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public void load() {
    }

    @Override
    public void refresh() {
        block19: {
            Binding binding = this.getBinding();
            Object bean = binding == null ? null : binding.getBean();
            Object value = UIControlUtil.getBeanValue(bean, this.getName());
            String whenExpr = this.getVisibleWhen();
            if (whenExpr != null && whenExpr.length() > 0) {
                boolean result = false;
                try {
                    result = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(result);
            }
            if ((whenExpr = this.getDisableWhen()) != null && whenExpr.length() > 0) {
                boolean disabled = false;
                try {
                    disabled = UIControlUtil.evaluateExprBoolean(binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setEnabled(!disabled);
            }
            try {
                Object handlerObj = this.getHandlerObject();
                String handler = this.getHandler();
                if (handler != null && handler.length() > 0) {
                    handlerObj = UIControlUtil.getBeanValue(bean, handler);
                }
                this.model = handlerObj instanceof AbstractListDataProvider ? (AbstractListDataProvider)handlerObj : (handlerObj instanceof List ? new ListModelImpl((List)handlerObj) : (handlerObj instanceof Object[] ? new ListModelImpl((Object[])handlerObj) : new ListModelImpl(handlerObj)));
                this.modelObject = handlerObj;
                this.metaInfo = new ObjectProxy().create(this.modelObject == null ? new Object() : this.modelObject, MetaInfo.class);
            }
            catch (Throwable t) {
                ErrorDialog.show(t, this);
            }
            try {
                this.model.load();
                if (this.isHideOnEmptyResult()) {
                    if (this.model.getDataListSize() > 0) {
                        this.setVisible(true);
                    } else {
                        this.setVisible(false);
                    }
                }
            }
            catch (Throwable t) {
                ErrorDialog.show(t, this);
            }
            int size = this.model == null ? 0 : this.model.getDataListSize();
            this.labelCounter.setText(size + "");
            try {
                String visibleWhen = this.getVisibleWhen();
                if (visibleWhen == null || visibleWhen.length() <= 0) break block19;
                Object exprBean = this.createExpressionBean(value);
                boolean b = false;
                try {
                    b = UIControlUtil.evaluateExprBoolean(exprBean, visibleWhen);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(b);
            }
            catch (Throwable visibleWhen) {
                // empty catch block
            }
        }
        this.revalidate();
        this.repaint();
        Renderer renderer = this.getRenderer();
        if (renderer != null) {
            renderer.setModel(this.model);
            renderer.refresh();
        }
    }

    private Object createExpressionBean(Object itemBean) {
        ExprBeanSupport beanSupport = new ExprBeanSupport(this.binding.getBean());
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font font) {
        this.getControlProperty().setCaptionFont(font);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public boolean isVisible() {
        if (this.visibility != null) {
            return this.visibility.isVisible();
        }
        return super.isVisible();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int pw = this.getWidth();
        Dimension dim = this.labelCounter.getPreferredSize();
        int x = Math.max(pw - dim.width * 2, 0);
        Graphics g2 = g.create(x, 0, dim.width * 2, dim.height);
        this.labelCounter.paint(g2);
        g2.dispose();
    }

    public String getItemText(Object item) {
        try {
            Object o = this.metaInfo.getItemText(item);
            if (o != null) {
                return o.toString();
            }
        }
        catch (Throwable o) {
            // empty catch block
        }
        String expression = this.getItemExpression();
        if (expression == null || expression.length() == 0) {
            return item == null ? null : item.toString();
        }
        Object exprBean = this.createExpressionBean(item);
        Object result = UIControlUtil.evaluateExpr(exprBean, expression);
        return result == null ? null : result.toString();
    }

    private void onselectImpl(Object item) {
        if (this.model == null) {
            return;
        }
        try {
            this.getPopup().setVisible(false);
            Method method = this.getCallbackMethod(this.modelObject, "onselect");
            if (method == null) {
                this.fireUpdateBeanValue(item);
            } else {
                this.fireOnSelect(item);
            }
        }
        catch (Throwable t) {
            ErrorDialog.show(t, this);
        }
    }

    private void fireUpdateBeanValue(Object item) {
        Object bean;
        Binding binding = this.getBinding();
        Object object = bean = binding == null ? null : binding.getBean();
        if (bean == null) {
            return;
        }
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return;
        }
        UIControlUtil.setBeanValue(bean, name, item);
        binding.notifyDepends(name);
    }

    private void fireOnSelect(Object item) {
        Object outcome = this.metaInfo.onselect(item);
        this.transferFocus();
        if (outcome instanceof Opener) {
            this.getBinding().fireNavigation(outcome);
        }
    }

    private JPopupMenu getPopup() {
        if (this.jpopup == null) {
            this.jpopup = new JPopupMenu();
            this.jpopup.setLayout(new PopupLayout());
            this.jpopup.setLightWeightPopupEnabled(true);
            Border bout = BorderFactory.createLineBorder(Color.decode("#808080"));
            Border bin = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.jpopup.setBorder(BorderFactory.createCompoundBorder(bout, bin));
        }
        return this.jpopup;
    }

    private Method getCallbackMethod(Object obj, String name) {
        Method m2;
        if (obj == null || name == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        try {
            m2 = clazz.getMethod(name, Object[].class);
            if (m2 != null) {
                return m2;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = clazz.getMethod(name, Object.class);
            if (m2 != null) {
                return m2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Method getGetterMethod(Object obj, String name) {
        if (obj == null || name == null) {
            return null;
        }
        try {
            Method m = obj.getClass().getMethod(name, new Class[0]);
            if (m != null) {
                return m;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private String getPreferredTitle() {
        try {
            Object result = this.metaInfo.getTitle();
            if (result != null) {
                return result.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.getTitle();
    }

    private int getPreferredCellHeight() {
        try {
            return this.metaInfo.getItemHeight();
        }
        catch (Throwable t) {
            return this.getCellHeight();
        }
    }

    private int getPreferredPopupHeight() {
        try {
            return this.metaInfo.getHeight();
        }
        catch (Throwable throwable) {
            Dimension dim = this.getPopupSize();
            return dim == null ? -1 : dim.height;
        }
    }

    private int getPreferredPopupWidth() {
        try {
            return this.metaInfo.getWidth();
        }
        catch (Throwable throwable) {
            Dimension dim = this.getPopupSize();
            return dim == null ? -1 : dim.width;
        }
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public static interface Renderer {
        public void setModel(AbstractListDataProvider var1);

        public void refresh();

        public boolean isVisible();

        public void setVisible(boolean var1);
    }

    public static interface MetaInfo {
        public Object getItemText(Object var1);

        public Object onselect(Object var1);

        public Object getTitle();

        public int getItemHeight();

        public int getHeight();

        public int getWidth();
    }

    private class LayoutImpl
    implements LayoutManager,
    LayoutManager2 {
        XDropDownList root;

        private LayoutImpl() {
            this.root = XDropDownList.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        private boolean isLabelVisible() {
            if (this.root.labelCounter == null) {
                return false;
            }
            if (!this.root.labelCounter.isVisible()) {
                return false;
            }
            String text = this.root.labelCounter.getText();
            return text != null && text.length() > 0 && !text.equals("0");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Icon icon = this.root.getIcon();
                if (icon != null) {
                    w = icon.getIconWidth();
                    h = icon.getIconHeight();
                }
                if (this.isLabelVisible()) {
                    Dimension dim = this.root.labelCounter.getPreferredSize();
                    w = Math.max(w / 2 + dim.width, 0);
                    h = Math.max(dim.height + 2, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                if (this.root.labelCounter == null) {
                    return;
                }
                if (this.isLabelVisible()) {
                    Dimension dim = this.root.labelCounter.getPreferredSize();
                    int pw = parent.getWidth();
                    int cw = Math.max(dim.width, 12);
                    int px = Math.max(pw - cw, 0);
                    this.root.labelCounter.setBounds(px, 2, cw, dim.height);
                } else {
                    this.root.labelCounter.setBounds(0, 0, 0, 0);
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.getLayoutSize(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.1f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.1f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }

    private class LabelCounter
    extends JLabel {
        public LabelCounter() {
            this.setOpaque(true);
            this.setBackground(Color.RED);
            this.setForeground(Color.WHITE);
            this.setFont(Font.decode("arial-bold-11"));
            this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
        }
    }

    private class PopupLayout
    implements LayoutManager {
        XDropDownList root;

        private PopupLayout() {
            this.root = XDropDownList.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w = Math.max(w, dim.width);
                    h += dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, w, dim.height);
                    y += dim.height;
                }
            }
        }
    }

    private class ActionListenerImpl
    implements ActionListener,
    ListPane.Handler {
        XDropDownList root;

        private ActionListenerImpl() {
            this.root = XDropDownList.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.root.model == null) {
                return;
            }
            JPopupMenu jpm = this.root.getPopup();
            jpm.setVisible(false);
            Renderer renderer = XDropDownList.this.getRenderer();
            if (renderer != null) {
                boolean oldvisible = renderer.isVisible();
                renderer.refresh();
                renderer.setVisible(!oldvisible);
                return;
            }
            ListPane lp = new ListPane(){

                @Override
                protected String getItemText(Object item) {
                    return ActionListenerImpl.this.root.getItemText(item);
                }
            };
            lp.setCellHeight(this.root.getPreferredCellHeight());
            lp.addHandler(this);
            lp.setModel(this.root.model);
            jpm.removeAll();
            int pw = this.root.getPreferredPopupWidth();
            int ph = this.root.getPreferredPopupHeight();
            Dimension dim = lp.getPreferredSize();
            if (dim.width < 200) {
                dim.width = 200;
            }
            if (pw > 0) {
                dim.width = pw;
            }
            if (ph > 0) {
                dim.height = ph;
            }
            lp.setPreferredSize(new Dimension(dim.width, dim.height));
            String title = this.root.getPreferredTitle();
            if (title != null && title.length() > 0) {
                XEtchedBorder border = new XEtchedBorder();
                border.setPadding(new Insets(3, 5, 3, 5));
                border.setHideTop(true);
                border.setHideLeft(true);
                border.setHideRight(true);
                JLabel header = new JLabel();
                header.setBorder(border);
                header.setText("<html>" + title + "</html>");
                jpm.add(header);
            }
            jpm.add(lp);
            jpm.pack();
            Rectangle rect = this.root.getBounds();
            jpm.show(this.root, 0, rect.height);
            lp.requestFocus();
        }

        @Override
        public void onselect(Object item) {
            this.root.onselectImpl(item);
        }
    }

    private class ListModelImpl
    extends DataListModel {
        private List list;
        private CallbackHandlerProxy callback;

        ListModelImpl(List list) {
            this.list = list;
        }

        ListModelImpl(Object[] values) {
            this.list = Arrays.asList(values);
        }

        ListModelImpl(Object value) {
            this.list = new ArrayList();
            if (value == null) {
                return;
            }
            if (this.isCallback(value)) {
                this.callback = new CallbackHandlerProxy(value);
            } else {
                this.list.add(value);
            }
        }

        @Override
        public List fetchList(Map params) {
            if (this.callback == null) {
                return this.list;
            }
            return (List)this.callback.call(params);
        }

        private boolean isCallback(Object value) {
            if (value == null) {
                return false;
            }
            try {
                Method method = value.getClass().getMethod("call", Object.class);
                return method != null;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

