/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Node;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TreeNodeModel;
import com.rameses.rcp.control.menu.MenuItemProxy;
import com.rameses.rcp.control.menu.MenuProxy;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ControlEvent;
import com.rameses.rcp.framework.EventListener;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class XContextMenu
extends JPanel
implements UIControl,
EventListener {
    private Binding binding;
    private int index;
    private String[] depends;
    private String handler;
    private boolean dynamic;
    private String eventName = "RIGHT_CLICK";
    private String menuFor;
    private String menuPosition = "MOUSE_POSITION";
    private TreeNodeModel nodeModel;
    private JPopupMenu popupMenu;
    private Component target;
    private int stretchWidth;
    private int stretchHeight;
    private String visibleWhen;

    public XContextMenu() {
        if (Beans.isDesignTime()) {
            this.setOpaque(true);
            this.setBackground(Color.GREEN);
            this.setPreferredSize(new Dimension(10, 10));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setVisible(false);
        }
    }

    @Override
    public void refresh() {
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        if (ValueUtil.isEmpty((Object)this.handler)) {
            throw new IllegalStateException("XTree Error: A handler must be provided");
        }
        this.nodeModel = (TreeNodeModel)UIControlUtil.getBeanValue(this, this.handler);
        this.target = (Component)((Object)this.binding.find(this.menuFor));
        this.popupMenu = new JPopupMenu();
        this.buildMenus();
    }

    private void buildMenus() {
        this.popupMenu.removeAll();
        for (Node n : this.nodeModel.fetchNodes(this.nodeModel.getRootNode())) {
            if (n.isLeaf()) {
                this.popupMenu.add(new MenuItemProxy(this, this.nodeModel, n));
                continue;
            }
            this.popupMenu.add(new MenuProxy(this, this.nodeModel, n));
        }
        this.popupMenu.revalidate();
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    public void onEvent(ControlEvent evt) {
        if (!this.eventName.equals(evt.getEventName())) {
            return;
        }
        if (this.popupMenu.getComponentCount() == 0) {
            return;
        }
        Component source = this.target;
        Point p = null;
        if ("MOUSE_POSITION".equals(this.menuPosition) && evt.getSourceEvent() instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)evt.getSourceEvent();
            p = me.getPoint();
            source = (Component)me.getSource();
        } else {
            p = this.target.getLocation();
        }
        this.popupMenu.show(source, p.x, p.y);
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getMenuFor() {
        return this.menuFor;
    }

    public void setMenuFor(String menuFor) {
        this.menuFor = menuFor;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getMenuPosition() {
        return this.menuPosition;
    }

    public void setMenuPosition(String menuPosition) {
        this.menuPosition = menuPosition;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    @Override
    public void onEvent(Object o) {
    }

    @Override
    public void onMessage(Object o) {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public void onUnregister() {
    }
}

