/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlContainer;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UICommand;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class XComponent
extends JPanel
implements UIControl,
ActiveControl,
MouseEventSupport.ComponentInfo {
    protected Binding binding;
    private ControlProperty property;
    private String[] depends;
    private String visibleWhen;
    private boolean dynamic;
    private int index;
    private int stretchWidth;
    private int stretchHeight;
    private String dataPrefix;
    private String actionPrefix;

    public void init() {
    }

    public void registerControl(UIControl uic) {
    }

    public void unregisterControl(UIControl uic) {
    }

    public void afterLoad() {
    }

    public void afterRefresh() {
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public final void setBinding(Binding binding) {
        this.binding = binding;
        this.init();
        this.registerComponents(this, binding);
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public final void load() {
        this.afterLoad();
    }

    @Override
    public final void refresh() {
        String expr = this.getVisibleWhen();
        if (expr != null && expr.length() > 0) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.getBinding().getBean(), expr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
        this.afterRefresh();
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.getControlProperty().setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bean", this.getBean());
        map.put("actionPrefix", this.getActionPrefix());
        map.put("dataPrefix", this.getDataPrefix());
        map.put("visibleWhen", this.getVisibleWhen());
        return map;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public Object getProperty(String name) {
        Binding binding = this.getBinding();
        if (binding == null) {
            return null;
        }
        return UIControlUtil.getBeanValue(binding, name);
    }

    public Object getBean() {
        Binding binding = this.getBinding();
        return binding == null ? null : binding.getBean();
    }

    public String getDataPrefix() {
        return this.dataPrefix;
    }

    public void setDataPrefix(String dataPrefix) {
        this.dataPrefix = dataPrefix;
        this.firePrefixChanged(this.getDataPrefix(), this.getActionPrefix(), this);
    }

    public String getActionPrefix() {
        return this.actionPrefix;
    }

    public void setActionPrefix(String actionPrefix) {
        this.actionPrefix = actionPrefix;
        this.firePrefixChanged(this.getDataPrefix(), this.getActionPrefix(), this);
    }

    private String getComponentName(UIControl uic) {
        String keyword = "XComponent.UIControl.name";
        String[] props = (String[])uic.getClientProperty(keyword);
        if (props == null) {
            props = new String[]{uic.getName()};
            uic.putClientProperty(keyword, props);
        }
        return props[0];
    }

    private void registerComponents(Container cont, Binding binding) {
        for (Component c : cont.getComponents()) {
            if (c instanceof UIControl) {
                UIControl uic = (UIControl)((Object)c);
                if (binding == null) {
                    uic.setBinding(binding);
                    binding.unregister(uic);
                    this.unregisterControl(uic);
                } else {
                    binding.bind(uic);
                    this.registerControl(uic);
                    binding.register(uic);
                }
                if (!(c instanceof ControlContainer) || !((ControlContainer)((Object)c)).isHasNonDynamicContents() || !(c instanceof Container)) continue;
                this.registerComponents((Container)c, binding);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.registerComponents((Container)c, binding);
        }
    }

    private void firePrefixChanged(String dataPrefix, String actionPrefix, Container cont) {
        for (Component c : cont.getComponents()) {
            if (c instanceof UIControl) {
                UIControl uic = (UIControl)((Object)c);
                String sname = this.getComponentName(uic);
                if (uic instanceof UICommand) {
                    this.configureUI(c, sname, actionPrefix);
                } else {
                    this.configureUI(c, sname, dataPrefix);
                }
                if (!(c instanceof ControlContainer) || !((ControlContainer)((Object)c)).isHasNonDynamicContents() || !(c instanceof Container)) continue;
                this.firePrefixChanged(dataPrefix, actionPrefix, (Container)c);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.firePrefixChanged(dataPrefix, actionPrefix, (Container)c);
        }
    }

    private void configureUI(Component c, String sname, String prefix) {
        String newname = this.join(new String[]{prefix, sname}, ".");
        if (newname == null) {
            c.setName(null);
        } else {
            c.setName(newname);
        }
    }

    private String join(String[] values, String delim) {
        StringBuilder sb = new StringBuilder();
        for (String sval : values) {
            if (sval == null || sval.trim().length() == 0) continue;
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(sval);
        }
        String text = sb.toString();
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        return text;
    }
}

