/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class XCheckBox
extends JCheckBox
implements UIInput,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private ItemListenerImpl itemHandler = new ItemListenerImpl();
    private ControlProperty property = new ControlProperty();
    private Binding binding;
    private String[] depends;
    private String fontStyle;
    private boolean readonly;
    private boolean inited;
    private int index;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private Class valueType = Boolean.class;
    private Object uncheckValue = false;
    private Object checkValue = true;
    private int stretchWidth;
    private int stretchHeight;
    private String disableWhen;
    private String visibleWhen;

    public XCheckBox() {
        new MouseEventSupport(this).install();
        this.setOpaque(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        try {
            this.itemHandler.enabled = false;
            String whenExpr = this.getVisibleWhen();
            if (whenExpr != null && whenExpr.length() > 0) {
                boolean result = false;
                try {
                    result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setVisible(result);
            }
            if ((whenExpr = this.getDisableWhen()) != null && whenExpr.length() > 0) {
                boolean disabled = false;
                try {
                    disabled = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                this.setEnabled(!disabled);
            }
            if (this.isEnabled()) {
                this.setReadonly(this.isReadonly());
            }
            if ("true".equals(this.getClientProperty(JTable.class) + "")) {
                this.setHorizontalAlignment(0);
                this.setBorderPainted(true);
            }
            this.resolveValues();
            Object value = UIControlUtil.getBeanValue(this);
            boolean selected = this.resolveValue(value);
            this.setSelected(selected);
        }
        catch (Exception e) {
            this.setSelected(false);
            if (ClientContext.getCurrentContext().isDebugMode()) {
                e.printStackTrace();
            }
        }
        finally {
            this.itemHandler.enabled = true;
        }
    }

    @Override
    public void load() {
        this.resolveValues();
        this.removeItemListener(this.itemHandler);
        this.itemHandler.enabled = true;
        this.addItemListener(this.itemHandler);
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    private void resolveValues() {
        if (this.checkValue == null || this.uncheckValue == null) {
            this.checkValue = true;
            this.uncheckValue = false;
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnemonic", Character.valueOf((char)this.getMnemonic()));
        map.put("checkValue", this.getCheckValue());
        map.put("uncheckValue", this.getUncheckValue());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    private boolean resolveValue(Object value) {
        boolean selected = false;
        if (value != null) {
            if (value != null && this.checkValue != null && this.checkValue.equals(value)) {
                selected = true;
            } else if ((this.checkValue + "").equals(value + "")) {
                selected = true;
            } else if ("true".equals(value + "")) {
                selected = true;
            } else if ("yes".equals(value + "")) {
                selected = true;
            } else if ("t".equals(value + "")) {
                selected = true;
            } else if ("y".equals(value + "")) {
                selected = true;
            } else if ("1".equals(value + "")) {
                selected = true;
            }
        }
        return selected;
    }

    @Override
    public Object getValue() {
        return this.isSelected() ? this.getCheckValue() : this.getUncheckValue();
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setSelected(false);
        } else if (value instanceof EventObject) {
            this.refresh();
            this.setSelected(!this.isSelected());
        } else {
            boolean selected = false;
            if (value != null && this.checkValue != null && this.checkValue.equals(value)) {
                selected = true;
            } else if ((this.checkValue + "").equals(value + "")) {
                selected = true;
            } else if ("true".equals(value + "")) {
                selected = true;
            } else if ("1".equals(value + "")) {
                selected = true;
            }
            UIInputUtil.updateBeanValue(this, false, false);
            this.setSelected(selected);
        }
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public boolean isNullWhenEmpty() {
        return false;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public Object getCheckValue() {
        return this.checkValue;
    }

    public void setCheckValue(Object checkValue) {
        if (!Beans.isDesignTime() && this.isExpression(checkValue)) {
            checkValue = UIControlUtil.evaluateExpr(this.binding.getBean(), checkValue + "");
        }
        this.checkValue = checkValue;
    }

    public Object getUncheckValue() {
        return this.uncheckValue;
    }

    public void setUncheckValue(Object uncheckValue) {
        if (!Beans.isDesignTime() && this.isExpression(uncheckValue)) {
            uncheckValue = UIControlUtil.evaluateExpr(this.binding.getBean(), uncheckValue + "");
        }
        this.uncheckValue = uncheckValue;
    }

    private boolean isExpression(Object exp) {
        if (exp == null || !(exp instanceof String)) {
            return false;
        }
        String expr = exp.toString();
        if (expr.matches(".*#\\{[^\\{\\}]+\\}.*")) {
            return true;
        }
        return expr.matches(".*\\$\\{[^\\{\\}]+\\}.*");
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        super.setEnabled(!readonly);
        super.firePropertyChange("enabled", readonly, !readonly);
        this.repaint();
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
        if (info == null) {
            return;
        }
        PropertyInfoWrapper pi = new PropertyInfoWrapper(info);
        this.valueType = pi.getValueType();
        this.setCheckValue(pi.getCheckValue());
        this.setUncheckValue(pi.getUncheckValue());
    }

    @Override
    public void setMnemonic(char mnemonic) {
        super.setMnemonic(mnemonic);
        this.resolveDisplayMnemonic();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resolveDisplayMnemonic();
    }

    private void resolveDisplayMnemonic() {
        char mnemonic = (char)this.getMnemonic();
        if (mnemonic == '\u0000') {
            return;
        }
        String text = this.getText();
        if (text == null) {
            return;
        }
        String stext = text.toLowerCase();
        if (!stext.trim().matches("<html>.*</html>")) {
            return;
        }
        char cval = Character.toLowerCase(mnemonic);
        Pattern p = Pattern.compile("<.*?>");
        Matcher m = p.matcher(text);
        int startindex = 0;
        int locIndex = -1;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (start > startindex) {
                char[] chars = stext.substring(startindex, start).toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] != cval) continue;
                    locIndex = startindex + i;
                    break;
                }
            }
            if (locIndex >= 0) break;
            startindex = end;
        }
        if (locIndex < 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(text.substring(0, locIndex));
        sb.append("<u>" + text.charAt(locIndex) + "</u>");
        sb.append(text.substring(locIndex + 1));
        super.setText(sb.toString());
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    private class PropertyInfoWrapper {
        private PropertySupport.CheckBoxPropertyInfo property;
        private Map map = new HashMap();

        PropertyInfoWrapper(PropertySupport.PropertyInfo info) {
            if (info instanceof Map) {
                this.map = (Map)((Object)info);
            }
            if (info instanceof PropertySupport.CheckBoxPropertyInfo) {
                this.property = (PropertySupport.CheckBoxPropertyInfo)info;
            }
        }

        public Class getValueType() {
            Object value = this.map.get("valueType");
            if (value == null && this.property != null) {
                value = this.property.getValueType();
            }
            return this.property == null ? Boolean.class : (Class)value;
        }

        public Object getCheckValue() {
            Object value = this.map.get("checkValue");
            if (value == null && this.property != null) {
                value = this.property.getCheckValue();
            }
            return value;
        }

        public Object getUncheckValue() {
            Object value = this.map.get("uncheckValue");
            if (value == null && this.property != null) {
                value = this.property.getUncheckValue();
            }
            return value;
        }
    }

    private class ItemListenerImpl
    implements ItemListener {
        boolean enabled = true;
        private boolean processing;

        private ItemListenerImpl() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!XCheckBox.this.isEnabled()) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            if (this.processing) {
                return;
            }
            try {
                this.processing = true;
                UIInputUtil.updateBeanValue(XCheckBox.this);
            }
            catch (Exception exception) {
            }
            finally {
                this.processing = false;
            }
        }
    }
}

