/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.AsyncAction;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PopupMenuOpener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UICommand;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.util.UICommandUtil;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class XButton
extends JButton
implements UICommand,
ActionListener,
ActiveControl,
MouseEventSupport.ComponentInfo {
    private int index;
    private String[] depends;
    private Binding binding;
    private boolean immediate;
    private boolean update;
    private boolean defaultCommand;
    private boolean autoRefresh = true;
    private String expression;
    private String target;
    private ControlProperty property = new ControlProperty();
    private Map params = new HashMap();
    private String permission;
    private String visibleWhen;
    private String disableWhen;
    private String iconResource;
    private String accelerator;
    private KeyStroke acceleratorKS;
    private MouseEventSupport mouseSupport;
    private int stretchWidth;
    private int stretchHeight;
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private JPopupMenu popup;

    public XButton() {
        this.setOpaque(false);
        this.addActionListener(this);
        this.mouseSupport = new MouseEventSupport(this);
        this.mouseSupport.install();
    }

    @Override
    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(String accelerator) {
        this.accelerator = accelerator;
        try {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(accelerator));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setAcceleratorKey(KeyStroke ks) {
        if (this.acceleratorKS != null) {
            this.unregisterKeyboardAction(this.acceleratorKS);
        }
        this.acceleratorKS = ks;
        if (this.acceleratorKS != null) {
            this.registerKeyboardAction(this, this.acceleratorKS, 2);
        }
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String getActionName() {
        return this.getName();
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Override
    public boolean isDefaultCommand() {
        return this.defaultCommand;
    }

    public void setDefaultCommand(boolean defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.setText(expression);
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public String getDisableWhen() {
        return this.disableWhen;
    }

    public void setDisableWhen(String disableWhen) {
        this.disableWhen = disableWhen;
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
        this.setIcon(ImageIconSupport.getInstance().getIcon(iconResource));
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public void setMnemonic(char mnemonic) {
        super.setMnemonic(mnemonic);
        this.resolveDisplayMnemonic();
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resolveDisplayMnemonic();
    }

    private void resolveDisplayMnemonic() {
        char mnemonic = (char)this.getMnemonic();
        if (mnemonic == '\u0000') {
            return;
        }
        String text = this.getText();
        if (text == null) {
            return;
        }
        String stext = text.toLowerCase();
        if (!stext.trim().matches("<html>.*</html>")) {
            return;
        }
        char cval = Character.toLowerCase(mnemonic);
        Pattern p = Pattern.compile("<.*?>");
        Matcher m = p.matcher(text);
        int startindex = 0;
        int locIndex = -1;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            if (start > startindex) {
                char[] chars = stext.substring(startindex, start).toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] != cval) continue;
                    locIndex = startindex + i;
                    break;
                }
            }
            if (locIndex >= 0) break;
            startindex = end;
        }
        if (locIndex < 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(text.substring(0, locIndex));
        sb.append("<u>" + text.charAt(locIndex) + "</u>");
        sb.append(text.substring(locIndex + 1));
        super.setText(sb.toString());
    }

    @Override
    public void refresh() {
        String exprstr = this.getExpression();
        if (!ValueUtil.isEmpty((Object)exprstr)) {
            Object result = UIControlUtil.evaluateExpr(this.binding.getBean(), this.expression);
            this.setText(result == null ? "" : result.toString());
        }
        if (!ValueUtil.isEmpty((Object)(exprstr = this.getVisibleWhen()))) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), this.visibleWhen);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!result) {
                this.setVisible(false);
            } else if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
        if (!ValueUtil.isEmpty((Object)(exprstr = this.getDisableWhen()))) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), this.disableWhen);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!result) {
                this.setEnabled(true);
            } else if (this.isEnabled()) {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void load() {
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object outcome;
        boolean shiftDown;
        boolean ctrlDown = (e.getModifiers() & 2) == 2;
        boolean bl = shiftDown = (e.getModifiers() & 1) == 1;
        if (ctrlDown && shiftDown) {
            this.mouseSupport.showComponentInfo();
            return;
        }
        if (!this.isFocusable()) {
            this.commitFocusOwner();
        }
        if ((outcome = UICommandUtil.processAction(this)) instanceof PopupMenuOpener) {
            PopupMenuOpener menu = (PopupMenuOpener)outcome;
            List items = menu.getItems();
            if (items == null || items.isEmpty()) {
                return;
            }
            if (items.size() == 1 && menu.isExecuteOnSingleResult()) {
                Object o = menu.getFirst();
                if (o instanceof Opener) {
                    UICommandUtil.processAction((JComponent)this, this.getBinding(), (Opener)o);
                } else {
                    ((Action)o).execute();
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        XButton.this.show((PopupMenuOpener)outcome);
                    }
                });
            }
        } else if (outcome instanceof AsyncAction) {
            ExecutorService exec = null;
            try {
                exec = Executors.newSingleThreadExecutor();
                exec.submit((AsyncAction)outcome);
            }
            finally {
                try {
                    if (exec != null) {
                        exec.shutdown();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void commitFocusOwner() {
        Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (fo == null || !fo.isEnabled()) {
            return;
        }
        if (!(fo instanceof UIInput)) {
            return;
        }
        UIInput ui = (UIInput)((Object)fo);
        if (ui.isReadonly()) {
            return;
        }
        if (fo instanceof JTextComponent) {
            JTextComponent jc = (JTextComponent)fo;
            if (jc.isEditable()) {
                UIInputUtil.updateBeanValue(ui);
            }
        } else if (fo instanceof JToggleButton) {
            UIInputUtil.updateBeanValue(ui);
        } else if (fo instanceof JComboBox) {
            UIInputUtil.updateBeanValue(ui);
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accelerator", this.getAccelerator());
        map.put("mnemonic", Character.valueOf((char)this.getMnemonic()));
        map.put("defaultCommand", this.isDefaultCommand());
        map.put("disableWhen", this.getDisableWhen());
        map.put("expression", this.getExpression());
        map.put("immediate", this.isImmediate());
        map.put("target", this.getTarget());
        map.put("visibleWhen", this.getVisibleWhen());
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    private FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getPreferredFont() {
        Font baseFont;
        Font font = baseFont = this.sourceFont == null ? super.getFont() : this.sourceFont;
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    protected void show(PopupMenuOpener menu) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        } else {
            this.popup.setVisible(false);
        }
        this.popup.removeAll();
        for (Object o : menu.getItems()) {
            ActionMenuItem ami = null;
            ami = o instanceof Opener ? new ActionMenuItem((Opener)o) : new ActionMenuItem((Action)o);
            Dimension dim = ami.getPreferredSize();
            ami.setPreferredSize(new Dimension(Math.max(dim.width, 100), dim.height));
            this.popup.add(ami);
        }
        this.popup.pack();
        Rectangle rect = this.getBounds();
        this.popup.show(this, 0, rect.height);
        this.popup.requestFocus();
    }

    private String getVisibleWhen(Object item) {
        if (item instanceof Opener) {
            Opener op = (Opener)item;
            Object val = op.getProperties().get("visibleWhen");
            return val == null ? null : val.toString();
        }
        if (item instanceof Action) {
            Action act = (Action)item;
            return act.getVisibleWhen();
        }
        return null;
    }

    private class ActionMenuItem
    extends JMenuItem {
        XButton root;
        private Object source;

        ActionMenuItem(Opener anOpener) {
            this.root = XButton.this;
            this.source = anOpener;
            this.setText(anOpener.getCaption());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeOpener(e);
                }
            });
            Object ov = anOpener.getProperties().get("mnemonic");
            if (ov != null && ov.toString().trim().length() > 0) {
                this.setMnemonic(ov.toString().trim().charAt(0));
            }
            if ((ov = anOpener.getProperties().get("icon")) != null && ov.toString().length() > 0) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(ov.toString()));
            }
        }

        ActionMenuItem(Action anAction) {
            this.root = XButton.this;
            this.source = anAction;
            this.setText(anAction.getCaption());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionMenuItem.this.invokeAction(e);
                }
            });
            this.setMnemonic(anAction.getMnemonic());
            String sicon = anAction.getIcon();
            if (sicon != null && sicon.length() > 0) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(sicon));
            }
        }

        void invokeOpener(ActionEvent e) {
            try {
                UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), (Opener)this.source);
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }

        void invokeAction(ActionEvent e) {
            try {
                Object outcome = ((Action)this.source).execute();
                if (outcome instanceof Opener) {
                    UICommandUtil.processAction((JComponent)this.root, this.root.getBinding(), (Opener)outcome);
                }
            }
            catch (Exception ex) {
                MsgBox.err(ex);
            }
        }
    }
}

