/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.control.GroupClass;
import com.rameses.rcp.control.GroupMember;
import com.rameses.rcp.control.XButton;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;

class Member
extends XButton
implements MouseListener {
    private String str;
    private GroupClass gc;
    private GroupMember gm;
    private Color enterColor;
    private String sel = "#438fda";
    private String unsel = "#0066cc";
    private String fontSize = "8px";

    public Member() {
        Insets insets = this.getBorder().getBorderInsets(this);
        this.setBorder(BorderFactory.createEmptyBorder(insets.top, 7, insets.bottom, insets.right));
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.addMouseListener(this);
    }

    public void setGroupClass(GroupClass gc) {
        this.gc = gc;
        this.enterColor = gc.getEnterColor();
    }

    public void setGroupMember(GroupMember gm) {
        this.gm = gm;
    }

    @Override
    public void setCaption(String caption) {
        this.str = caption;
        this.setText(this.buildTitle("<b", "</b>", this.unsel, this.fontSize, this.str));
    }

    public String buildTitle(String startTag, String endTag, String color, String fontSize, String title) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(startTag);
        sb.append(" style='color:");
        sb.append(color);
        sb.append(";font-size:");
        sb.append(fontSize);
        sb.append(";'>");
        sb.append(title);
        sb.append(endTag);
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.gc.setBorder(BorderFactory.createLineBorder(this.enterColor));
        this.setText(this.buildTitle("<b", "</b>", this.sel, this.fontSize, this.str));
        this.gm.setTitle(this.buildTitle("<u><b", "</b></u>", this.gm.getSelColor(), this.gm.getFontSize(), this.gm.getTitle()));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.gc.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setText(this.buildTitle("<b", "</b>", this.unsel, this.fontSize, this.str));
        this.gm.setTitle(this.buildTitle("<b", "</b>", this.gm.getUnselColor(), this.gm.getFontSize(), this.gm.getTitle()));
    }
}

