/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.control.XButton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;

class IconButton
extends XButton {
    private boolean clicked = false;
    private boolean entered = false;
    private boolean pressed = false;
    private Color bgColor = new Color(246, 246, 241, 255);
    private Color borderColor = Color.LIGHT_GRAY;
    private Color pressedColor = new Color(228, 227, 220, 255);
    private Color pressedShadeColor = Color.LIGHT_GRAY;
    private Color pressedBorderColor = new Color(157, 157, 146, 255);
    private Color pressedOffsetColor = Color.WHITE;
    private Color transparent = new Color(246, 246, 241, 0);
    private GradientPaint gradient;
    private GradientPaint rightGradient;

    public IconButton() {
        this.addMouseListener(new MouseSupport());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        int x = 0;
        int y = 0;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(0.5f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.entered) {
            this.gradient = new GradientPaint(0.0f, height - 5, this.bgColor, 0.0f, height - 1, this.borderColor);
            this.rightGradient = new GradientPaint(width - 4, 0.0f, this.transparent, width - 1, 0.0f, this.borderColor);
            g2.setPaint(this.gradient);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            g2.setPaint(this.rightGradient);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            g2.setPaint(null);
            g2.setColor(this.borderColor);
            g2.drawRoundRect(x, y, width - 1, height - 1, 7, 7);
        }
        if (this.pressed) {
            this.gradient = new GradientPaint(0.0f, 0.0f, this.pressedShadeColor, 0.0f, 4.0f, this.pressedColor);
            this.rightGradient = new GradientPaint(0.0f, 0.0f, this.pressedShadeColor, 4.0f, 0.0f, this.transparent);
            g2.setPaint(null);
            g2.setColor(this.pressedColor);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            g2.setPaint(this.gradient);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            g2.setPaint(this.rightGradient);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            this.gradient = new GradientPaint(0.0f, height - 4, this.transparent, 0.0f, height - 1, this.pressedOffsetColor);
            this.rightGradient = new GradientPaint(width - 3, 0.0f, this.transparent, width - 1, 0.0f, this.pressedOffsetColor);
            g2.setPaint(this.gradient);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            g2.setPaint(this.rightGradient);
            g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(this.pressedBorderColor);
            g2.drawRoundRect(x, y, width - 1, height - 1, 7, 7);
        }
        super.paintComponent(g);
        g2.dispose();
    }

    private class ButtonBorder
    extends AbstractBorder {
        private ButtonBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setStroke(new BasicStroke(0.5f));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (IconButton.this.entered) {
                IconButton.this.gradient = new GradientPaint(0.0f, height - 6, IconButton.this.transparent, 0.0f, height - 1, IconButton.this.borderColor);
                IconButton.this.rightGradient = new GradientPaint(width - 4, 0.0f, IconButton.this.transparent, width - 1, 0.0f, IconButton.this.borderColor);
                g2.setPaint(IconButton.this.gradient);
                g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
                g2.setPaint(IconButton.this.rightGradient);
                g2.fillRoundRect(x, y, width - 1, height - 1, 7, 7);
                g2.setPaint(null);
                g2.setColor(IconButton.this.borderColor);
                g2.drawRoundRect(x, y, width - 1, height - 1, 7, 7);
            }
            g2.dispose();
            super.paintBorder(c, g, x, y, width, height);
        }
    }

    private class MouseSupport
    implements MouseListener {
        private MouseSupport() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IconButton.this.clicked = true;
            IconButton.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            IconButton.this.pressed = true;
            IconButton.this.clicked = false;
            IconButton.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            IconButton.this.pressed = false;
            IconButton.this.clicked = false;
            IconButton.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            IconButton.this.entered = true;
            IconButton.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IconButton.this.clicked = false;
            IconButton.this.entered = false;
            IconButton.this.repaint();
        }
    }
}

