/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Action;
import com.rameses.rcp.control.GroupClass;
import com.rameses.rcp.control.Member;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class GroupMember
extends JPanel {
    private JLabel title;
    private String desc;
    private String sel = "#15b84f";
    private String unsel = "#006e12";
    private String fontSize = "12px";
    private int showOnly = 5;
    private JButton additAction = new JButton("show more...");
    private JPanel additCont = new JPanel();
    private JPanel members = new JPanel();
    private List<Action> actions;
    private JPanel panel = new JPanel();

    public GroupMember(final List memberList, List<Action> actions, final String desc, final GroupClass gc) {
        this.desc = desc;
        this.actions = actions;
        this.title = new JLabel(this.buildTitle("<b", "</b>", this.unsel, this.fontSize, desc));
        this.title.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GroupMember.this.title.setText(GroupMember.this.buildTitle("<u><b", "</b></u>", GroupMember.this.sel, GroupMember.this.fontSize, desc));
                gc.setBorder(BorderFactory.createLineBorder(gc.getEnterColor()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GroupMember.this.title.setText(GroupMember.this.buildTitle("<b", "</b>", GroupMember.this.unsel, GroupMember.this.fontSize, desc));
                gc.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        this.members.setLayout(new BoxLayout(this.members, 3));
        this.additCont.setLayout(new FlowLayout(0));
        this.additAction.setBorderPainted(false);
        this.additAction.setContentAreaFilled(false);
        this.additAction.setFocusPainted(false);
        this.additAction.setForeground(Color.red);
        this.additAction.setFont(new Font(this.getFont().getName(), 0, 10));
        this.additAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int size = memberList.size();
                if (memberList.size() > GroupMember.this.showOnly) {
                    size = GroupMember.this.showOnly;
                }
                if (GroupMember.this.additAction.getText().equals("show more...")) {
                    GroupMember.this.additAction.setText("hide");
                    GroupMember.this.buildMembers(memberList.size(), memberList.size(), gc);
                } else {
                    GroupMember.this.additAction.setText("show more...");
                    GroupMember.this.buildMembers(memberList.size(), size, gc);
                }
                GroupMember.this.additAction.setFont(new Font(GroupMember.this.getFont().getName(), 0, 10));
                GroupMember.this.additAction.repaint();
                GroupMember.this.members.repaint();
            }
        });
        this.additAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GroupMember.this.additAction.setFont(new Font(GroupMember.this.getFont().getName(), 1, 10));
                GroupMember.this.additAction.repaint();
                GroupMember.this.title.setText(GroupMember.this.buildTitle("<u><b", "</b></u>", GroupMember.this.sel, GroupMember.this.fontSize, desc));
                gc.setBorder(BorderFactory.createLineBorder(gc.getEnterColor()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GroupMember.this.additAction.setFont(new Font(GroupMember.this.getFont().getName(), 0, 10));
                GroupMember.this.additAction.repaint();
                GroupMember.this.title.setText(GroupMember.this.buildTitle("<b", "</b>", GroupMember.this.unsel, GroupMember.this.fontSize, desc));
                gc.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
        int size = memberList.size();
        if (memberList.size() > this.showOnly) {
            size = this.showOnly;
        }
        if (memberList.size() > this.showOnly) {
            this.additCont.add(this.additAction);
        }
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                gc.setBorder(BorderFactory.createLineBorder(gc.getEnterColor()));
                GroupMember.this.title.setText(GroupMember.this.buildTitle("<u><b", "</b></u>", GroupMember.this.sel, GroupMember.this.fontSize, desc));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                gc.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                GroupMember.this.title.setText(GroupMember.this.buildTitle("<b", "</b>", GroupMember.this.unsel, GroupMember.this.fontSize, desc));
            }
        });
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.members, "North");
        this.panel.add((Component)this.additCont, "Center");
        this.buildMembers(memberList.size(), size, gc);
        this.setLayout(new BorderLayout());
        this.add((Component)this.title, "North");
        this.add((Component)this.panel, "Center");
    }

    private void buildMembers(int memberSize, int size, GroupClass gc) {
        this.panel.removeAll();
        this.members.removeAll();
        this.members.setLayout(new BoxLayout(this.members, 3));
        for (int i = 0; i < size; ++i) {
            Member btn = new Member();
            Action action = this.actions.get(i);
            btn.setHorizontalTextPosition(2);
            btn.setHorizontalAlignment(2);
            btn.setCaption(action.getCaption());
            btn.setIndex(action.getIndex());
            btn.setPermission(action.getPermission());
            btn.setParams(action.getParams());
            btn.setGroupClass(gc);
            btn.setGroupMember(this);
            if (!action.getClass().getName().equals(Action.class.getName())) {
                btn.putClientProperty(Action.class.getName(), action);
            }
            this.members.add(btn);
        }
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.members, "North");
        this.panel.add((Component)this.additCont, "Center");
        this.revalidate();
        this.repaint();
    }

    public String buildTitle(String startTag, String endTag, String color, String fontSize, String title) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(startTag);
        sb.append(" style='color:");
        sb.append(color);
        sb.append(";font-size:");
        sb.append(fontSize);
        sb.append(";'>");
        sb.append(title);
        sb.append(endTag);
        sb.append("</html>");
        return sb.toString();
    }

    public void setTitle(String desc) {
        this.title.setText(desc);
    }

    public String getTitle() {
        return this.desc;
    }

    public String getSelColor() {
        return this.sel;
    }

    public String getUnselColor() {
        return this.unsel;
    }

    public String getFontSize() {
        return this.fontSize;
    }
}

