/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.Action;
import com.rameses.rcp.control.GroupMember;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class GroupClass
extends JPanel {
    private BufferedImage bi;
    private final Color enterColor = new Color(156, 202, 247);

    public GroupClass(URL imgPath, List list, List<Action> actions, String description) {
        try {
            this.bi = this.resize(ImageIO.read(imgPath));
            JLabel label = new JLabel();
            label.setIcon(new ImageIcon(this.bi));
            label.setVerticalAlignment(1);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            final GroupMember gm = new GroupMember(list, actions, description, this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    GroupClass.this.setBorder(BorderFactory.createLineBorder(GroupClass.this.enterColor));
                    gm.setTitle(GroupClass.this.buildTitle("<u><b", "</b></u>", gm.getSelColor(), gm.getFontSize(), gm.getTitle()));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GroupClass.this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    gm.setTitle(GroupClass.this.buildTitle("<b", "</b>", gm.getUnselColor(), gm.getFontSize(), gm.getTitle()));
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)label, "West");
            this.add(gm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private BufferedImage resize(BufferedImage bi) {
        BufferedImage bit = new BufferedImage(32, 32, 2);
        Graphics g = bit.getGraphics();
        g.drawImage(bi, 0, 0, bit.getWidth(), bit.getHeight(), null);
        return bit;
    }

    public Color getEnterColor() {
        return this.enterColor;
    }

    public String buildTitle(String startTag, String endTag, String color, String fontSize, String title) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append(startTag);
        sb.append(" style='color:");
        sb.append(color);
        sb.append(";font-size:");
        sb.append(fontSize);
        sb.append(";'>");
        sb.append(title);
        sb.append(endTag);
        sb.append("</html>");
        return sb.toString();
    }
}

