/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertyChangeSupport;
import com.rameses.rcp.control.FormItemProperty;
import com.rameses.rcp.control.FormPanelProperty;
import com.rameses.rcp.control.ItemPanel;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FormItemPanel
extends JPanel
implements FormItemProperty {
    private FormPanelPropertySupport formPropertySupport;
    private CustomLayout layout;
    private JLabel lblCaption;
    private String id;
    private PropertyChangeImpl propertyChangeHandler;

    public FormItemPanel(String id) {
        this.id = id;
        this.propertyChangeHandler = new PropertyChangeImpl();
        this.layout = new CustomLayout();
        super.setLayout(this.layout);
        this.lblCaption = new JLabel(" ");
        this.lblCaption.setFont(this.lblCaption.getFont().deriveFont(1));
        this.formPropertySupport = new FormPanelPropertySupport(null);
        super.setOpaque(false);
    }

    @Override
    public final LayoutManager getLayout() {
        return this.layout;
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    public FormPanelProperty getFormPanelProperty() {
        return this.formPropertySupport.getSource();
    }

    public void setFormPanelProperty(FormPanelProperty formProperty) {
        this.formPropertySupport = new FormPanelPropertySupport(formProperty);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCaption() {
        String txt = this.lblCaption.getText();
        if (txt == null || txt.length() == 0 || " ".equals(txt)) {
            return null;
        }
        return txt;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.length() == 0) {
            caption = " ";
        }
        this.lblCaption.setText(caption);
    }

    @Override
    protected final void addImpl(Component comp, Object constraints, int index) {
        int count = this.getComponentCount();
        if (count == 0) {
            super.addImpl(this.lblCaption, "header", index);
        }
        this.onaddImpl(comp, constraints, index);
    }

    protected void onaddImpl(Component comp, Object constraints, int index) {
        ControlProperty cp;
        if (comp instanceof ActiveControl && (cp = ((ActiveControl)((Object)comp)).getControlProperty()) != null) {
            cp.addPropertyChangeListener(this.propertyChangeHandler);
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    public final void remove(int index) {
        super.remove(index);
        ItemPanel ip = this.getLastItem();
        if (ip == null && this.getComponentCount() > 0) {
            super.remove(this.lblCaption);
        }
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        ItemPanel ip = this.getLastItem();
        if (ip == null && this.getComponentCount() > 0) {
            super.remove(this.lblCaption);
        }
    }

    private ItemPanel getLastItem() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!(c instanceof ItemPanel)) continue;
            return (ItemPanel)c;
        }
        return null;
    }

    @Override
    public int getStretchWidth() {
        return 0;
    }

    @Override
    public int getStretchHeight() {
        return 0;
    }

    private class PropertyChangeImpl
    implements PropertyChangeListener {
        private PropertyChangeImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private class CustomLayout
    implements LayoutManager {
        private int DEFAULT_LEFT_SPACING = 10;
        private int DEFAULT_TOP_SPACING = 5;

        private CustomLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int cellSpacing = FormItemPanel.this.formPropertySupport.getCellspacing();
                boolean showCategory = FormItemPanel.this.formPropertySupport.isShowCategory();
                Insets cellPadding = FormItemPanel.this.formPropertySupport.getCellpadding();
                if (cellPadding == null) {
                    cellPadding = new Insets(0, 0, 0, 0);
                }
                int w = 0;
                int h = 0;
                int leftSpacing = 0;
                boolean hasVisibleComponents = false;
                if (showCategory) {
                    Dimension dim = FormItemPanel.this.lblCaption.getPreferredSize();
                    w = dim.width;
                    h = dim.height + this.DEFAULT_TOP_SPACING;
                    leftSpacing = this.DEFAULT_LEFT_SPACING;
                    hasVisibleComponents = true;
                }
                boolean hasItemPanels = false;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible() || !(c instanceof ItemPanel)) continue;
                    if (hasVisibleComponents) {
                        h += cellSpacing;
                    }
                    Dimension dim = c.getPreferredSize();
                    w = Math.max(w, dim.width + leftSpacing);
                    h += dim.height + cellPadding.top + cellPadding.bottom;
                    hasVisibleComponents = true;
                    hasItemPanels = true;
                }
                if (!hasItemPanels) {
                    w = 0;
                    h = 0;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int cellSpacing = FormItemPanel.this.formPropertySupport.getCellspacing();
                boolean showCategory = FormItemPanel.this.formPropertySupport.isShowCategory();
                Insets cellPadding = FormItemPanel.this.formPropertySupport.getCellpadding();
                if (cellPadding == null) {
                    cellPadding = new Insets(0, 0, 0, 0);
                }
                int pWidth = parent.getWidth();
                int pHeight = parent.getHeight();
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = pWidth - (margin.left + margin.right);
                int h = pHeight - (margin.top + margin.bottom);
                int leftSpacing = 0;
                boolean hasVisibleComponents = false;
                if (showCategory) {
                    leftSpacing = this.DEFAULT_LEFT_SPACING;
                    Dimension dim = FormItemPanel.this.lblCaption.getPreferredSize();
                    FormItemPanel.this.lblCaption.setBounds(x, y, w, dim.height);
                    y += dim.height + this.DEFAULT_TOP_SPACING;
                    x += leftSpacing;
                    w -= leftSpacing;
                    hasVisibleComponents = true;
                }
                boolean hasItemPanels = false;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible() || !(c instanceof ItemPanel)) continue;
                    if (hasVisibleComponents) {
                        y += cellSpacing;
                    }
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y += cellPadding.top, w, dim.height);
                    y += cellPadding.bottom + dim.height;
                    hasVisibleComponents = true;
                    hasItemPanels = true;
                }
                if (!hasItemPanels) {
                    FormItemPanel.this.lblCaption.setBounds(-10, -10, 10, 10);
                }
            }
        }
    }

    private class FormPanelPropertySupport
    implements FormPanelProperty {
        private FormPanelProperty property;

        FormPanelPropertySupport(FormPanelProperty property) {
            this.property = property;
        }

        public FormPanelProperty getSource() {
            return this.property;
        }

        @Override
        public int getCellspacing() {
            return this.property == null ? 2 : this.property.getCellspacing();
        }

        @Override
        public Insets getCellpadding() {
            Insets pad;
            Insets insets = pad = this.property == null ? null : this.property.getCellpadding();
            if (pad == null) {
                pad = new Insets(0, 0, 0, 0);
            }
            return pad;
        }

        @Override
        public boolean isShowCategory() {
            boolean b = this.property == null ? false : this.property.isShowCategory();
            return b;
        }

        @Override
        public PropertyChangeSupport getPropertySupport() {
            return this.property == null ? null : this.property.getPropertySupport();
        }
    }
}

