/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public abstract class AbstractUIControl
extends JPanel
implements UIControl,
ActiveControl {
    private Binding binding;
    private String[] depends;
    private int stretchWidth;
    private int stretchHeight;
    private int index;
    private String visibleWhen;
    private ControlProperty property;

    public AbstractUIControl() {
        this.initComponent_0();
    }

    protected abstract void initComponent();

    protected abstract Component getView();

    protected abstract void onLoad();

    protected abstract void onRefresh();

    private void initComponent_0() {
        this.setPreferredSize(new Dimension(100, 50));
        LayoutImpl layout = new LayoutImpl();
        this.setLayout(layout);
        this.initComponent();
        Component view = this.getView();
        if (view != null) {
            this.add(view, "view");
        }
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public final void load() {
        this.onLoad();
    }

    @Override
    public void refresh() {
        block3: {
            try {
                this.onRefresh();
            }
            catch (Throwable t) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block3;
                t.printStackTrace();
            }
        }
        String expr = this.getVisibleWhen();
        if (expr != null && expr.trim().length() > 0) {
            this.setVisible(this.evalBooleanExpr(expr));
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    @Override
    public ControlProperty getControlProperty() {
        if (this.property == null) {
            this.property = new ControlProperty();
        }
        return this.property;
    }

    public String getCaption() {
        return this.getControlProperty().getCaption();
    }

    public void setCaption(String caption) {
        this.getControlProperty().setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.getControlProperty().getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.getControlProperty().setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.getControlProperty().getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.getControlProperty().setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.getControlProperty().getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.getControlProperty().setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.getControlProperty().getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.getControlProperty().setCaptionFontStyle(captionFontStyle);
    }

    public boolean isShowCaption() {
        return this.getControlProperty().isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.getControlProperty().setShowCaption(show);
    }

    public Insets getCellPadding() {
        return this.getControlProperty().getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.getControlProperty().setCellPadding(padding);
    }

    public Object getBean() {
        Binding b = this.getBinding();
        return b == null ? null : b.getBean();
    }

    public Object getBeanProperty(String name) {
        return UIControlUtil.getBeanValue(this.getBinding(), name);
    }

    public boolean evalBooleanExpr(String expr) {
        boolean b;
        block3: {
            if (expr == null || expr.trim().length() == 0) {
                return true;
            }
            Binding binding = this.getBinding();
            Object bean = binding == null ? null : binding.getBean();
            b = false;
            try {
                b = UIControlUtil.evaluateExprBoolean(bean, expr);
            }
            catch (Throwable t) {
                if (!ClientContext.getCurrentContext().isDebugMode()) break block3;
                t.printStackTrace();
            }
        }
        return b;
    }

    private class LayoutImpl
    implements LayoutManager {
        private Component compView;

        private LayoutImpl() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (comp == null) {
                return;
            }
            if (name == null) {
                return;
            }
            if ("view".equals(name)) {
                this.compView = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp != null && this.compView != null && comp.equals(this.compView)) {
                this.compView = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                if (this.compView != null) {
                    Dimension dim = this.compView.getPreferredSize();
                    w = dim.width;
                    h = dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                if (this.compView != null) {
                    this.compView.setBounds(x, y, w, h);
                }
            }
        }
    }
}

