/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.control.webbrowser.BrowserUtil;
import com.rameses.util.ValueUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;

public class WebBrowserModel {
    private URL homeLocation;
    private URL location;
    private int maxHistorySize = 20;
    private Listener listener;
    private Stack<URL> history = new Stack();
    private Stack<URL> forwardHistory = new Stack();

    public WebBrowserModel() {
    }

    public WebBrowserModel(String location) {
        this.setLocation(location);
    }

    public void back() {
        if (!this.history.isEmpty()) {
            this.addForwardHistory(this.location);
            this.location = this.history.pop();
            this.refresh();
        }
    }

    public void forward() {
        if (!this.forwardHistory.isEmpty()) {
            this.addHistory(this.location);
            this.location = this.forwardHistory.pop();
            this.refresh();
        }
    }

    public void refresh() {
        if (this.listener != null) {
            this.listener.refresh();
        }
    }

    public void clear() {
        this.history.clear();
        this.forwardHistory.clear();
        this.location = this.homeLocation;
        this.refresh();
    }

    public void clearCache() {
        this.history.clear();
        this.forwardHistory.clear();
        BrowserUtil.clearCache(this.getCacheContext());
    }

    private void addHistory(URL location) {
        if (location == null) {
            return;
        }
        this.history.push(location);
        if (this.history.size() > this.maxHistorySize) {
            this.history.setSize(this.maxHistorySize);
        }
    }

    private void addForwardHistory(URL location) {
        if (location == null) {
            return;
        }
        this.forwardHistory.push(location);
        if (this.forwardHistory.size() > this.maxHistorySize) {
            this.forwardHistory.setSize(this.maxHistorySize);
        }
    }

    public String getCacheContext() {
        return "CACHE" + this.homeLocation.toExternalForm().hashCode();
    }

    public URL getLocation() {
        return this.location;
    }

    public void setRelativeLocation(String location) {
        try {
            this.setLocation(new URL(this.location, location));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setLocation(String location) {
        try {
            if (location != null) {
                if (location.trim().startsWith("#")) {
                    this.setRelativeLocation(location);
                } else if (location.startsWith("www.")) {
                    this.setLocation(new URL("http://" + location));
                } else {
                    this.setLocation(new URL(location));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLocation(URL location) {
        if (location == null) {
            return;
        }
        if (!ValueUtil.isEqual((Object)this.location, (Object)location)) {
            if (this.location != null) {
                this.addHistory(this.location);
            }
            this.location = location;
            if (this.homeLocation == null) {
                this.homeLocation = this.location;
            }
            this.refresh();
        }
    }

    public boolean isCanBack() {
        return !this.history.isEmpty();
    }

    public boolean isCanForward() {
        return !this.forwardHistory.isEmpty();
    }

    public int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public void setMaxHistorySize(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void refresh();
    }
}

