/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.Task;

public abstract class ScheduledTask
extends Task {
    private long expiryTime;

    public ScheduledTask() {
        if (this.isImmediate()) {
            this.expiryTime = System.currentTimeMillis();
        } else {
            this.restart();
        }
    }

    public abstract long getInterval();

    @Override
    public boolean accept() {
        return System.currentTimeMillis() >= this.expiryTime;
    }

    @Override
    public boolean isEnded() {
        this.restart();
        return false;
    }

    public boolean isImmediate() {
        return false;
    }

    public void restart() {
        this.expiryTime = System.currentTimeMillis() + this.getInterval();
    }
}

