/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.util.AppException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ObjectProxy {
    public static synchronized MetaInfo getMetaInfo(Object source) {
        return new MetaInfo(source);
    }

    public <T> T create(Object source, Class<T> interface0) {
        return this.create(source, interface0, ObjectProxy.class.getClassLoader());
    }

    public <T> T create(Object source, Class<T> interface0, ClassLoader classLoader) {
        InvocationHandlerImpl handler = new InvocationHandlerImpl(source);
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{interface0}, (InvocationHandler)handler);
    }

    private class InvocationHandlerImpl
    implements InvocationHandler {
        private Object source;
        private Class sourceClass;

        InvocationHandlerImpl(Object source) {
            this.source = source;
            this.sourceClass = source.getClass();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return this.sourceClass.toString();
            }
            try {
                Method sourceMethod;
                if (args == null) {
                    args = new Object[]{};
                }
                if ((sourceMethod = this.getCallbackMethod(methodName)) == null) {
                    Class<?>[] argtypes = method.getParameterTypes();
                    sourceMethod = this.sourceClass.getMethod(methodName, argtypes);
                    return sourceMethod.invoke(this.source, args);
                }
                Class<?>[] argtypes = sourceMethod.getParameterTypes();
                Class<?> argtype0 = argtypes[0];
                if (Object[].class == argtype0) {
                    return sourceMethod.invoke(this.source, new Object[]{args});
                }
                return sourceMethod.invoke(this.source, args);
            }
            catch (Throwable t) {
                if (t instanceof AppException) {
                    throw t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t.getMessage(), t);
            }
        }

        private Method getCallbackMethod(String name) {
            Method m2;
            if (name == null) {
                return null;
            }
            try {
                m2 = this.sourceClass.getMethod(name, Object[].class);
                if (m2 != null) {
                    return m2;
                }
            }
            catch (Throwable m2) {
                // empty catch block
            }
            try {
                m2 = this.sourceClass.getMethod(name, Object.class);
                if (m2 != null) {
                    return m2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    public static class MetaInfo {
        private Object source;
        private Class sourceClass;

        MetaInfo(Object source) {
            this.source = source;
            this.sourceClass = source.getClass();
        }

        public Object getSource() {
            return this.source;
        }

        public boolean containsMethod(String name) {
            Method m = this.getMethod(name);
            return m != null;
        }

        public boolean containsMethod(String name, Class[] argtypes) {
            Method m = this.getMethod(name, argtypes);
            return m != null;
        }

        private Method getMethod(String name) {
            Method m2;
            if (name == null) {
                return null;
            }
            try {
                m2 = this.sourceClass.getMethod(name, Object[].class);
                if (m2 != null) {
                    return m2;
                }
            }
            catch (Throwable m2) {
                // empty catch block
            }
            try {
                m2 = this.sourceClass.getMethod(name, Object.class);
                if (m2 != null) {
                    return m2;
                }
            }
            catch (Throwable m3) {
                // empty catch block
            }
            try {
                m2 = this.sourceClass.getMethod(name, new Class[0]);
                if (m2 != null) {
                    return m2;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public Method getMethod(String name, Class[] argtypes) {
            if (name == null) {
                return null;
            }
            if (argtypes == null) {
                argtypes = new Class[]{};
            }
            try {
                Method m = this.sourceClass.getMethod(name, argtypes);
                if (m != null) {
                    return m;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public Object invoke(Method method, Object[] args) {
            try {
                if (args == null) {
                    args = new Object[]{};
                }
                return method.invoke(this.source, args);
            }
            catch (Throwable t) {
                if (t instanceof AppException) {
                    throw (AppException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t.getMessage(), t);
            }
        }
    }
}

