/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.NotificationHandler;
import com.rameses.rcp.framework.NotificationProvider;
import java.util.HashMap;
import java.util.Map;

public final class Notification {
    public static NotificationProvider getProvider() {
        return ClientContext.getCurrentContext().getNotificationProvider();
    }

    public static void sendMessage(Object data) {
        Notification.getProvider().sendMessage(data);
    }

    public static void removeMessage(Object data) {
        Notification.getProvider().removeMessage(data);
    }

    public static RuntimeHandle register(Object callback) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("onmessage", callback);
        return Notification.register(options);
    }

    public static RuntimeHandle register(Map options) {
        if (options == null) {
            options = new HashMap();
        }
        return new RuntimeHandle(options);
    }

    private Notification() {
    }

    private static class HandlerProxy
    implements NotificationHandler {
        private Map options;
        private CallbackHandlerProxy onmessageHandler;
        private CallbackHandlerProxy onreadHandler;
        private CallbackHandlerProxy oncloseHandler;
        private boolean cancelled;

        HandlerProxy(Map options) {
            this.options = options;
            Object source = this.get(options, "onmessage");
            if (source != null) {
                this.onmessageHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onread")) != null) {
                this.onreadHandler = new CallbackHandlerProxy(source);
            }
            if ((source = this.get(options, "onclose")) != null) {
                this.oncloseHandler = new CallbackHandlerProxy(source);
            }
        }

        @Override
        public void onMessage(Object data) {
            if (this.cancelled || this.onmessageHandler == null) {
                return;
            }
            this.onmessageHandler.call(data);
        }

        @Override
        public void onRead(Object data) {
            if (this.cancelled || this.onreadHandler == null) {
                return;
            }
            this.onreadHandler.call(data);
        }

        public void onClose() {
            if (this.cancelled || this.oncloseHandler == null) {
                return;
            }
            this.oncloseHandler.call();
        }

        private Integer getInt(Map map, String name) {
            try {
                return (Integer)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private String getString(Map map, String name) {
            try {
                Object o = map.get(name);
                return o == null ? null : o.toString();
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Boolean getBool(Map map, String name) {
            try {
                return (Boolean)map.get(name);
            }
            catch (Throwable t) {
                return null;
            }
        }

        private Object get(Map map, String name) {
            return map == null ? null : map.get(name);
        }
    }

    public static class RuntimeHandle {
        private HandlerProxy proxy;

        RuntimeHandle(Map options) {
            this.proxy = new HandlerProxy(options);
            Notification.getProvider().add(this.proxy);
        }

        public void unregister() {
            if (this.proxy == null) {
                return;
            }
            this.proxy.cancelled = true;
            Notification.getProvider().remove(this.proxy);
            this.proxy.onClose();
            this.proxy = null;
        }
    }
}

