/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.NodeListener;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Node {
    private Object item;
    private String id = "NODE" + new UID();
    private String caption;
    private String tooltip;
    private String mnemonic;
    private String icon;
    private boolean dynamic;
    private boolean leaf;
    private boolean loaded;
    private List<NodeListener> listeners = new ArrayList<NodeListener>();
    private Map properties = new HashMap();
    private Provider provider;
    private Node parent;

    public Node() {
        this(null, null, null);
    }

    public Node(String id) {
        this(id, null, null);
    }

    public Node(String id, String caption) {
        this(id, caption, null);
    }

    public Node(String id, String caption, Object item) {
        this.id = this.resolveId(id);
        this.caption = caption;
        this.item = item;
    }

    public Node(Map props) {
        if (props == null || props.isEmpty()) {
            throw new NullPointerException("props parameter is required in the Node object");
        }
        this.update(props);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id == null ? "NODE" + new UID() : id;
    }

    public String getCaption() {
        return this.caption == null ? this.id : this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Object getItem() {
        return this.item;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(String mnemonic) {
        this.mnemonic = mnemonic;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public String getPropertyString(String name) {
        Object o = this.getProperties().get(name);
        return o == null ? null : o.toString();
    }

    public List getPropertyList(String name) {
        Object o = this.getProperties().get(name);
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            Node nn = (Node)obj;
            if (this.getId().equals(nn.getId())) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public void update(Object data) {
        if (data instanceof Map) {
            String sleaf;
            Map map = (Map)data;
            this.properties.putAll(map);
            this.item = map;
            this.id = this.resolveId(this.properties);
            this.caption = this.removeString(this.properties, "caption");
            this.mnemonic = this.removeString(this.properties, "mnemonic");
            this.tooltip = this.removeString(this.properties, "tooltip");
            this.icon = this.removeString(this.properties, "icon");
            this.dynamic = "true".equals(this.removeString(this.properties, "dynamic"));
            Object value = this.properties.get("folder");
            if (value != null && "false".equals(value.toString())) {
                this.leaf = true;
            }
            if ((sleaf = this.removeString(this.properties, "leaf")) != null && "true".equals(sleaf)) {
                this.leaf = true;
            }
        }
    }

    private String resolveId(Object data) {
        String oid = null;
        if (data instanceof Map) {
            Map map = (Map)data;
            oid = map.remove("id");
            if (oid == null) {
                oid = map.remove("objid");
            }
            if (oid == null) {
                oid = map.get("name");
            }
        } else if (data != null) {
            oid = data.toString();
        }
        return oid == null ? "NODE" + new UID() : oid.toString();
    }

    public String removeProperty(Object name) {
        Object value = this.properties == null ? null : (Object)this.properties.remove(name);
        return value == null ? null : value.toString();
    }

    private String getString(Map props, String name) {
        Object value = props.get(name);
        return value == null ? null : value.toString();
    }

    private String removeString(Map props, String name) {
        Object value = props.remove(name);
        return value == null ? null : value.toString();
    }

    private int removeInt(Map props, String name) {
        try {
            return Integer.parseInt(props.get(name).toString());
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public void addListener(NodeListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(NodeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void reload() {
        Provider provider = this.getProvider();
        if (provider != null) {
            provider.reload();
        }
        for (NodeListener nl : this.listeners) {
            nl.reload();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.properties.clear();
        this.properties = null;
        this.listeners.clear();
        this.listeners = null;
        this.item = null;
    }

    public int getIndex() {
        Provider provider = this.getProvider();
        return provider == null ? -1 : provider.getIndex();
    }

    public boolean hasItems() {
        Provider provider = this.getProvider();
        return provider == null ? false : provider.hasItems();
    }

    public void loadItems() {
        Provider provider = this.getProvider();
        if (provider != null) {
            provider.loadItems();
        }
    }

    public void reloadItems() {
        Provider provider = this.getProvider();
        if (provider != null) {
            provider.reloadItems();
        }
    }

    public List<Node> getItems() {
        Provider provider = this.getProvider();
        return provider == null ? null : provider.getItems();
    }

    public void select() {
        Provider provider = this.getProvider();
        if (provider != null) {
            provider.select();
        }
    }

    public Object open() {
        Provider provider = this.getProvider();
        return provider == null ? null : provider.open();
    }

    public void refresh() {
        Provider provider = this.getProvider();
        if (provider != null) {
            provider.refresh();
        }
    }

    public void remove() {
        Provider provider = this.getProvider();
        if (provider != null) {
            provider.remove();
        }
    }

    public static interface Provider {
        public int getIndex();

        public boolean hasItems();

        public void loadItems();

        public void reloadItems();

        public List<Node> getItems();

        public void select();

        public Object open();

        public void refresh();

        public void reload();

        public void remove();
    }
}

