/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.MsgBox;
import java.util.ArrayList;
import java.util.List;

public class ListItem
implements Cloneable {
    public static final int STATE_EMPTY = 0;
    public static final int STATE_SYNC = 1;
    public static final int STATE_DRAFT = 2;
    public static final int STATE_EDIT = 3;
    private HandlerSupport handlerSupport = new HandlerSupport();
    private boolean selected;
    private Object item;
    private int state = 0;
    private int index;
    private int rownum;
    private Object root;

    public void removeHandler(Handler handler) {
        this.handlerSupport.remove(handler);
    }

    public void addHandler(Handler handler) {
        this.handlerSupport.add(handler);
    }

    public ListItem clone() {
        ListItem item = new ListItem();
        item.item = this.item;
        item.state = this.state;
        item.index = this.index;
        item.rownum = this.rownum;
        item.selected = this.selected;
        item.root = this.root;
        return item;
    }

    public boolean equals(Object obj) {
        return obj != null && this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.handlerSupport.getClass().getName().hashCode() + this.rownum;
    }

    public final void loadItem(Object item) {
        this.item = item;
    }

    public final void loadItem(Object item, int state) {
        this.setState(state);
        this.item = item;
        this.state = state;
    }

    public final Object getItem() {
        return this.item;
    }

    public final void setItem(Object newItem) {
        if (this.item == null && newItem == null) {
            return;
        }
        if (this.item != null && this.item.equals(newItem)) {
            return;
        }
        try {
            this.handlerSupport.replaceSelectedItem(this, newItem);
            this.item = newItem;
            this.state = 1;
            this.handlerSupport.refreshItemUpdated(this);
        }
        catch (Exception e) {
            MsgBox.err(e);
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.stateCheck(state);
        this.state = state;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getRownum() {
        return this.rownum;
    }

    public void setRownum(int rowindex) {
        this.rownum = rowindex;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = this.item == null ? false : selected;
        this.handlerSupport.setSelected(this, this.selected);
    }

    public final Object getRoot() {
        return this.root;
    }

    public final void setRoot(Object root) {
        this.root = root;
    }

    protected void finalize() throws Throwable {
        this.handlerSupport.removeAll();
        this.item = null;
    }

    private void stateCheck(int state) {
        switch (state) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state value for ListItem");
            }
        }
    }

    public boolean isDirty() {
        return this.getState() == 2 || this.getState() == 3;
    }

    public static interface Handler {
        public void setSelected(ListItem var1, boolean var2);

        public void replaceSelectedItem(ListItem var1, Object var2);

        public void refreshItemUpdated(ListItem var1);
    }

    private class HandlerSupport
    implements Handler,
    Cloneable {
        private List<Handler> handlers = new ArrayList<Handler>();

        private HandlerSupport() {
        }

        void removeAll() {
            this.handlers.clear();
        }

        void remove(Handler handler) {
            if (handler != null) {
                this.handlers.remove(handler);
            }
        }

        void add(Handler handler) {
            if (handler != null && !this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
        }

        public HandlerSupport clone() {
            HandlerSupport hs = new HandlerSupport();
            for (Handler handler : this.handlers) {
                hs.handlers.add(handler);
            }
            return hs;
        }

        @Override
        public void setSelected(ListItem li, boolean selected) {
            for (Handler handler : this.handlers) {
                handler.setSelected(li, selected);
            }
        }

        @Override
        public void replaceSelectedItem(ListItem li, Object data) {
            for (Handler handler : this.handlers) {
                handler.replaceSelectedItem(li, data);
            }
        }

        @Override
        public void refreshItemUpdated(ListItem li) {
            for (Handler handler : this.handlers) {
                handler.refreshItemUpdated(li);
            }
        }
    }
}

