/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.CallbackHandlerProxy;
import com.rameses.rcp.common.MsgBox;

public final class EventQueue {
    public static void invokeLater(Object callback) {
        EventQueue.invokeLater(callback, null);
    }

    public static void invokeLater(Object callback, Object value) {
        if (callback == null) {
            return;
        }
        EventQueue.invokeLater(new CallbackRunnable(callback, value));
    }

    public static void invokeLater(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        java.awt.EventQueue.invokeLater(runnable);
    }

    private EventQueue() {
    }

    private static class CallbackRunnable
    implements Runnable {
        private Object callback;
        private Object value;

        CallbackRunnable(Object callback, Object value) {
            this.callback = callback;
            this.value = value;
        }

        @Override
        public void run() {
            try {
                if (this.callback == null) {
                    return;
                }
                new CallbackHandlerProxy(this.callback).call(this.value);
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }
}

