/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.PropertySupport;

public class DecimalColumnHandler
extends Column.TypeHandler
implements PropertySupport.DecimalPropertyInfo {
    private static final long serialVersionUID = 1L;
    private String format;
    private int scale = 2;
    private double minValue;
    private double maxValue;
    private boolean usePrimitiveValue;

    public DecimalColumnHandler() {
        this("#,##0.00");
    }

    public DecimalColumnHandler(String format) {
        this(format, -1.0, -1.0, false);
    }

    public DecimalColumnHandler(String format, double minValue, double maxValue, boolean usePrimitiveValue) {
        this(format, minValue, maxValue, usePrimitiveValue, 2);
    }

    public DecimalColumnHandler(String format, double minValue, double maxValue, boolean usePrimitiveValue, int scale) {
        this.format = format;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.usePrimitiveValue = usePrimitiveValue;
        this.scale = scale;
    }

    @Override
    public String getType() {
        return "decimal";
    }

    @Override
    public String getFormat() {
        Object value = super.get("format");
        if (value == null) {
            value = this.format;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public int getScale() {
        Object value = super.get("scale");
        if (value == null) {
            return this.scale;
        }
        Integer o = this.convertInteger(value);
        return o == null ? this.scale : o;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public boolean isUsePrimitiveValue() {
        Boolean bool;
        Object value = super.get("usePrimitiveValue");
        if (value == null) {
            value = this.usePrimitiveValue;
        }
        return (bool = this.convertBoolean(value)) == null ? false : bool;
    }

    @Override
    public void setUsePrimitiveValue(boolean usePrimitiveValue) {
        this.usePrimitiveValue = usePrimitiveValue;
    }

    @Override
    public double getMinValue() {
        Number num;
        Object value = super.get("minValue");
        if (value == null) {
            value = this.minValue;
        }
        return (num = this.convertDouble(value)) == null ? -1.0 : num.doubleValue();
    }

    @Override
    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    @Override
    public double getMaxValue() {
        Number num;
        Object value = super.get("maxValue");
        if (value == null) {
            value = this.maxValue;
        }
        return (num = this.convertDouble(value)) == null ? -1.0 : num.doubleValue();
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    protected Number convertDouble(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Boolean convertBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            return Boolean.parseBoolean(value.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Integer convertInteger(Object value) {
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return new Integer(((Number)value).intValue());
            }
            return new Integer(value.toString());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

