/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.PropertySupport;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateColumnHandler
extends Column.TypeHandler
implements PropertySupport.DatePropertyInfo {
    private static final long serialVersionUID = 1L;
    private String inputFormat;
    private String outputFormat;
    private String valueFormat;
    private Map<String, SimpleDateFormat> formatters = new HashMap<String, SimpleDateFormat>();

    public DateColumnHandler() {
    }

    public DateColumnHandler(String inputFormat, String outputFormat, String valueFormat) {
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.valueFormat = valueFormat;
    }

    @Override
    public String getType() {
        return "date";
    }

    @Override
    public String getInputFormat() {
        Object value = super.get("inputFormat");
        if (value == null) {
            value = this.inputFormat;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    public String getOutputFormat() {
        Object value = super.get("outputFormat");
        if (value == null) {
            value = this.outputFormat;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Override
    public String getValueFormat() {
        Object value = super.get("valueFormat");
        if (value == null) {
            value = this.valueFormat;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object val = super.get(key);
        if (val != null) {
            return val;
        }
        if ("format".equals(key.toString())) {
            return this.getOutputFormat();
        }
        if ("outputFormat".equals(key.toString())) {
            return this.getOutputFormat();
        }
        if ("inputFormat".equals(key.toString())) {
            return this.getInputFormat();
        }
        if ("valueFormat".equals(key.toString())) {
            return this.getValueFormat();
        }
        return null;
    }

    private SimpleDateFormat getFormatter(String pattern) {
        SimpleDateFormat sdf = this.formatters.get(pattern);
        if (sdf == null) {
            sdf = new SimpleDateFormat(pattern);
            this.formatters.put(pattern, sdf);
        }
        return sdf;
    }

    public String format(Object value) {
        return this.format(value, this.getOutputFormat());
    }

    public String format(Object value, String pattern) {
        if (value == null) {
            return null;
        }
        Date dtvalue = this.convertDate(value);
        if (dtvalue == null) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            return dtvalue.toString();
        }
        return this.getFormatter(pattern).format(dtvalue);
    }

    private Date convertDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return Timestamp.valueOf(value.toString());
        }
        catch (Throwable throwable) {
            try {
                return java.sql.Date.valueOf(value.toString());
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

