/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.ScheduledTask;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class CountDownTimer
extends ScheduledTask {
    private final Object LOCKED = new Object();
    private SimpleDateFormat formatter;
    private Calendar timerCal = Calendar.getInstance();
    private long secondsLeft = -1L;
    private boolean executed;
    private boolean paused;

    public CountDownTimer() {
        this.formatter = new SimpleDateFormat(this.getTimeFormat());
    }

    public abstract long getMaxSeconds();

    public abstract void onTimeout();

    public void onProgress() {
    }

    public String getTimeFormat() {
        return "KK:mm:ss";
    }

    @Override
    public final long getInterval() {
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute() {
        Object object = this.LOCKED;
        synchronized (object) {
            if (!this.executed) {
                this.executed = true;
                this.secondsLeft = this.getMaxSeconds();
            }
            --this.secondsLeft;
            this.onProgress();
            if (this.isEnded()) {
                this.onTimeout();
            }
        }
    }

    @Override
    public final boolean accept() {
        return !this.paused;
    }

    @Override
    public final boolean isEnded() {
        return this.executed && this.secondsLeft <= 0L;
    }

    @Override
    public final boolean isImmediate() {
        return true;
    }

    public final long getSecondsLeft() {
        if (!this.executed) {
            return this.getMaxSeconds();
        }
        return this.secondsLeft;
    }

    public final Date getTimeLeft() {
        long curSeconds = this.getSecondsLeft();
        int hours = (int)curSeconds / 60 / 60;
        int mins = (int)(curSeconds / 60L) % 60;
        int secs = (int)curSeconds % 60;
        this.timerCal.set(10, hours);
        this.timerCal.set(12, mins);
        this.timerCal.set(13, secs);
        return this.timerCal.getTime();
    }

    public final String getFormattedTimeLeft() {
        return this.formatter.format(this.getTimeLeft());
    }

    public void reset() {
        this.executed = false;
        this.secondsLeft = -1L;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }
}

