/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.ButtonColumnHandler;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.constant.TextCase;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Column
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String caption;
    private TypeHandler typeHandler;
    private int width = 100;
    private int minWidth;
    private int maxWidth;
    private boolean required;
    private boolean resizable = true;
    private boolean nullWhenEmpty = true;
    private boolean editable;
    private String editableWhen;
    private TextCase textCase = TextCase.UPPER;
    private String type = "string";
    private String expression;
    private String visibleWhen;
    private boolean visible = true;
    private Class fieldType;
    private Object checkValue;
    private Object uncheckValue;
    private Object items;
    private Object handler;
    private String fieldname;
    private int rowheight;
    private boolean primary;
    private boolean htmlDisplay;
    private String format;
    private String alignment;
    private String iconVisibleWhen;
    private String icon;
    private String iconOrientation;
    private String toggleIcon;
    private String headerIcon;
    private String validateExpression;
    private String category;
    private Object action;
    private boolean dynamic;
    private Map properties = new HashMap();

    public Column() {
    }

    public Column(String name, String caption) {
        this(name, caption, null);
    }

    public Column(String name, String caption, TypeHandler typeHandler) {
        this.name = name;
        this.caption = caption;
        this.typeHandler = typeHandler;
    }

    public Column(String name, String caption, int width, int minWidth, int maxWidth, boolean required, boolean resizable, boolean nullWhenEmpty, boolean editable, String editableWhen, TypeHandler typeHandler) {
        this.name = name;
        this.caption = caption;
        this.width = width;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.required = required;
        this.resizable = resizable;
        this.nullWhenEmpty = nullWhenEmpty;
        this.editable = editable;
        this.editableWhen = editableWhen;
        this.typeHandler = typeHandler;
        if (this.typeHandler != null) {
            this.typeHandler.setColumn(this);
        }
    }

    public Column(String name, String caption, String type, Map props) {
        this(name, caption);
        this.type = type;
        if (props != null) {
            this.setProperties(props);
        }
    }

    public Column(String name, String caption, String type, boolean editable, boolean required) {
        this(name, caption, type, null, required);
        this.editable = editable;
    }

    public Column(String name, String caption, String type, Map props, boolean required) {
        this(name, caption, type, props);
        this.required = required;
    }

    public Column(String name, String caption, String type, Map props, int width) {
        this(name, caption, type, props);
        this.width = width;
    }

    public Column(Map data) {
        this.init(data);
    }

    public Column(Object[] dataArray) {
        this.init(dataArray);
    }

    public Column clone() {
        Column col = new Column(this.getName(), this.getCaption());
        col.typeHandler = this.typeHandler;
        col.width = this.width;
        col.minWidth = this.minWidth;
        col.maxWidth = this.maxWidth;
        col.required = this.required;
        col.resizable = this.resizable;
        col.nullWhenEmpty = this.nullWhenEmpty;
        col.editable = this.editable;
        col.editableWhen = this.editableWhen;
        col.properties = this.properties;
        col.alignment = this.alignment;
        col.type = this.type;
        col.visible = this.visible;
        col.textCase = this.textCase;
        col.fieldname = this.fieldname;
        col.rowheight = this.rowheight;
        col.primary = this.primary;
        col.htmlDisplay = this.htmlDisplay;
        col.format = this.format;
        col.fieldType = this.fieldType;
        col.iconVisibleWhen = this.iconVisibleWhen;
        col.icon = this.icon;
        col.iconOrientation = this.iconOrientation;
        col.toggleIcon = this.toggleIcon;
        col.headerIcon = this.headerIcon;
        col.expression = this.expression;
        col.category = this.category;
        col.checkValue = this.checkValue;
        col.uncheckValue = this.uncheckValue;
        col.action = this.action;
        return col;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public TypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(TypeHandler typeHandler) {
        TypeHandler oldTypeHandler = this.typeHandler;
        if (oldTypeHandler != null) {
            oldTypeHandler.setColumn(null);
        }
        this.typeHandler = typeHandler;
        if (this.typeHandler != null) {
            this.typeHandler.setColumn(this);
            this.type = this.typeHandler.getType();
        }
        if (this.type == null) {
            this.type = "string";
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minwidth) {
        this.minWidth = minwidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxwidth) {
        this.maxWidth = maxwidth;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getEditableWhen() {
        return this.editableWhen;
    }

    public void setEditableWhen(String editableWhen) {
        this.editableWhen = editableWhen;
    }

    public TextCase getTextCase() {
        return this.textCase;
    }

    public void setTextCase(TextCase textCase) {
        this.textCase = textCase;
    }

    public void setTextCase(String stextCase) {
        try {
            this.textCase = TextCase.valueOf(stextCase.toUpperCase());
        }
        catch (Exception ex) {
            this.textCase = TextCase.NONE;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public int getRowheight() {
        return this.rowheight;
    }

    public void setRowheight(int rowheight) {
        this.rowheight = rowheight;
    }

    public String getFieldname() {
        if (this.fieldname == null) {
            return this.name;
        }
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isHtmlDisplay() {
        return this.htmlDisplay;
    }

    public void setHtmlDisplay(boolean htmlDisplay) {
        this.htmlDisplay = htmlDisplay;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Object getHandler() {
        return this.handler;
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    public Object getItems() {
        return this.items;
    }

    public void setItems(Object items) {
        this.items = items;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class fieldType) {
        this.fieldType = fieldType;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getHeaderIcon() {
        return this.headerIcon;
    }

    public void setHeaderIcon(String headerIcon) {
        this.headerIcon = headerIcon;
    }

    public String getValidateExpression() {
        return this.validateExpression;
    }

    public void setValidateExpression(String validateExpression) {
        this.validateExpression = validateExpression;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getToggleIcon() {
        return this.toggleIcon;
    }

    public void setToggleIcon(String toggleIcon) {
        this.toggleIcon = toggleIcon;
    }

    public String getIconVisibleWhen() {
        return this.iconVisibleWhen;
    }

    public void setIconVisibleWhen(String iconVisibleWhen) {
        this.iconVisibleWhen = iconVisibleWhen;
    }

    public Object getUncheckValue() {
        return this.uncheckValue;
    }

    public void setUncheckValue(Object uncheckValue) {
        this.uncheckValue = uncheckValue;
    }

    public Object getCheckValue() {
        return this.checkValue;
    }

    public void setCheckValue(Object checkValue) {
        this.checkValue = checkValue;
    }

    public String getIconOrientation() {
        return this.iconOrientation;
    }

    public void setIconOrientation(String iconOrientation) {
        this.iconOrientation = iconOrientation;
    }

    public Object getAction() {
        return this.action;
    }

    public void setAction(Object action) {
        this.action = action;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public final Column set(String name, Object value) {
        try {
            PropertyResolver.getInstance().setProperty((Object)this, name, value);
            return this;
        }
        catch (Exception ex) {
            System.out.println("Unable to set property value on '" + name + "' on Column object");
            return this;
        }
    }

    private void init(Map data) {
        PropertyResolver res = PropertyResolver.getInstance();
        Set entries = data.entrySet();
        for (Map.Entry entry : entries) {
            String key = entry.getKey().toString();
            Object val = entry.getValue();
            res.setProperty((Object)this, key, val);
        }
        this.getProperties().putAll(data);
        try {
            Object otextcase = data.get("textcase");
            this.setTextCase(otextcase == null ? null : otextcase.toString());
        }
        catch (Throwable otextcase) {
            // empty catch block
        }
        if ("button".equals(this.type)) {
            ButtonColumnHandler h = new ButtonColumnHandler();
            h.setVisibleWhen(this.getPropertyString("visibleWhen"));
            h.setTag(this.getPropertyString("tag"));
            Object aa = this.getPropertyString("action");
            if (aa == null) {
                aa = this.action;
            }
            h.setAction(aa == null ? null : aa.toString());
            this.setTypeHandler(h);
        }
    }

    private void init(Object[] dataArray) {
        if (dataArray == null) {
            return;
        }
        PropertyResolver res = PropertyResolver.getInstance();
        for (Object o : dataArray) {
            try {
                Object[] values = (Object[])o;
                res.setProperty((Object)this, values[0].toString(), values[1]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getPropertyString(String name) {
        Object value = this.getProperties().get(name);
        return value == null ? null : value.toString();
    }

    public static abstract class TypeHandler
    extends HashMap
    implements PropertySupport.PropertyInfo {
        private static final long serialVersionUID = 1L;
        private Column column;

        public abstract String getType();

        public final Column getColumn() {
            return this.column;
        }

        void setColumn(Column column) {
            this.column = column;
            this.columnChanged();
        }

        protected void columnChanged() {
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            return this.getType() == o;
        }
    }
}

