/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.BatchProcessingHandler;
import com.rameses.rcp.common.ProgressModel;
import com.rameses.util.BreakException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BatchProcessingModel
implements BatchProcessingHandler {
    private static final Object START_LOCKED = new Object();
    private static final int DEFAULT_ROW_SIZE = 10;
    private static final int MODE_INIT = 0;
    private static final int MODE_PROCESSING = 1;
    private static final int MODE_CANCELLED = 2;
    private static final int MODE_FINISHED = 3;
    private static final int MODE_ERROR = 4;
    private ArrayList<BatchProcessingHandler> handlers = new ArrayList();
    private VarStat stat = new VarStat();
    private RunProc proc;

    public abstract int getTotalCount();

    public abstract List fetchList(Map var1);

    public abstract void processItem(Object var1);

    @Override
    public void onFinished() {
    }

    @Override
    public void onError(Object stat) {
    }

    @Override
    public void onRefresh(Object stat) {
    }

    public void beforeStart() {
    }

    public void beforeCancel() {
    }

    public void afterCancel() {
    }

    public ProgressStatus getStatus() {
        return new ProgressStatus();
    }

    public boolean isAsync() {
        return true;
    }

    public int getRows() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = START_LOCKED;
        synchronized (object) {
            if (this.proc != null) {
                System.out.println("batch processing has already started.");
                return;
            }
            try {
                this.beforeStart();
                this.proc = new RunProc();
                this.proc.init();
            }
            catch (BreakException be) {
                this.proc = null;
                return;
            }
            catch (RuntimeException re) {
                this.proc = null;
                throw re;
            }
            catch (Exception e) {
                this.proc = null;
                throw new RuntimeException(e);
            }
            if (this.isAsync()) {
                new Thread(this.proc).start();
            } else {
                this.proc.run();
            }
        }
    }

    public void cancel() {
        try {
            this.beforeCancel();
        }
        catch (BreakException be) {
            return;
        }
        if (this.proc != null) {
            this.proc.cancel();
        }
        this.proc = null;
        this.afterCancel();
    }

    public void add(BatchProcessingHandler handler) {
        if (handler != null && !this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    public void remove(BatchProcessingHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void removeHandlers() {
        this.handlers.clear();
    }

    private void notifyOnRefresh(Object stat) {
        this.onRefresh(stat);
        for (BatchProcessingHandler h : this.handlers) {
            h.onRefresh(stat);
        }
    }

    private void notifyOnError(Object stat) {
        this.onError(stat);
        for (BatchProcessingHandler h : this.handlers) {
            h.onError(stat);
        }
    }

    private void notifyOnFinished() {
        this.onFinished();
        for (BatchProcessingHandler h : this.handlers) {
            h.onFinished();
        }
    }

    private class RunProc
    implements Runnable {
        BatchProcessingModel root;
        Object[] items;
        boolean cancelled;

        private RunProc() {
            this.root = BatchProcessingModel.this;
        }

        void init() {
            this.items = null;
            this.cancelled = false;
            this.root.stat.init();
        }

        void cancel() {
            this.cancelled = true;
            ((BatchProcessingModel)this.root).stat.mode = 2;
        }

        @Override
        public void run() {
            VarStat stat = this.root.stat;
            ProgressStatus pg = new ProgressStatus();
            try {
                this.items = null;
                this.runImpl(pg);
            }
            catch (Throwable t) {
                stat.mode = 4;
                stat.error = t;
                this.root.notifyOnRefresh(pg);
                this.root.notifyOnError(pg);
            }
        }

        void runImpl(ProgressStatus pg) throws Exception {
            VarStat stat = this.root.stat;
            stat.mode = 1;
            stat.rowLimit = this.root.getRows();
            if (stat.rowLimit <= 0) {
                stat.rowLimit = 10;
            }
            stat.totalCount = this.root.getTotalCount();
            while (this.fetch()) {
                boolean hasmore = this.items.length > stat.rowLimit;
                int count = hasmore ? stat.rowLimit : this.items.length;
                for (int i = 0; i < count && !this.cancelled && stat.startRow < stat.totalCount; ++i) {
                    ++stat.startRow;
                    this.root.processItem(this.items[i]);
                    this.root.notifyOnRefresh(pg);
                }
                if (!this.cancelled && stat.startRow < stat.totalCount) continue;
                break;
            }
            if (this.cancelled) {
                stat.mode = 2;
                this.root.notifyOnRefresh(pg);
                return;
            }
            this.items = null;
            stat.mode = 3;
            this.root.notifyOnRefresh(pg);
            this.root.notifyOnFinished();
        }

        boolean fetch() {
            if (this.cancelled) {
                return false;
            }
            VarStat stat = this.root.stat;
            HashMap<String, Integer> param = new HashMap<String, Integer>();
            param.put("_start", stat.startRow);
            param.put("_limit", stat.rowLimit + 1);
            List list = this.root.fetchList(param);
            this.items = list == null ? null : list.toArray();
            return this.items != null && this.items.length > 0;
        }
    }

    private class VarStat {
        int mode;
        int startRow;
        int rowLimit;
        int totalCount;
        Throwable error;

        private VarStat() {
        }

        void init() {
            this.mode = 0;
            this.startRow = 0;
            this.rowLimit = 0;
            this.totalCount = 0;
            this.error = null;
        }
    }

    public class ProgressStatus
    extends ProgressModel {
        BatchProcessingModel root;

        public ProgressStatus() {
            this.root = BatchProcessingModel.this;
        }

        @Override
        public int getValue() {
            return ((BatchProcessingModel)this.root).stat.startRow;
        }

        @Override
        public int getMaxValue() {
            return ((BatchProcessingModel)this.root).stat.totalCount;
        }

        public String getProgressValue() {
            Integer value = this.getValue();
            Integer maxvalue = this.getMaxValue();
            Double num = ((Number)value).doubleValue() / ((Number)maxvalue).doubleValue() * 100.0;
            return "" + ((Number)num).intValue() + "%";
        }

        public String getLabel() {
            int mode = ((BatchProcessingModel)this.root).stat.mode;
            if (mode == 2) {
                return "Operation cancelled.";
            }
            if (mode == 0) {
                return "Press Start to begin";
            }
            if (mode == 1) {
                int value = this.getValue();
                int maxvalue = this.getMaxValue();
                return "Processing Data...  (" + value + " of " + maxvalue + ")";
            }
            if (mode == 4) {
                return "Processed with errors...";
            }
            if (mode == 3) {
                return "Successfully processed " + this.getValue() + " items";
            }
            return "";
        }

        public String getMode() {
            int mode = ((BatchProcessingModel)this.root).stat.mode;
            if (mode == 2) {
                return "cancelled";
            }
            if (mode == 0) {
                return "init";
            }
            if (mode == 1) {
                return "processing";
            }
            if (mode == 4) {
                return "error";
            }
            if (mode == 3) {
                return "finish";
            }
            return null;
        }

        public Throwable getError() {
            return ((BatchProcessingModel)this.root).stat.error;
        }

        public String getErrorMessage() {
            Throwable t = this.getError();
            return t == null ? null : t.getMessage();
        }
    }
}

