/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.common;

import com.rameses.rcp.common.ProgressInfo;
import com.rameses.rcp.common.ScrollListModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AsyncListModel
extends ScrollListModel
implements Runnable,
ProgressInfo {
    private Thread thread;
    private boolean cancelled;
    private int batchNo;

    public void init() {
        if (this.isAutoStart()) {
            this.start();
        }
        this.refresh();
    }

    public void start() {
        if (this.thread != null) {
            return;
        }
        this.toprow = 0;
        this.pageIndex = 1;
        this.pageCount = 1;
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected int getDelay() {
        return 2000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetch(boolean forceLoad) {
        List dataList = this.getDataList();
        if (dataList == null) {
            return;
        }
        if (this.toprow > dataList.size()) {
            return;
        }
        List list = dataList;
        synchronized (list) {
            List subList = new ArrayList();
            if (this.maxRows > 0) {
                int tail = this.toprow + this.getRows();
                if (tail > dataList.size()) {
                    tail = dataList.size();
                }
                subList = dataList.subList(this.toprow, tail);
            }
            this.fillListItems(subList, this.toprow);
            if (this.getSelectedItem() != null) {
                this.pageIndex = this.getSelectedItem().getRownum() / this.getRows() + 1;
            } else {
                this.setSelectedItem(0);
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.toprow = 0;
        this.batchNo = 1;
        this.getListItems().clear();
        this.cancelled = false;
        int rowsize = this.getRows();
        while (!this.cancelled) {
            int startrow = (this.batchNo - 1) * rowsize;
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            this.onbeforeFetchList(params);
            params.put("_start", startrow);
            params.put("_rowsize", rowsize + 1);
            params.put("_limit", rowsize + 1);
            params.put("_batch", this.batchNo);
            ArrayList subList = this.fetchList(params);
            if (subList == null) {
                subList = new ArrayList();
            }
            this.onafterFetchList(subList);
            boolean firstTime = false;
            ArrayList dataList = this.getDataList();
            if (dataList == null) {
                firstTime = true;
                dataList = new ArrayList();
            }
            this.setDataList(dataList);
            ArrayList arrayList = dataList;
            synchronized (arrayList) {
                for (Object o : subList) {
                    if (dataList.indexOf(o) >= 0) continue;
                    dataList.add(o);
                }
                this.maxRows = dataList.size() - 1;
                if (this.isAllocNewRow()) {
                    ++this.maxRows;
                }
                this.pageCount = (this.maxRows + 1) / this.getRows() + ((this.maxRows + 1) % this.getRows() > 0 ? 1 : 0);
            }
            if (firstTime) {
                this.refresh();
            }
            if (subList.size() == 0) {
                this.cancelled = true;
            }
            if (params.get("cancel") != null) {
                try {
                    this.cancelled = Boolean.valueOf(params.get("cancel") + "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.cancelled) break;
            try {
                Thread.sleep(this.getDelay());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.batchNo;
        }
        this.thread = null;
    }

    @Override
    public int getEstimatedMaxSize() {
        return this.maxRows;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isStarted() {
        return this.thread != null;
    }

    protected boolean isAutoStart() {
        return false;
    }

    @Override
    protected void onfinalize() throws Throwable {
        this.cancelled = true;
    }
}

