/*
 * Decompiled with CFR 0.152.
 */
package system.tools.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class StatusInfoLayout
implements LayoutManager {
    private int gap;

    public StatusInfoLayout() {
        this(3);
    }

    public StatusInfoLayout(int gap) {
        this.gap = gap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!c.isVisible()) continue;
                Dimension dim = c.getPreferredSize();
                width += dim.width;
                height = Math.max(dim.height, height);
            }
            Insets margin = parent.getInsets();
            return new Dimension(width += margin.left + margin.right, height += margin.top + margin.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets margin = parent.getInsets();
            int pw = parent.getWidth();
            int ph = parent.getHeight();
            int x = margin.left;
            int y = margin.top;
            int h = ph - (margin.top + margin.bottom);
            int w = pw - margin.right;
            int visibleCount = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!c.isVisible()) continue;
                if (visibleCount > 0) {
                    x += this.gap;
                }
                Dimension dim = c.getPreferredSize();
                int rw = dim.width;
                if (i + 1 >= comps.length) {
                    rw = Math.max(w - x, 0);
                    rw = Math.max(rw, 60);
                }
                c.setBounds(x, y, rw, h);
                x += dim.width;
                ++visibleCount;
            }
        }
    }
}

