/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WindowTabbedPane
extends JTabbedPane {
    private ImageIcon defaultIcon;
    private ImageIcon overIcon;
    private ImageIcon pressIcon;
    private ImageIcon selCloseIcon;
    private PropertyTabSupport propertyTabSupport;
    private MouseTabSupport mouseTabSupport;
    private static final Object TABBEDPANE_CLOSE_ALL_ACTION = new Object();
    private static final Object TABBEDPANE_CLOSE_ACTION = new Object();
    private static final Object TABBEDPANE_MAX_WIN_ACTION = new Object();

    public WindowTabbedPane() {
        this.selCloseIcon = this.defaultIcon = this.createIcon("icon/tab_close_default.png");
        this.overIcon = this.createIcon("icon/tab_close_over.png");
        if (this.overIcon == null) {
            this.overIcon = this.defaultIcon;
        }
        this.pressIcon = this.createIcon("icon/tab_close_press.png");
        if (this.pressIcon == null) {
            this.pressIcon = this.overIcon;
        }
        this.addPropertyChangeListener(this.getPropertyTabSupport());
        this.addMouseListener(this.getMouseTabSupport());
        this.addMouseMotionListener(this.getMouseTabSupport());
        new CloseAllAction().install();
        new CloseAction().install();
        new MaxWinAction().install();
    }

    private PropertyTabSupport getPropertyTabSupport() {
        if (this.propertyTabSupport == null) {
            this.propertyTabSupport = new PropertyTabSupport();
        }
        return this.propertyTabSupport;
    }

    private MouseTabSupport getMouseTabSupport() {
        if (this.mouseTabSupport == null) {
            this.mouseTabSupport = new MouseTabSupport();
        }
        return this.mouseTabSupport;
    }

    @Override
    public void setMnemonicAt(int index, int mnemonic) {
        super.setMnemonicAt(index, mnemonic);
        this.getPropertyTabSupport().setMnemonicAt(index, mnemonic);
    }

    @Override
    public void setDisabledIconAt(int index, Icon icon) {
        super.setDisabledIconAt(index, icon);
        this.getPropertyTabSupport().setDisabledIconAt(index, icon);
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int index, int mnemonicIndex) {
        super.setDisplayedMnemonicIndexAt(index, mnemonicIndex);
        this.getPropertyTabSupport().setDisplayedMnemonicIndexAt(index, mnemonicIndex);
    }

    @Override
    public void setEnabledAt(int index, boolean enabled) {
        super.setEnabledAt(index, enabled);
        this.getPropertyTabSupport().setEnabledAt(index, enabled);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        this.getPropertyTabSupport().setIconAt(index, icon);
    }

    @Override
    public void setToolTipTextAt(int index, String tip) {
        super.setToolTipTextAt(index, tip);
        this.getPropertyTabSupport().setToolTipTextAt(index, tip);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            int index;
            this.getMouseTabSupport().setPopupInvoker(null);
            if (SwingUtilities.isRightMouseButton(e) && (index = this.getUI().tabForCoordinate(this, e.getX(), e.getY())) >= 0) {
                PopupInvoker pi = new PopupInvoker(e.getPoint(), index);
                this.getMouseTabSupport().setPopupInvoker(pi);
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.getMouseTabSupport().hasPopupInvoker()) {
            return;
        }
        super.setSelectedIndex(index);
    }

    @Override
    public void insertTab(String title, Icon icon, Component comp, String tip, int index) {
        super.insertTab(title, icon, comp, tip, index);
        Component tc = this.getTabComponentAt(index);
        if (tc instanceof JLabel) {
            return;
        }
        TabRenderer tr = new TabRenderer(title, icon, comp, tip, index);
        if (this.defaultIcon == null) {
            tr.setMargin(0, 0, 0, 15);
        } else {
            tr.setMargin(0, 0, 0, 20);
        }
        this.setTabComponentAt(index, tr);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int selIndex = this.getSelectedIndex();
        if (selIndex < 0) {
            return;
        }
        if (this.selCloseIcon == null) {
            return;
        }
        if (!this.isCloseable(selIndex)) {
            return;
        }
        Rectangle rect = this.getBoundsAt(selIndex);
        int iw = this.selCloseIcon.getIconWidth();
        int ih = this.selCloseIcon.getIconHeight();
        int x = rect.x + (rect.width - 16);
        int y = rect.y + Math.max((rect.height - ih) / 2, 0);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.drawImage(this.selCloseIcon.getImage(), x, y, null);
        g2.dispose();
    }

    private ImageIcon createIcon(String name) {
        try {
            URL url = WindowTabbedPane.class.getResource(name);
            return new ImageIcon(url);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private ImageIcon createEmptyIcon() {
        BufferedImage bi = new BufferedImage(1, 1, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(1));
        g2.fillRect(0, 0, 16, 16);
        g2.dispose();
        return new ImageIcon(bi);
    }

    private void close(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        if (!this.isCloseable(index)) {
            return;
        }
        Component comp = this.getComponentAt(index);
        if (this.beforeClose(comp)) {
            super.remove(index);
        }
    }

    private void closeAll() {
        this.closeAll(-1);
    }

    private void closeAll(int excludeIndex) {
        Component[] comps;
        Component xc = null;
        try {
            xc = this.getComponentAt(excludeIndex);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Component c : comps = this.getComponents()) {
            int idx = this.indexOfComponent(c);
            if (idx < 0 || !this.isCloseable(idx) || xc != null && xc.equals(c) || !this.beforeClose(c)) continue;
            super.remove(c);
        }
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        Component comp = this.getComponentAt(index);
        if (this.beforeClose(comp)) {
            super.remove(index);
        }
    }

    @Override
    public void remove(Component component) {
        if (component != null && this.beforeClose(component)) {
            super.remove(component);
        }
    }

    @Override
    public void removeTabAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        Component comp = this.getComponentAt(index);
        String title = this.getTitleAt(index);
        super.removeTabAt(index);
        this.afterClose(comp, title);
    }

    protected boolean beforeClose(Component component) {
        return true;
    }

    protected void afterClose(Component component, String title) {
    }

    protected boolean isCloseable(int index) {
        return true;
    }

    private class TabRenderer
    extends JLabel {
        private ImageIcon defaultIcon;
        private ImageIcon overIcon;
        private ImageIcon pressIcon;
        private int index;

        public TabRenderer() {
            this.initComponent();
        }

        public TabRenderer(String title, Icon icon, Component comp, String tip, int index) {
            this.index = index;
            this.initComponent();
            this.setText(title);
            this.setIcon(icon);
            this.setToolTipText(tip);
        }

        private void initComponent() {
            this.setIconTextGap(5);
            this.setMargin(0, 0, 0, 15);
        }

        void setMargin(int top, int left, int bottom, int right) {
            this.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        }
    }

    private class PropertyTabSupport
    implements PropertyChangeListener {
        WindowTabbedPane root;

        private PropertyTabSupport() {
            this.root = WindowTabbedPane.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            Object propValue = evt.getNewValue();
            if ("indexForTitle".equals(propName)) {
                if (!(propValue instanceof Integer)) {
                    return;
                }
                int index = (Integer)propValue;
                this.fireTitleChanged(index);
            } else if ("enabled".equals(propName)) {
                if (!(propValue instanceof Boolean)) {
                    return;
                }
                boolean enabled = (Boolean)propValue;
                this.fireEnabledChanged(enabled);
            }
        }

        private TabRenderer getRenderer(int index) {
            if (index < 0) {
                return null;
            }
            Component comp = this.root.getTabComponentAt(index);
            if (comp instanceof TabRenderer) {
                return (TabRenderer)comp;
            }
            return null;
        }

        private void fireTitleChanged(int index) {
            TabRenderer tr = this.getRenderer(index);
            if (tr == null) {
                return;
            }
            String title = this.root.getTitleAt(index);
            tr.setText(title);
        }

        private void fireEnabledChanged(boolean enabled) {
            int count = this.root.getTabCount();
            for (int i = 0; i < count; ++i) {
                this.root.setEnabledAt(i, enabled);
            }
        }

        private void setDisplayedMnemonicIndexAt(int index, int mnemonicIndex) {
            TabRenderer tr = this.getRenderer(index);
            if (tr != null) {
                tr.setDisplayedMnemonicIndex(mnemonicIndex);
            }
        }

        private void setMnemonicAt(int index, int mnemonic) {
            TabRenderer tr = this.getRenderer(index);
            if (tr != null) {
                tr.setDisplayedMnemonic(mnemonic);
            }
        }

        private void setDisabledIconAt(int index, Icon icon) {
            TabRenderer tr = this.getRenderer(index);
            if (tr != null) {
                tr.setDisabledIcon(icon);
            }
        }

        private void setIconAt(int index, Icon icon) {
            TabRenderer tr = this.getRenderer(index);
            if (tr != null) {
                tr.setIcon(icon);
            }
        }

        private void setEnabledAt(int index, boolean enabled) {
            TabRenderer tr = this.getRenderer(index);
            if (tr != null) {
                tr.setEnabled(this.root.isEnabledAt(index));
            }
        }

        private void setToolTipTextAt(int index, String tip) {
            TabRenderer tr = this.getRenderer(index);
            if (tr != null) {
                tr.setToolTipText(tip);
            }
        }
    }

    private class CloseTabRunnable
    implements Runnable {
        WindowTabbedPane root;
        private int index;

        CloseTabRunnable(int index) {
            this.root = WindowTabbedPane.this;
            this.index = index;
        }

        @Override
        public void run() {
            try {
                this.root.remove(this.index);
                this.root.selCloseIcon = this.root.defaultIcon;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class MaxWinAction
    extends AbstractAction {
        WindowTabbedPane root;
        private ActionListener delegate;
        private ActionListener callback;
        private KeyStroke keystroke;

        MaxWinAction() {
            this.root = WindowTabbedPane.this;
            this.keystroke = KeyStroke.getKeyStroke(27, 1);
        }

        void install() {
            InputMap inputMap = this.root.getInputMap(2);
            inputMap.put(this.keystroke, TABBEDPANE_MAX_WIN_ACTION);
            this.root.getActionMap().put(TABBEDPANE_MAX_WIN_ACTION, this);
        }

        void setCallback(ActionListener callback) {
            this.callback = callback;
        }

        void setDelegate(ActionListener delegate) {
            this.delegate = delegate;
        }

        JMenuItem createMenuItem() {
            JMenuItem jmi = new JMenuItem("Maximize Window");
            jmi.setAccelerator(this.keystroke);
            jmi.addActionListener(this);
            return jmi;
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MaxWinAction.this.actionPerformedImpl(e);
                }
            });
        }

        public void actionPerformedImpl(ActionEvent e) {
            try {
                if (this.delegate != null) {
                    this.delegate.actionPerformed(e);
                }
            }
            finally {
                if (this.callback != null) {
                    this.callback.actionPerformed(e);
                }
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        WindowTabbedPane root;
        private ActionListener delegate;
        private ActionListener callback;
        private KeyStroke keystroke;

        CloseAction() {
            this.root = WindowTabbedPane.this;
            this.keystroke = KeyStroke.getKeyStroke("ctrl W");
        }

        void install() {
            InputMap inputMap = this.root.getInputMap(2);
            inputMap.put(this.keystroke, TABBEDPANE_CLOSE_ACTION);
            this.root.getActionMap().put(TABBEDPANE_CLOSE_ACTION, this);
        }

        void setCallback(ActionListener callback) {
            this.callback = callback;
        }

        void setDelegate(ActionListener delegate) {
            this.delegate = delegate;
        }

        JMenuItem createMenuItem() {
            JMenuItem jmi = new JMenuItem("Close Window");
            jmi.setAccelerator(this.keystroke);
            jmi.addActionListener(this);
            return jmi;
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloseAction.this.actionPerformedImpl(e);
                }
            });
        }

        public void actionPerformedImpl(ActionEvent e) {
            try {
                if (this.delegate != null) {
                    this.delegate.actionPerformed(e);
                } else {
                    this.root.close(this.root.getSelectedIndex());
                }
            }
            finally {
                if (this.callback != null) {
                    this.callback.actionPerformed(e);
                }
            }
        }
    }

    private class CloseOtherAction
    extends AbstractAction {
        WindowTabbedPane root;
        private ActionListener callback;
        private ActionListener delegate;

        CloseOtherAction() {
            this.root = WindowTabbedPane.this;
        }

        void setCallback(ActionListener callback) {
            this.callback = callback;
        }

        void setDelegate(ActionListener delegate) {
            this.delegate = delegate;
        }

        JMenuItem createMenuItem() {
            JMenuItem jmi = new JMenuItem("Close Other Windows");
            jmi.addActionListener(this);
            return jmi;
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloseOtherAction.this.actionPerformedImpl(e);
                }
            });
        }

        public void actionPerformedImpl(ActionEvent e) {
            try {
                if (this.delegate != null) {
                    this.delegate.actionPerformed(e);
                }
            }
            finally {
                if (this.callback != null) {
                    this.callback.actionPerformed(e);
                }
            }
        }
    }

    private class CloseAllAction
    extends AbstractAction {
        WindowTabbedPane root;
        private KeyStroke keystroke;
        private ActionListener callback;

        CloseAllAction() {
            this.root = WindowTabbedPane.this;
            this.keystroke = KeyStroke.getKeyStroke("ctrl shift F4");
        }

        void install() {
            InputMap inputMap = this.root.getInputMap(2);
            inputMap.put(this.keystroke, TABBEDPANE_CLOSE_ALL_ACTION);
            this.root.getActionMap().put(TABBEDPANE_CLOSE_ALL_ACTION, this);
        }

        void setCallback(ActionListener callback) {
            this.callback = callback;
        }

        KeyStroke getKeyStroke() {
            return this.keystroke;
        }

        JMenuItem createMenuItem() {
            JMenuItem jmi = new JMenuItem("Close All Windows");
            jmi.setAccelerator(this.getKeyStroke());
            jmi.addActionListener(this);
            return jmi;
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloseAllAction.this.actionPerformedImpl(e);
                }
            });
        }

        public void actionPerformedImpl(ActionEvent e) {
            try {
                this.root.closeAll();
            }
            finally {
                if (this.callback != null) {
                    this.callback.actionPerformed(e);
                }
            }
        }
    }

    private class PopupInvoker
    implements Runnable {
        WindowTabbedPane root;
        private JPopupMenu popup;
        private Point location;
        private int index;

        PopupInvoker(Point location, int index) {
            this.root = WindowTabbedPane.this;
            this.location = location;
            this.index = index;
        }

        void setPopup(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void run() {
            int x = (int)this.location.getX();
            int y = (int)this.location.getY();
            this.popup.show(this.root, x, y);
        }
    }

    private class PopupMenuSupport {
        WindowTabbedPane root;
        private PopupInvoker popupInvoker;
        private JPopupMenu popup;
        private int index;

        PopupMenuSupport() {
            this.root = WindowTabbedPane.this;
            this.popup = new JPopupMenu();
            this.popup.add(this.createCloseAllMenuItem());
            this.popup.add(this.createCloseOthersMenuItem());
            this.popup.addSeparator();
            this.popup.add(this.createCloseMenuItem());
            this.popup.add(this.createMaxWinMenuItem());
        }

        void show(Point location) {
            if (this.popupInvoker == null) {
                return;
            }
            this.popupInvoker.location = location;
            this.popupInvoker.setPopup(this.popup);
            EventQueue.invokeLater(this.popupInvoker);
        }

        void reset() {
            this.popupInvoker = null;
        }

        JMenuItem createCloseAllMenuItem() {
            CloseAllAction a = new CloseAllAction();
            a.setCallback(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenuSupport.this.reset();
                }
            });
            return a.createMenuItem();
        }

        JMenuItem createCloseOthersMenuItem() {
            CloseOtherAction a = new CloseOtherAction();
            a.setDelegate(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PopupMenuSupport.this.root.closeAll(PopupMenuSupport.this.popupInvoker.index);
                    }
                    finally {
                        PopupMenuSupport.this.reset();
                    }
                }
            });
            return a.createMenuItem();
        }

        JMenuItem createCloseMenuItem() {
            CloseAction a = new CloseAction();
            a.setDelegate(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenuSupport.this.root.close(PopupMenuSupport.this.popupInvoker.index);
                }
            });
            a.setCallback(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PopupMenuSupport.this.reset();
                }
            });
            return a.createMenuItem();
        }

        JMenuItem createMaxWinMenuItem() {
            MaxWinAction a = new MaxWinAction();
            return a.createMenuItem();
        }
    }

    private class MouseTabSupport
    implements MouseListener,
    MouseMotionListener {
        WindowTabbedPane root;
        private boolean pressed;
        private int focusIndex;
        private PopupMenuSupport popupMenuSupport;

        private MouseTabSupport() {
            this.root = WindowTabbedPane.this;
        }

        private PopupMenuSupport getPopupMenuSupport() {
            if (this.popupMenuSupport == null) {
                this.popupMenuSupport = new PopupMenuSupport();
            }
            return this.popupMenuSupport;
        }

        boolean hasPopupInvoker() {
            return this.getPopupMenuSupport().popupInvoker != null;
        }

        void setPopupInvoker(PopupInvoker popupInvoker) {
            this.getPopupMenuSupport().popupInvoker = popupInvoker;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean b = this.hasIntersect(e);
            if (b) {
                if (this.focusIndex == this.root.getSelectedIndex()) {
                    this.root.selCloseIcon = this.root.pressIcon;
                } else {
                    this.root.selCloseIcon = this.root.defaultIcon;
                }
                this.pressed = true;
            } else {
                this.root.selCloseIcon = this.root.defaultIcon;
                this.pressed = false;
            }
            this.root.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.pressed = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            boolean b = this.hasIntersect(e);
            if (b) {
                this.root.selCloseIcon = this.root.overIcon;
                this.root.repaint();
                int selIndex = this.root.getSelectedIndex();
                if (this.focusIndex == selIndex) {
                    EventQueue.invokeLater(new CloseTabRunnable(selIndex));
                    return;
                }
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                int locIndex = this.root.getUI().tabForCoordinate(this.root, e.getX(), e.getY());
                if (locIndex >= 0) {
                    this.getPopupMenuSupport().show(e.getPoint());
                } else {
                    this.getPopupMenuSupport().reset();
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.pressed) {
                return;
            }
            this.focusIndex = this.root.getSelectedIndex();
            if (this.hasIntersect(e)) {
                this.root.selCloseIcon = this.root.overIcon;
            } else {
                this.root.selCloseIcon = this.root.defaultIcon;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MouseTabSupport.this.root.repaint();
                }
            });
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.pressed) {
                return;
            }
            boolean b = this.hasIntersect(e);
            if (b) {
                this.root.selCloseIcon = this.root.pressIcon;
            } else {
                this.root.selCloseIcon = this.root.defaultIcon;
            }
            this.focusIndex = this.root.getSelectedIndex();
            this.root.repaint();
        }

        private boolean hasIntersect(MouseEvent e) {
            int selIndex = this.root.getSelectedIndex();
            if (selIndex < 0) {
                return false;
            }
            if (!WindowTabbedPane.this.isCloseable(selIndex)) {
                return false;
            }
            Point p = e.getPoint();
            Rectangle rect = this.root.getBoundsAt(selIndex);
            if (!rect.contains(p)) {
                return false;
            }
            int w = rect.x + rect.width;
            return p.getX() >= (double)(w - 16) && p.getX() < (double)w;
        }
    }
}

